/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.utils.ssh;

import com.google.common.collect.Maps;
import com.jcraft.jsch.JSchException;
import com.mapr.fs.utils.ssh.SSHSession;
import java.util.Map;

public class SSHSessionManager {
    private static final Map<String, SSHSessionManager> sessionManagerMap = Maps.newHashMap();
    private static final String CURRENT_USER;
    private static final SSHSessionManager DEFAULT_SESSION_MANAGER;
    private final Map<String, SSHSession> sessionMap = Maps.newHashMap();
    private final String user;

    public SSHSessionManager(String user) {
        this.user = user;
    }

    public synchronized SSHSession getSession(String host) throws JSchException {
        String hostString = this.user + "@" + host;
        SSHSession session = this.sessionMap.get(hostString);
        if (session == null || !session.isConnected()) {
            session = new SSHSession(this.user, host);
            this.sessionMap.put(hostString, session);
        }
        return session;
    }

    public void shoutdown() {
        for (SSHSession session : this.sessionMap.values()) {
            if (!session.isConnected()) continue;
            session.disconnect();
        }
    }

    public static final synchronized SSHSessionManager getSessionManager(String user) {
        SSHSessionManager manager = sessionManagerMap.get(user);
        if (manager == null) {
            manager = new SSHSessionManager(user);
            sessionManagerMap.put(user, manager);
        }
        return manager;
    }

    public static SSHSessionManager getDefaultSessionManager() {
        return DEFAULT_SESSION_MANAGER;
    }

    static {
        String envUserName = System.getenv("MAPR_TEST_USER_NAME");
        CURRENT_USER = envUserName != null ? envUserName : System.getProperty("user.name", "root");
        DEFAULT_SESSION_MANAGER = new SSHSessionManager(CURRENT_USER);
    }
}

