/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFsDataInputStream;
import com.mapr.fs.MapRFsInStream;
import com.mapr.fs.MapRFsOutStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.Random;
import java.util.zip.CRC32;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ManyFilesTest {
    static final int RECORD_DATALEN = 93;
    static final int RECORD_LEN = 97;
    static final String LOCALTMPDIR = "/tmp/srivas/";

    static void pr(String s) {
        System.err.println(s);
    }

    public static void main(String[] args) throws Exception {
        int ac = 0;
        if (args.length < 2 || args.length > 5) {
            System.out.println("usage: ManyFilesTest rootDirOfTest [numFiles, def 20 [numThreads, def 4  [numRecords localFileName]]\nwhen numThreads is set to 0, we simply read the file upto numRecords, and compare with localFileName");
            return;
        }
        String rootDir = args[ac++];
        int numEntries = ac < args.length ? Integer.parseInt(args[ac++]) : 20;
        int numThreads = ac < args.length ? Integer.parseInt(args[ac++]) : 1;
        int numRecords = ac < args.length ? Integer.parseInt(args[ac++]) : 1;
        String localname = ac < args.length ? args[ac++] : "none";
        String uri = "maprfs://localhost:7222";
        Configuration conf = new Configuration();
        conf.set("fs.default.name", uri);
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        FileSystem fs = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
        if (numThreads > 0) {
            int i;
            Random rand = new Random(100L);
            FileInfo[] fileTab = new FileInfo[numEntries];
            Thread[] tid = new Thread[numThreads];
            for (i = 0; i < numThreads; ++i) {
                tid[i] = new FileThread(i, fileTab, rootDir, rand, fs);
                tid[i].start();
            }
            for (i = 0; i < numThreads; ++i) {
                tid[i].join();
            }
        } else {
            CRC32 crc = new CRC32();
            CRC32 crclocal = new CRC32();
            DataInputStream fins = new DataInputStream(new BufferedInputStream(new FileInputStream(localname)));
            if (fins == null) {
                ManyFilesTest.pr("***ERROR, opening localfile " + localname);
            }
            Path p = new Path(rootDir);
            FSDataInputStream is = fs.open(p);
            for (int k = 0; k < numRecords; ++k) {
                int bb;
                crc.reset();
                crclocal.reset();
                for (int z = 0; z < 93; ++z) {
                    bb = is.readByte();
                    crc.update(bb);
                    bb = fins.readByte();
                    crclocal.update(bb);
                }
                bb = is.readInt();
                int bblocal = fins.readInt();
                int crcval = (int)crc.getValue();
                int crclocalval = (int)crclocal.getValue();
                if (crcval != bb) {
                    ManyFilesTest.pr("****ERROR, crc from file " + bb + " does not match computed " + crcval + ", localcompcrc " + crclocalval + ", localfilecrc " + bblocal + ", file " + rootDir);
                    System.exit(98);
                }
                if (numRecords - k >= 10) continue;
                ManyFilesTest.pr("Record " + k + " crc " + crcval + ", readcrc " + bb + ", localcrc " + crclocalval + ", readlocal " + bblocal);
            }
            is.close();
            fins.close();
        }
    }

    static class FileInfo {
        String name;
        String dir;
        String fullname;
        String localname;
        int numRecords;
        int state;
        static final int AVAIL = 1;
        static final int WRITING = 2;
        static final int READING = 3;
        static final int AVAIL_RENAMED = 4;
        static final int READING_RENAMED = 5;

        FileInfo() {
        }
    }

    static class FileThread
    extends Thread {
        FileInfo[] fileTab;
        String rootDir;
        String renameDir;
        int numFiles;
        Random rand;
        FileSystem fs;
        CRC32 crc;
        int myid;

        FileThread(int id, FileInfo[] f, String dir, Random r, FileSystem mfs) {
            this.myid = id;
            this.fileTab = f;
            this.rootDir = dir;
            this.renameDir = dir + ".rename/";
            this.numFiles = f.length;
            this.rand = r;
            this.fs = mfs;
            this.crc = new CRC32();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            block36: {
                block35: {
                    try {
                        i = 0;
                        block10: while (i < this.numFiles * 10) {
                            var4_5 = this.fileTab;
                            // MONITORENTER : this.fileTab
                            do {
                                k = this.rand.nextInt(this.numFiles);
                                d = this.rand.nextInt(10);
                                f = this.fileTab[k];
                                if (f == null) {
                                    this.fileTab[k] = f = new FileInfo();
                                    f.dir = this.rootDir + "/dir." + d;
                                    f.name = "f." + k;
                                    f.fullname = f.dir + "/" + f.name;
                                    f.state = 2;
                                    f.numRecords = 100 * (d + k + 1);
                                } else if (f.state == 1) {
                                    f.state = 3;
                                } else if (f.state == 4) {
                                    f.state = 5;
                                } else {
                                    f = null;
                                }
                                ftabIdx = k;
                            } while (f == null);
                            // MONITOREXIT : var4_5
                            if (f.state == 2) {
                                p = new Path(f.dir);
                                if (!this.fs.mkdirs(p)) {
                                    ManyFilesTest.pr("***ERROR, mkdirs " + f.dir + " failed for file " + f.fullname);
                                    System.exit(99);
                                }
                                p = new Path(f.fullname);
                                os = this.fs.create(p);
                                mos = (MapRFsOutStream)os.getWrappedStream();
                                ManyFilesTest.pr(this.myid + ": " + i + ": state " + f.state + ": file " + f.fullname + ", fid " + mos.inode_.attrs_);
                                ldir = "/tmp/srivas/" + f.dir;
                                lDir = new File(ldir);
                                if (!lDir.isDirectory() && !lDir.mkdirs()) {
                                    ManyFilesTest.pr("***** mkdir " + ldir + " failed");
                                    System.exit(95);
                                }
                                f.localname = ldir + "/" + f.name;
                                outs = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f.localname)));
                                if (outs == null) {
                                    ManyFilesTest.pr("***** create localfile " + f.localname + " failed ");
                                    System.exit(94);
                                }
                                break block35;
                            }
                            if (f.state == 3 || f.state == 5) {
                                p = new Path(f.fullname);
                                is = this.fs.open(p);
                                inD = (MapRFsDataInputStream)is;
                                inF = (MapRFsInStream)inD.getWrappedStream();
                                ManyFilesTest.pr(this.myid + ": " + i + ": state " + f.state + ": file " + f.fullname + ", fid " + inF.inode_.attrs_);
                                fins = new DataInputStream(new BufferedInputStream(new FileInputStream(f.localname)));
                                k = 0;
                                break block36;
                            }
                            ManyFilesTest.pr("Wrong state " + f.state + " for file " + f.fullname);
                            System.exit(97);
lbl59:
                            // 4 sources

                            while (true) {
                                ++i;
                                continue block10;
                                break;
                            }
                        }
                        return;
                    }
                    catch (IOException e) {
                        ManyFilesTest.pr("***Exception " + e);
                    }
                    return;
                }
                for (k = 0; k < f.numRecords; ++k) {
                    bb = this.rand.nextInt(256);
                    this.crc.reset();
                    for (z = 0; z < 93; ++z) {
                        os.writeByte(bb);
                        outs.writeByte(bb);
                        this.crc.update(bb);
                        bb = (bb + 1) % 256;
                    }
                    crcval = (int)this.crc.getValue();
                    os.writeInt(crcval);
                    outs.writeInt(crcval);
                }
                os.close();
                outs.close();
                k = this.fileTab;
                // MONITORENTER : this.fileTab
                f.state = 1;
                // MONITOREXIT : k
                ** GOTO lbl59
            }
            while (true) {
                block38: {
                    block39: {
                        block37: {
                            if (k >= f.numRecords) break block37;
                            this.crc.reset();
                            break block38;
                        }
                        is.close();
                        fins.close();
                        if (f.state != 3) break block39;
                        oldname = f.fullname;
                        f.dir = this.renameDir + f.dir;
                        f.fullname = f.dir + "/" + f.name;
                        newpath = new Path(f.dir);
                        if (!this.fs.mkdirs(newpath)) {
                            ManyFilesTest.pr("***ERROR: mkdirs " + f.dir);
                            System.exit(96);
                        }
                        if (!this.fs.rename(p, newpath = new Path(f.fullname))) {
                            ManyFilesTest.pr("***ERROR, rename: " + oldname + " --> " + f.fullname);
                            System.exit(97);
                        }
                        var11_21 = this.fileTab;
                        // MONITORENTER : this.fileTab
                        f.state = 4;
                        // MONITOREXIT : var11_21
                        ** GOTO lbl59
                    }
                    if (!this.fs.delete(p, true)) {
                        ManyFilesTest.pr("***ERROR, delete " + f.fullname);
                        System.exit(97);
                    }
                    if (!(localf = new File(f.localname)).delete()) {
                        ManyFilesTest.pr("***ERROR, delete " + f.localname);
                        System.exit(93);
                    }
                    f = null;
                    var10_16 = this.fileTab;
                    // MONITORENTER : this.fileTab
                    this.fileTab[ftabIdx] = null;
                    // MONITOREXIT : var10_16
                    ** continue;
                }
                for (z = 0; z < 93; ++z) {
                    bb = is.readByte();
                    if (bb != (bblocal = fins.readByte())) {
                        ManyFilesTest.pr("****ERROR at pos: " + (k * 97 + z) + ", mapr byte " + bb + " does not match local byte " + bblocal + ", at record " + k + ", totalrecords " + f.numRecords + ", file " + f.fullname);
                        for (kk = 0; kk < 6; ++kk) {
                            bb = is.readByte();
                            bblocal = fins.readByte();
                            ManyFilesTest.pr(kk + ": mapr " + bb + ", local " + bblocal);
                        }
                        System.exit(98);
                    }
                    this.crc.update(bb);
                }
                bb = is.readInt();
                bblocal = fins.readInt();
                crcval = (int)this.crc.getValue();
                if (crcval != bb || bb != bblocal) {
                    ManyFilesTest.pr("****ERROR, read crc " + bb + " does not match comp " + crcval + ", localreadcrc " + bblocal + ", at record " + k + ", totalrecords " + f.numRecords + ", file " + f.fullname);
                    System.exit(98);
                }
                ++k;
            }
        }
    }
}

