/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;

public class TestBlockLocation
extends TestCase {
    private byte[] data;
    MapRFileSystem fs;
    Configuration conf;
    public static final Log LOG = LogFactory.getLog(TestBlockLocation.class);

    protected void setUp() throws Exception {
        this.fs = new MapRFileSystem();
        this.conf = new Configuration();
        try {
            URI uri = new URI("maprfs://127.0.0.1:7222");
            this.fs.initialize(uri, this.conf);
        }
        catch (Exception e) {
            System.out.println("Exception " + e + " occurred");
        }
        this.data = new byte[24576];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)(i % 10);
        }
    }

    protected void tearDown() throws Exception {
        this.fs.close();
    }

    public void testBlockInfo() throws IOException {
        Path f = new Path("/fmpap");
        FSDataOutputStream out = this.fs.create(f, true, 4096, (short)1, 65536L);
        out.write(this.data, 0, 8194);
        out.close();
        FileStatus fstatus = this.fs.getFileStatus(f);
        BlockLocation[] bloc = this.fs.getFileBlockLocations(fstatus, 0L, 16385L);
        if (bloc == null) {
            System.out.println("nul ********");
        } else {
            System.out.println("length = " + bloc.length);
        }
        for (int i = 0; i < bloc.length; ++i) {
            System.out.println("Fidmap entry " + i);
            String[] hosts = bloc[i].getNames();
            String[] names = bloc[i].getHosts();
            System.out.println("hosts length = " + hosts.length);
            System.out.println("names length = " + names.length);
            System.out.println("bloc offset = " + bloc[i].getOffset());
            System.out.println("bloc len = " + bloc[i].getLength());
            System.out.println(" host = " + hosts[0]);
            System.out.println(" name = " + names[0]);
        }
    }
}

