/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFsDataInputStream;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class RWManyFilesTest {
    static final String uri = "maprfs:///";

    public static void Fillbuf(byte[] buf) {
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = (byte)i;
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 3 || args.length > 4) {
            System.err.println("usage: RWManyFilesTest filename [-]num8kBlocks [ numfiles, def 80 ]");
            System.exit(1);
        }
        int ac = 0;
        String filename = args[ac++];
        int numblocks = Integer.parseInt(args[ac++]);
        int numFiles = args.length == ac ? 80 : Integer.parseInt(args[ac++]);
        Configuration conf = new Configuration();
        conf.set("fs.maprfs.impl", "com.mapr.fs.MapRFileSystem");
        conf.set("fs.default.name", uri);
        byte[] b = new byte[8192];
        RWManyFilesTest.Fillbuf(b);
        boolean writing = true;
        if (numblocks < 0) {
            writing = false;
            numblocks = -numblocks;
        }
        FileSystem fs = FileSystem.get((URI)URI.create(uri), (Configuration)conf);
        long sT = System.currentTimeMillis();
        for (int i = 0; i < numFiles; ++i) {
            int k;
            String fname = filename + "." + i;
            Path p = new Path(fname);
            if (writing) {
                FSDataOutputStream out = fs.create(p);
                for (k = 0; k < numblocks; ++k) {
                    out.write(b, 0, b.length);
                }
                out.close();
                continue;
            }
            FSDataInputStream in = fs.open(p);
            for (k = 0; k < numblocks; ++k) {
                in.read(b, 0, b.length);
            }
            MapRFsDataInputStream min = (MapRFsDataInputStream)in;
            try {
                min.adviseFile(FSDataInputStream.FadviseType.FILE_DONTNEED, 0L, 0L);
            }
            catch (IOException ioe) {
                System.err.println("Error in adviseFile : " + ioe);
            }
            in.close();
        }
        long eT = System.currentTimeMillis();
        double rate = numblocks;
        rate *= (double)numFiles;
        rate *= 8192.0;
        rate /= (double)(eT -= sT);
        String label = writing ? "Write rate: " : "Read rate: ";
        System.out.println(label + (rate /= 1000.0) + " M/s");
    }
}

