/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs;

import com.mapr.fs.MapRFileStatus;
import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;

public class TestAttr
extends TestCase {
    private byte[] data;
    MapRFileSystem fs;
    Configuration conf;
    public static final Log LOG = LogFactory.getLog(TestAttr.class);

    protected void setUp() throws Exception {
        this.fs = new MapRFileSystem();
        this.conf = new Configuration();
        try {
            URI uri = new URI("maprfs://127.0.0.1:7222");
            this.fs.initialize(uri, this.conf);
        }
        catch (Exception e) {
            System.out.println("Exception " + e + " occurred");
        }
        this.data = new byte[24576];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)(i % 10);
        }
    }

    protected void tearDown() throws Exception {
        this.fs.close();
    }

    public void testAttr() throws IOException {
        Path dirpath = new Path("/t.txt");
        FSDataOutputStream os = this.fs.create(dirpath, FsPermission.getDefault(), true, 4096, (short)1, 65536L, null);
        os.close();
        Path dirp = new Path("/dirperm");
        this.fs.mkdirs(dirp, FsPermission.getDefault());
        FileStatus f = this.fs.getFileStatus(dirpath);
        System.out.println("FileLen " + f.getLen());
        System.out.println("BlockSize " + f.getBlockSize());
        System.out.println("Repl " + f.getReplication());
        System.out.println("IsDir " + f.isDir());
        System.out.println("Permission " + f.getPermission());
        System.out.println("Group " + f.getGroup());
        System.out.println("Owner " + f.getOwner());
    }

    public void testListStatus() throws IOException {
        Path dirpath = new Path("/");
        for (MapRFileStatus s : this.fs.listStatus(dirpath)) {
            System.out.println("FileLen " + s.getLen());
            System.out.println("BlockSize " + s.getBlockSize());
            System.out.println("IsDir " + s.isDir());
            System.out.println("Permission " + s.getPermission());
            System.out.println("path = " + s.getPath());
            System.out.println("Qpath = " + s.getPath().makeQualified((FileSystem)this.fs));
        }
    }

    public void testSetAttr() throws IOException {
        Path f = new Path("/junk");
        this.fs.create(f, true).close();
        FsPermission p = new FsPermission(438);
        this.fs.setPermission(f, p);
    }
}

