/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.fs.MapRHTable;
import com.mapr.fs.hbase.PutConverter;
import com.mapr.fs.jni.MapRPut;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class BulkLoadRecordWriter<V extends Cell>
extends RecordWriter<ImmutableBytesWritable, V> {
    private static final Log LOG = LogFactory.getLog(BulkLoadRecordWriter.class);
    private final MapRHTable mapRTable = new MapRHTable();
    private long bulkLoaderId;
    private KeyValue prevKeyValue;
    private byte[] curRow;
    private byte[] curFamilyName;
    private List<KeyValue> curFamilyList;
    private Map<byte[], List<KeyValue>> curFamilyMap;
    private List<MapRPut> bufferedPuts;
    private int totalBufferedLen;
    private final byte[] now;
    private byte[] tableUuid;

    public BulkLoadRecordWriter(Configuration conf, Path tablePath) throws IOException {
        this.mapRTable.init(conf, tablePath);
        this.bulkLoaderId = 0L;
        this.prevKeyValue = null;
        this.curRow = null;
        this.curFamilyName = null;
        this.curFamilyList = null;
        this.curFamilyMap = new TreeMap<byte[], List<KeyValue>>(Bytes.BYTES_COMPARATOR);
        this.bufferedPuts = new ArrayList<MapRPut>();
        this.totalBufferedLen = 0;
        String uuid = conf.get("maprdb.bulkload.uuid");
        this.tableUuid = (byte[])(uuid != null ? Bytes.toBytesBinary((String)uuid) : null);
        this.now = Bytes.toBytes((long)System.currentTimeMillis());
    }

    public void write(ImmutableBytesWritable row, V cell) throws IOException {
        this.open();
        KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
        if (row == null && kv == null) {
            this.appendRow();
            this.flush();
            return;
        }
        kv.updateLatestStamp(this.now);
        if (this.prevKeyValue != null) {
            int cmp = KeyValue.COMPARATOR.compare((Cell)this.prevKeyValue, (Cell)kv);
            if (cmp == 0) {
                LOG.warn((Object)("Ignoring duplicate keyvalue " + kv));
                return;
            }
            if (cmp > 0) {
                throw new IOException("Received unsorted KeyValues : prev " + this.prevKeyValue + " cur " + kv);
            }
        }
        if (kv.isDelete()) {
            throw new IOException("Deletes are not supported");
        }
        byte[] rowKey = kv.getRow();
        if (this.curRow != null && Bytes.compareTo((byte[])this.curRow, (byte[])rowKey) != 0) {
            this.appendRow();
            this.potentiallyFlush();
        }
        if (this.curRow == null) {
            this.curRow = rowKey;
        }
        byte[] family = kv.getFamily();
        if (this.curFamilyName != null && Bytes.compareTo((byte[])this.curFamilyName, (byte[])family) != 0) {
            this.curFamilyName = null;
            this.curFamilyList = null;
        }
        if (this.curFamilyName == null) {
            this.curFamilyName = family;
            this.curFamilyList = new ArrayList<KeyValue>();
            this.curFamilyMap.put(this.curFamilyName, this.curFamilyList);
        }
        this.prevKeyValue = kv;
        this.curFamilyList.add(kv);
    }

    private void appendRow() throws IOException {
        if (this.curRow != null) {
            MapRPut mput = PutConverter.sortedKeyValuesToMapRPut(this.curRow, this.curFamilyMap, this.mapRTable);
            this.totalBufferedLen = (int)((long)this.totalBufferedLen + mput.rowTotalBytes());
            this.bufferedPuts.add(mput);
            this.curRow = null;
            this.curFamilyName = null;
            this.curFamilyList = null;
            this.curFamilyMap.clear();
        }
    }

    private void potentiallyFlush() throws IOException {
        if (this.bufferedPuts.size() >= 100 || this.totalBufferedLen >= 0x100000) {
            this.flush();
        }
    }

    private void open() throws IOException {
        if (this.bulkLoaderId == 0L) {
            this.bulkLoaderId = this.mapRTable.getBulkLoader(this.tableUuid);
        }
    }

    private void flush() throws IOException {
        if (this.bulkLoaderId == 0L || this.bufferedPuts.size() == 0) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("flushing " + this.bufferedPuts.size() + " rows"));
        }
        MapRPut[] mputs = this.bufferedPuts.toArray(new MapRPut[this.bufferedPuts.size()]);
        this.mapRTable.bulkLoaderAppend(this.bulkLoaderId, mputs);
        this.bufferedPuts.clear();
        this.totalBufferedLen = 0;
    }

    public void close(TaskAttemptContext c) throws IOException, InterruptedException {
        if (this.bulkLoaderId == 0L) {
            return;
        }
        this.appendRow();
        this.flush();
        this.mapRTable.bulkLoaderClose(this.bulkLoaderId);
        this.bulkLoaderId = 0L;
    }
}

