/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.baseutils.BinaryString;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.hbase.CellUtilProxy;
import com.mapr.fs.jni.MapRCallBackQueue;
import com.mapr.fs.jni.MapRKeyValue;
import com.mapr.fs.jni.MapRPut;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.OperationWithAttributes;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.util.Bytes;

public class PutConverter {
    public static MapRPut toMapRPut(Delete delete, MapRHTable htable) throws IOException {
        return PutConverter.toMapRPut(delete, htable, null, null);
    }

    public static MapRPut toMapRPut(Delete delete, MapRHTable htable, Object request, MapRCallBackQueue cbq) throws IOException {
        NavigableMap familyMap = delete.getFamilyMap();
        if (familyMap.size() == 0) {
            byte type = 17;
            if (cbq != null) {
                type = 19;
            }
            return PutConverter.createMapRPut(delete.getRow(), PutConverter.getTableUUID((OperationWithAttributes)delete), familyMap, type, delete.getTimeStamp(), htable, false, false, request, cbq);
        }
        byte type = 20;
        if (cbq != null) {
            type = 25;
        }
        return PutConverter.createMapRPut(delete.getRow(), PutConverter.getTableUUID((OperationWithAttributes)delete), familyMap, type, delete.getTimeStamp(), htable, false, true, request, cbq);
    }

    public static MapRPut toMapRPut(Append append, MapRHTable htable) throws IOException {
        return PutConverter.toMapRPut(append, htable, null, null);
    }

    public static MapRPut toMapRPut(Append append, MapRHTable htable, Object request, MapRCallBackQueue cbq) throws IOException {
        byte type = 0;
        if (cbq != null) {
            type = 2;
        }
        return PutConverter.createMapRPut(append.getRow(), PutConverter.getTableUUID((OperationWithAttributes)append), append.getFamilyMap(), type, append.getTimeStamp(), htable, false, false, request, cbq);
    }

    public static MapRPut toMapRPut(Put put, MapRHTable htable) throws IOException {
        return PutConverter.toMapRPut(put, htable, null, null);
    }

    public static MapRPut toMapRPut(Put put, MapRHTable htable, Object request, MapRCallBackQueue cbq) throws IOException {
        byte type = 0;
        if (cbq != null) {
            type = 2;
        }
        return PutConverter.createMapRPut(put.getRow(), PutConverter.getTableUUID((OperationWithAttributes)put), put.getFamilyMap(), type, put.getTimeStamp(), htable, false, false, request, cbq);
    }

    public static MapRPut sortedKeyValuesToMapRPut(byte[] key, Map<byte[], List<KeyValue>> familyMap, MapRHTable htable) throws IOException {
        return PutConverter.createMapRPut(key, null, familyMap, (byte)0, 0L, htable, true, false, null, null);
    }

    public static MapRPut createMapRPut(byte[] key, byte[] tableUuid, Map<byte[], List<KeyValue>> familyMap, byte type, long rowTimeStamp, MapRHTable htable, boolean sortedCells, boolean deleteCell, Object request, MapRCallBackQueue cbq) throws IOException, NoSuchColumnFamilyException {
        int id = 0;
        if (cbq != null && request == null) {
            throw new IOException("This put is specified as buffered put with a callback queue, however, the requested put object is missing.");
        }
        MapRPut mrput = new MapRPut(request, cbq);
        mrput.numFamilies = 0;
        mrput.numCells = 0;
        mrput.type = type;
        mrput.rowTimeStamp = rowTimeStamp;
        TreeMap<Integer, List<KeyValue>> familyIdMap = new TreeMap<Integer, List<KeyValue>>();
        for (Map.Entry<byte[], List<KeyValue>> entry : familyMap.entrySet()) {
            List<KeyValue> cells = entry.getValue();
            if (cells.size() <= 0) continue;
            try {
                id = htable.getFamilyId(Bytes.toString((byte[])entry.getKey()));
            }
            catch (IOException ioe) {
                throw (NoSuchColumnFamilyException)new NoSuchColumnFamilyException(ioe.toString()).initCause((Throwable)ioe);
            }
            if (!sortedCells && !htable.isJson()) {
                Collections.sort(cells, KeyValue.COMPARATOR);
            }
            familyIdMap.put(id, cells);
            ++mrput.numFamilies;
            mrput.numCells += cells.size();
        }
        mrput.key = key;
        mrput.tableUuid = tableUuid;
        mrput.rowTotalBytes += (long)(mrput.key.length + 8);
        if (mrput.numCells > 0) {
            mrput.families = new int[mrput.numFamilies];
            mrput.keyvals = new MapRKeyValue[mrput.numCells];
            mrput.cellsPerFamily = new int[mrput.numFamilies];
            int ccount = 0;
            int fcount = 0;
            for (Map.Entry entry : familyIdMap.entrySet()) {
                mrput.families[fcount] = (Integer)entry.getKey();
                mrput.cellsPerFamily[fcount] = 0;
                List cells = (List)entry.getValue();
                int lb = 0;
                while (lb < cells.size()) {
                    int i;
                    int ub;
                    for (ub = lb; ub < cells.size() && ub != cells.size() - 1 && Bytes.compareTo((byte[])((KeyValue)cells.get(ub)).getQualifier(), (byte[])((KeyValue)cells.get(ub + 1)).getQualifier()) == 0; ++ub) {
                    }
                    TreeMap<Long, KeyValue> cellTreeMap = new TreeMap<Long, KeyValue>();
                    for (i = lb; i <= ub; ++i) {
                        KeyValue cell = (KeyValue)cells.get(i);
                        cellTreeMap.put(cell.getTimestamp(), cell);
                    }
                    i = 0;
                    for (KeyValue kv : cellTreeMap.descendingMap().values()) {
                        boolean deleteColumn = false;
                        if (deleteCell && CellUtilProxy.isDeleteType((Cell)kv, kv)) {
                            deleteColumn = true;
                        }
                        mrput.keyvals[ccount] = new MapRKeyValue(kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength(), kv.getValueOffset(), kv.getValueLength(), kv.getTimestamp(), i == 0, i == cellTreeMap.size() - 1, deleteColumn);
                        mrput.rowTotalBytes += (long)(kv.getQualifierLength() + kv.getValueLength() + 8);
                        int n = fcount;
                        mrput.cellsPerFamily[n] = mrput.cellsPerFamily[n] + 1;
                        ++ccount;
                        ++i;
                    }
                    lb = ub + 1;
                }
                ++fcount;
            }
        }
        return mrput;
    }

    private static byte[] getTableUUID(OperationWithAttributes op) {
        byte[] uuidStr = op.getAttribute("MAPR_UUID");
        return uuidStr == null ? null : BinaryString.fromUUIDString((String)Bytes.toString((byte[])uuidStr));
    }
}

