/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase;

import com.mapr.fs.MapRClientImpl;
import com.mapr.fs.MapRHTable;
import com.mapr.fs.hbase.RowColKeyValue;
import com.mapr.fs.jni.MapRGet;
import com.mapr.fs.jni.MapRIncrement;
import com.mapr.fs.jni.MapRKeyValue;
import com.mapr.fs.jni.MapRPut;
import com.mapr.fs.jni.MapRResult;
import com.mapr.fs.jni.MapRRowConstraint;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class ResultConverter {
    public static Result createHBaseResult(MapRGet mget, MapRHTable htable) throws IOException {
        byte[] key = mget.getKey();
        Result result = ResultConverter.toHBaseResult(mget.getResult(), key, key.length, htable, null);
        return result;
    }

    public static Result[] createHBaseResult(MapRGet[] mgets, MapRHTable htable) throws IOException {
        long diff;
        long start = 0L;
        long end = 0L;
        int thresh = MapRClientImpl.getSlowOpsThreshold();
        if (thresh > 0) {
            start = System.currentTimeMillis();
        }
        long arenaAddr = mgets[0].getArena();
        mgets[0].setArena(0L);
        Arrays.sort(mgets, new Comparator<MapRGet>(){

            @Override
            public int compare(MapRGet o1, MapRGet o2) {
                return o1.listIndex < o2.listIndex ? -1 : (o1.listIndex == o2.listIndex ? 0 : 1);
            }
        });
        mgets[0].setArena(arenaAddr);
        Result[] res = new Result[mgets.length];
        for (int i = 0; i < mgets.length; ++i) {
            byte[] key = mgets[i].getKey();
            res[i] = ResultConverter.toHBaseResult(mgets[i].getResult(), key, key.length, htable, null);
        }
        if (thresh > 0 && (int)(diff = (end = System.currentTimeMillis()) - start) >= thresh) {
            System.err.println("createHbaseResult for table " + htable.getInode().filename() + " took " + diff + " ms");
        }
        return res;
    }

    public static Result toHBaseResult(MapRResult mresult, MapRHTable htable, Map<Integer, String> familyIdMap) throws IOException {
        return ResultConverter.toHBaseResult(mresult, mresult.bufBytes, mresult.keyLength, htable, familyIdMap);
    }

    public static Result toHBaseResult(MapRResult mresult, byte[] key, int keyLength, MapRHTable htable, Map<Integer, String> familyIdMap) throws IOException {
        long diff;
        if (mresult == null || mresult.isEmpty()) {
            return new Result(new KeyValue[0]);
        }
        long start = 0L;
        long end = 0L;
        int thresh = MapRClientImpl.getSlowOpsThreshold();
        if (thresh > 0) {
            start = System.currentTimeMillis();
        }
        int cellPos = 0;
        int columnPos = 0;
        boolean totalResultSize = false;
        Object[] families = new FamilyNameIdMap[mresult.cfIds.length];
        for (int f = 0; f < mresult.cfIds.length; ++f) {
            try {
                byte[] cfname = htable != null ? Bytes.toBytes((String)htable.getFamilyName(mresult.cfIds[f])) : Bytes.toBytes((String)familyIdMap.get(mresult.cfIds[f]));
                families[f] = new FamilyNameIdMap(f, cfname, columnPos, cellPos);
                for (int c = 0; c < mresult.cellsPerFamily[f]; ++c) {
                    cellPos += mresult.versions[columnPos];
                    ++columnPos;
                }
                continue;
            }
            catch (IOException ioe) {
                throw new IOException("Stale column family id=" + mresult.cfIds[f], ioe);
            }
        }
        Arrays.sort(families);
        ArrayList<RowColKeyValue> kvs = new ArrayList<RowColKeyValue>(cellPos);
        cellPos = 0;
        columnPos = 0;
        for (int f = 0; f < mresult.cfIds.length; ++f) {
            int index = ((FamilyNameIdMap)families[f]).index;
            byte[] cfname = ((FamilyNameIdMap)families[f]).name;
            columnPos = ((FamilyNameIdMap)families[f]).columnPos;
            cellPos = ((FamilyNameIdMap)families[f]).cellPos;
            for (int c = 0; c < mresult.cellsPerFamily[index]; ++c) {
                for (int v = 0; v < mresult.versions[columnPos]; ++v) {
                    kvs.add(new RowColKeyValue(key, (short)keyLength, cfname, mresult.bufBytes, mresult.columnOffsets[columnPos], mresult.columnLengths[columnPos], mresult.valueOffsets[cellPos], mresult.valueLengths[cellPos], mresult.timestamps[cellPos]));
                    ++cellPos;
                }
                ++columnPos;
            }
        }
        if (thresh > 0 && (int)(diff = (end = System.currentTimeMillis()) - start) >= thresh) {
            if (htable != null) {
                System.err.println("toHbaseResult for table " + htable.getInode().filename() + " took " + diff + " ms");
            } else {
                System.err.println("toHbaseResult took " + diff + " ms");
            }
        }
        return Result.create(kvs);
    }

    public static Result createHBaseResult(MapRIncrement incr, MapRHTable htable) throws IOException {
        if (incr.newValues.length != incr.rowConstraint.numColumns) {
            throw new IOException(String.format("Mistmatch in increment request (%d) and reply (%d).", incr.rowConstraint.numColumns, incr.newValues.length));
        }
        int cellPos = 0;
        int totalResultSize = 0;
        MapRRowConstraint rc = incr.rowConstraint;
        int kBaseRowInfraSize = ResultConverter.getBaseRowInfraSize(incr.key.length);
        Object[] families = new FamilyNameIdMap[rc.families.length];
        for (int f = 0; f < rc.families.length; ++f) {
            try {
                byte[] cfname = Bytes.toBytes((String)htable.getFamilyName(rc.families[f]));
                int kBaseCFInfraSize = kBaseRowInfraSize + cfname.length;
                families[f] = new FamilyNameIdMap(f, cfname, 0, cellPos);
                for (int c = 0; c < rc.columnsPerFamily[f]; ++c) {
                    totalResultSize += kBaseCFInfraSize + rc.columns[cellPos].length + 8;
                    ++cellPos;
                }
                continue;
            }
            catch (IOException ioe) {
                throw new IOException("Stale column family id=" + rc.families[f], ioe);
            }
        }
        Arrays.sort(families);
        cellPos = 0;
        int resultBufferOffset = 0;
        byte[] resultBuffer = new byte[totalResultSize];
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        for (int f = 0; f < rc.numFamilies; ++f) {
            int index = ((FamilyNameIdMap)families[f]).index;
            byte[] family = ((FamilyNameIdMap)families[f]).name;
            cellPos = ((FamilyNameIdMap)families[f]).cellPos;
            for (int c = 0; c < rc.columnsPerFamily[index]; ++c) {
                byte[] qualifier = rc.columns[cellPos];
                byte[] value = Bytes.toBytes((long)incr.newValues[cellPos]);
                int newOffset = ResultConverter.layoutKeyValue(resultBuffer, resultBufferOffset, incr.key, family, qualifier, value, incr.timestamp);
                kvs.add(new KeyValue(resultBuffer, resultBufferOffset += 4, newOffset - resultBufferOffset));
                resultBufferOffset = newOffset;
                ++cellPos;
            }
        }
        return new Result(kvs);
    }

    public static Result toHBaseResult(MapRPut mput, MapRHTable htable) throws IOException {
        if (mput == null || mput.getKeyValues() == null || mput.numCells == 0) {
            return new Result(new KeyValue[0]);
        }
        int cellPos = 0;
        int totalResultSize = 0;
        MapRKeyValue[] mcells = mput.getKeyValues();
        int kBaseRowInfraSize = ResultConverter.getBaseRowInfraSize(mput.key.length);
        Object[] families = new FamilyNameIdMap[mput.families.length];
        for (int f = 0; f < mput.families.length; ++f) {
            try {
                byte[] cfname = Bytes.toBytes((String)htable.getFamilyName(mput.families[f]));
                int kBaseCFInfraSize = kBaseRowInfraSize + cfname.length;
                families[f] = new FamilyNameIdMap(f, cfname, 0, cellPos);
                for (int c = 0; c < mput.cellsPerFamily[f]; ++c) {
                    totalResultSize += kBaseCFInfraSize + mcells[cellPos].getColumnLength() + mcells[cellPos].getValue().length;
                    ++cellPos;
                }
                continue;
            }
            catch (IOException ioe) {
                throw new IOException("Stale column family id=" + mput.families[f], ioe);
            }
        }
        Arrays.sort(families);
        cellPos = 0;
        int resultBufferOffset = 0;
        byte[] resultBuffer = new byte[totalResultSize];
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        for (int f = 0; f < mput.numFamilies; ++f) {
            int index = ((FamilyNameIdMap)families[f]).index;
            byte[] family = ((FamilyNameIdMap)families[f]).name;
            cellPos = ((FamilyNameIdMap)families[f]).cellPos;
            for (int c = 0; c < mput.cellsPerFamily[index]; ++c) {
                MapRKeyValue mcell = mcells[cellPos];
                int newOffset = ResultConverter.layoutKeyValue(resultBuffer, resultBufferOffset, mput.key, 0, mput.key.length, family, 0, family.length, mcell.getBuffer(), mcell.getColumnOffset(), mcell.getColumnLength(), mcell.getValue(), 0, mcell.getValue().length, mput.rowTimeStamp);
                kvs.add(new KeyValue(resultBuffer, resultBufferOffset += 4, newOffset - resultBufferOffset));
                resultBufferOffset = newOffset;
                ++cellPos;
            }
        }
        return new Result(kvs);
    }

    private static int layoutKeyValue(byte[] resultBuffer, int resultBufferOffset, byte[] rowkey, byte[] family, byte[] qualifier, byte[] value, long timestamp) {
        return ResultConverter.layoutKeyValue(resultBuffer, resultBufferOffset, rowkey, 0, rowkey.length, family, 0, family == null ? 0 : family.length, qualifier, 0, qualifier == null ? 0 : qualifier.length, value, 0, value == null ? 0 : value.length, timestamp);
    }

    private static int layoutKeyValue(byte[] resultBuffer, int resultBufferOffset, byte[] rowKey, int rowKeyOffset, int rowKeyLen, byte[] family, int familyOffset, int familyLen, byte[] qualifier, int qualifierOffset, int qualifierLen, byte[] value, int valueOffset, int valueLen, long timestamp) {
        int pos = ResultConverter.layoutUptoFamily(resultBuffer, resultBufferOffset, rowKey, rowKeyOffset, rowKeyLen, family, familyOffset, familyLen, qualifierLen, valueLen);
        if (qualifierLen > 0) {
            pos = Bytes.putBytes((byte[])resultBuffer, (int)pos, (byte[])qualifier, (int)qualifierOffset, (int)qualifierLen);
        }
        pos = Bytes.putLong((byte[])resultBuffer, (int)pos, (long)timestamp);
        pos = Bytes.putByte((byte[])resultBuffer, (int)pos, (byte)KeyValue.Type.Put.getCode());
        if (valueLen > 0) {
            pos = Bytes.putBytes((byte[])resultBuffer, (int)pos, (byte[])value, (int)valueOffset, (int)valueLen);
        }
        return pos;
    }

    private static int layoutKeyValue(ByteBuffer byteBuffer, byte[] resultBuffer, int resultBufferOffset, byte[] rowKey, byte[] family, int qualifierOffset, int qualifierLen, int valueOffset, int valueLen, long timestamp) {
        return ResultConverter.layoutKeyValue(byteBuffer, resultBuffer, resultBufferOffset, rowKey, 0, rowKey.length, family, 0, family == null ? 0 : family.length, qualifierOffset, qualifierLen, valueOffset, valueLen, timestamp);
    }

    private static int layoutKeyValue(ByteBuffer byteBuffer, byte[] resultBuffer, int resultBufferOffset, byte[] rowKey, int rowKeyOffset, int rowKeyLen, byte[] family, int familyOffset, int familyLen, int qualifierOffset, int qualifierLen, int valueOffset, int valueLen, long timestamp) {
        int pos = ResultConverter.layoutUptoFamily(resultBuffer, resultBufferOffset, rowKey, rowKeyOffset, rowKeyLen, family, familyOffset, familyLen, qualifierLen, valueLen);
        if (qualifierLen != 0) {
            byteBuffer.position(qualifierOffset);
            byteBuffer.get(resultBuffer, pos, qualifierLen);
            pos += qualifierLen;
        }
        pos = Bytes.putLong((byte[])resultBuffer, (int)pos, (long)timestamp);
        pos = Bytes.putByte((byte[])resultBuffer, (int)pos, (byte)KeyValue.Type.Put.getCode());
        if (valueLen > 0) {
            byteBuffer.position(valueOffset);
            byteBuffer.get(resultBuffer, pos, valueLen);
            pos += valueLen;
        }
        return pos;
    }

    private static int layoutUptoFamily(byte[] resultBuffer, int resultBufferOffset, byte[] rowKey, int rowKeyOffset, int rowKeyLen, byte[] family, int familyOffset, int familyLen, int qualifierLen, int valueLen) {
        int keyLength = ResultConverter.getKeySize(rowKeyLen, familyLen, qualifierLen, valueLen);
        int keyValueLength = 8 + keyLength + valueLen;
        int pos = resultBufferOffset;
        pos = Bytes.putInt((byte[])resultBuffer, (int)pos, (int)keyValueLength);
        pos = Bytes.putInt((byte[])resultBuffer, (int)pos, (int)keyLength);
        pos = Bytes.putInt((byte[])resultBuffer, (int)pos, (int)valueLen);
        pos = Bytes.putShort((byte[])resultBuffer, (int)pos, (short)((short)(rowKeyLen & 0xFFFF)));
        pos = Bytes.putBytes((byte[])resultBuffer, (int)pos, (byte[])rowKey, (int)rowKeyOffset, (int)rowKeyLen);
        pos = Bytes.putByte((byte[])resultBuffer, (int)pos, (byte)((byte)(familyLen & 0xFF)));
        if (familyLen != 0) {
            pos = Bytes.putBytes((byte[])resultBuffer, (int)pos, (byte[])family, (int)familyOffset, (int)familyLen);
        }
        return pos;
    }

    private static int getBaseRowInfraSize(int rowKeyLength) {
        return 24 + rowKeyLength;
    }

    private static int getKeySize(int rowKeyLen, int familyLen, int qualifierLen, int valueLen) {
        if (rowKeyLen > Short.MAX_VALUE) {
            ResultConverter.illegalArgument("Row size %d > %d", rowKeyLen, (short)Short.MAX_VALUE);
        } else if (familyLen > 127) {
            ResultConverter.illegalArgument("Column family size %d > %d", familyLen, (byte)127);
        } else if (qualifierLen > Integer.MAX_VALUE - (rowKeyLen + familyLen)) {
            ResultConverter.illegalArgument("Qualifier size %d > %d", qualifierLen, Integer.MAX_VALUE);
        } else if (valueLen > 0x7FFFFFFE) {
            ResultConverter.illegalArgument("Value size %d > %d", valueLen, 0x7FFFFFFE);
        }
        long keySize = 12L + (long)rowKeyLen + (long)familyLen + (long)qualifierLen;
        if (keySize > Integer.MAX_VALUE) {
            ResultConverter.illegalArgument("Key size %d > %d", keySize, Integer.MAX_VALUE);
        }
        return (int)keySize;
    }

    protected static void illegalArgument(String format, Object ... args) {
        throw new IllegalArgumentException(String.format(format, args));
    }

    static class FamilyNameIdMap
    implements Comparable<FamilyNameIdMap> {
        byte[] name;
        int index;
        int columnPos;
        int cellPos;

        FamilyNameIdMap(int id, byte[] cfname, int columnPos, int cellPos) {
            this.index = id;
            this.name = cfname;
            this.columnPos = columnPos;
            this.cellPos = cellPos;
        }

        @Override
        public int compareTo(FamilyNameIdMap that) {
            return Bytes.compareTo((byte[])this.name, (byte[])that.name);
        }

        public String toString() {
            return String.format("%s => %d; %d; %d", Bytes.toString((byte[])this.name), this.index, this.columnPos, this.cellPos);
        }
    }
}

