/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.test;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;

public class TestDeletes {
    private static final String ROW = "row";
    private static final String FAM = "fam";
    private static final String COL = "col";
    private static final int FAMCOUNT = 3;
    private static final int MAXVERSION = 5;
    private static int numRows1 = 3;
    private static int numRows2 = 5;
    private static int numCols = 2;

    public static boolean creatTable(String tableName, int familyCount, Configuration conf) throws Exception {
        HBaseAdmin admin = new HBaseAdmin(conf);
        if (admin.tableExists(tableName)) {
            System.out.println("recreate table " + tableName);
            admin.deleteTable(tableName);
        }
        HTableDescriptor tableDesc = new HTableDescriptor(tableName);
        for (int i = 0; i < familyCount; ++i) {
            HColumnDescriptor hcd = new HColumnDescriptor(FAM + i);
            hcd.setMaxVersions(5);
            tableDesc.addFamily(hcd);
        }
        admin.createTable(tableDesc);
        System.out.println("create table " + tableName + " ok.");
        admin.close();
        return true;
    }

    public static void doPut(HTable ht, int ridx, int fidx, int cidx, long ts) throws IOException {
        String strrow = ROW + ridx;
        String strfam = FAM + fidx;
        String strcol = COL + cidx;
        byte[] row = Bytes.toBytes((String)strrow);
        byte[] fam = Bytes.toBytes((String)strfam);
        byte[] col = Bytes.toBytes((String)strcol);
        Put put = new Put(row);
        String strval = null;
        if (ts != -1L) {
            strval = strrow + "-" + strfam + strcol + "v" + ts;
            put.addColumn(fam, col, ts, strval.getBytes());
        } else {
            strval = strrow + "-" + strfam + strcol + "vCurrentTime";
            put.addColumn(fam, col, strval.getBytes());
        }
        ht.put(put);
    }

    public static void doBinaryPut(HTable ht, int ridx, int fidx, int cidx, long ts) throws IOException {
        String strrow = ROW + ridx;
        String strfam = FAM + fidx;
        String strcol = COL + cidx;
        byte[] row = Bytes.toBytes((String)strrow);
        byte[] fam = Bytes.toBytes((String)strfam);
        byte[] col = Bytes.toBytes((String)strcol);
        Put put = new Put(row);
        if (ts != -1L) {
            put.addColumn(fam, col, ts, Bytes.toBytes((long)ts));
        } else {
            put.addColumn(fam, col, Bytes.toBytes((long)1000L));
        }
        ht.put(put);
    }

    public static void runFullScan(HTable table) throws IOException {
        Scan scan = new Scan();
        scan.setMaxVersions();
        ResultScanner scanner = table.getScanner(scan);
        for (Result result : scanner) {
            CellScanner cellScanner = result.cellScanner();
            while (cellScanner.advance()) {
                Cell cell = cellScanner.current();
                System.out.println(CellUtil.toString((Cell)cell, (boolean)true));
            }
        }
    }

    public static void usage() throws Exception {
        System.out.println("init: populate intial data.\ndelete: test the delete results.\ncolop: test operations on columns that are replicated and not replicated. Usage:\n\t hbase com.mapr.fs.hbase.test.TestDeletes tableA  [init|delete|colop] [zkQuorumIP] [zkClientPort]");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            TestDeletes.usage();
            return;
        }
        byte[] row0 = Bytes.toBytes((String)"row0");
        byte[] row1 = Bytes.toBytes((String)"row1");
        byte[] row2 = Bytes.toBytes((String)"row2");
        byte[] row3 = Bytes.toBytes((String)"row3");
        byte[] fam0 = Bytes.toBytes((String)"fam0");
        byte[] fam1 = Bytes.toBytes((String)"fam1");
        byte[] fam2 = Bytes.toBytes((String)"fam2");
        byte[] col0 = Bytes.toBytes((String)"col0");
        byte[] col1 = Bytes.toBytes((String)"col1");
        long ts1 = 1L;
        long ts2 = 2L;
        long ts3 = 3L;
        long ts4 = 4L;
        long ts5 = 5L;
        long ts6 = 6L;
        String tableName1 = args[0];
        boolean isInit = false;
        boolean isDelete = false;
        boolean isColop = false;
        if (args.length > 1) {
            if (args[1].equalsIgnoreCase("init")) {
                isInit = true;
            } else if (args[1].equalsIgnoreCase("delete")) {
                isDelete = true;
            } else if (args[1].equalsIgnoreCase("colop")) {
                isColop = true;
            } else {
                TestDeletes.usage();
                return;
            }
        }
        String quorum = "localhost";
        if (args.length > 2) {
            quorum = args[2];
        }
        String port = "5181";
        if (args.length > 3) {
            port = args[3];
        }
        Configuration conf = new Configuration();
        conf.set("hbase.zookeeper.quorum", quorum);
        conf.set("hbase.zookeeper.property.clientPort", port);
        HTable ht1 = null;
        if (isInit) {
            int m;
            int k;
            int j;
            int i;
            TestDeletes.creatTable(tableName1, 3, conf);
            ht1 = new HTable(conf, tableName1);
            for (i = 0; i < numRows1; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (k = 0; k < numCols; ++k) {
                        for (m = 0; m < 4; ++m) {
                            TestDeletes.doPut(ht1, i, j, k, m);
                        }
                        TestDeletes.doPut(ht1, i, j, k, -1L);
                    }
                }
            }
            for (i = numRows1; i < numRows2; ++i) {
                for (j = 0; j < 3; ++j) {
                    for (k = 0; k < numCols; ++k) {
                        for (m = 0; m < 4; ++m) {
                            TestDeletes.doBinaryPut(ht1, i, j, k, m);
                        }
                        TestDeletes.doBinaryPut(ht1, i, j, k, -1L);
                    }
                }
            }
            ht1.flushCommits();
            ht1.close();
            return;
        }
        if (isDelete) {
            ht1 = new HTable(conf, tableName1);
            Delete del = null;
            Put put = null;
            put = new Put(row0);
            String strval = "row0-fam0col0vCurrentTime2";
            put.addColumn(fam0, col0, strval.getBytes());
            ht1.put(put);
            del = new Delete(row0);
            del.addColumn(fam0, col1);
            ht1.delete(del);
            del = new Delete(row0);
            del.addColumn(fam0, col0, ts1);
            ht1.delete(del);
            del = new Delete(row0);
            del.addColumns(fam1, col0);
            ht1.delete(del);
            del = new Delete(row0);
            del.addColumns(fam1, col1, ts2);
            ht1.delete(del);
            del = new Delete(row0);
            del.addFamily(fam1);
            ht1.delete(del);
            del = new Delete(row0);
            del.addFamilyVersion(fam2, ts2);
            ht1.delete(del);
            del = new Delete(row0);
            del.addFamily(fam2, ts3);
            ht1.delete(del);
            del = new Delete(row1);
            ht1.delete(del);
            Append append = new Append(row2);
            strval = "-append-value1";
            append.add(fam0, col0, strval.getBytes());
            ht1.append(append);
            Increment inc = new Increment(row3);
            inc.addColumn(fam0, col0, 2L);
            ht1.increment(inc);
            RowMutations mutations = new RowMutations(row2);
            Put put1 = new Put(row2);
            strval = "-mutated-value01";
            put1.addColumn(fam0, col1, ts6, strval.getBytes());
            mutations.add(put1);
            Put put2 = new Put(row2);
            strval = "-mutated-value11";
            put2.addColumn(fam1, col1, ts6, strval.getBytes());
            mutations.add(put2);
            Put put3 = new Put(row2);
            strval = "-mutated-value21";
            put3.addColumn(fam2, col1, ts6, strval.getBytes());
            mutations.add(put3);
            Delete del1 = new Delete(row2);
            del1.addColumn(fam0, col1, ts3);
            mutations.add(del1);
            Delete del2 = new Delete(row2);
            del2.addColumn(fam1, col1, ts3);
            mutations.add(del2);
            Delete del3 = new Delete(row2);
            del3.addColumn(fam2, col1, ts3);
            mutations.add(del3);
            ht1.mutateRow(mutations);
            ht1.close();
        } else if (isColop) {
            ht1 = new HTable(conf, tableName1);
            RowMutations mutations = null;
            mutations = new RowMutations(row0);
            Put put1 = new Put(row0);
            String strval = "row0-fam0col0vCurrentTime2";
            put1.addColumn(fam0, col0, strval.getBytes());
            mutations.add(put1);
            Put put2 = new Put(row0);
            strval = "row0-fam1col0vCurrentTime2";
            put2.addColumn(fam1, col0, strval.getBytes());
            mutations.add(put2);
            Put put3 = new Put(row0);
            strval = "row0-fam1col1vCurrentTime2";
            put3.addColumn(fam1, col1, strval.getBytes());
            mutations.add(put3);
            Put put4 = new Put(row0);
            strval = "row0-fam2col0vCurrentTime2";
            put4.addColumn(fam2, col0, strval.getBytes());
            mutations.add(put4);
            ht1.mutateRow(mutations);
            mutations = new RowMutations(row0);
            Delete del1 = new Delete(row0);
            del1.addColumn(fam0, col0);
            mutations.add(del1);
            Delete del2 = new Delete(row0);
            del2.addColumn(fam1, col0);
            mutations.add(del2);
            Delete del3 = new Delete(row0);
            del3.addColumn(fam1, col1);
            mutations.add(del3);
            Delete del4 = new Delete(row0);
            del4.addColumn(fam2, col1);
            mutations.add(del4);
            ht1.mutateRow(mutations);
            mutations = new RowMutations(row0);
            del1 = new Delete(row0);
            del1.addColumn(fam0, col0, ts1);
            mutations.add(del1);
            del2 = new Delete(row0);
            del2.addColumn(fam1, col0, ts1);
            mutations.add(del2);
            del3 = new Delete(row0);
            del3.addColumn(fam1, col1, ts1);
            mutations.add(del3);
            del4 = new Delete(row0);
            del4.addColumn(fam2, col1, ts1);
            mutations.add(del4);
            ht1.mutateRow(mutations);
            mutations = new RowMutations(row0);
            del1 = new Delete(row0);
            del1.addColumns(fam0, col0, ts2);
            mutations.add(del1);
            del2 = new Delete(row0);
            del2.addColumns(fam1, col0, ts2);
            mutations.add(del2);
            del3 = new Delete(row0);
            del3.addColumns(fam1, col1, ts2);
            mutations.add(del3);
            del4 = new Delete(row0);
            del4.addColumns(fam2, col1, ts2);
            mutations.add(del4);
            ht1.mutateRow(mutations);
            mutations = new RowMutations(row0);
            del1 = new Delete(row0);
            del1.addColumns(fam0, col0);
            mutations.add(del1);
            del2 = new Delete(row0);
            del2.addColumns(fam1, col0);
            mutations.add(del2);
            del3 = new Delete(row0);
            del3.addColumns(fam1, col1);
            mutations.add(del3);
            del4 = new Delete(row0);
            del4.addColumns(fam2, col1);
            mutations.add(del4);
            ht1.mutateRow(mutations);
            mutations = new RowMutations(row0);
            del1 = new Delete(row0);
            del1.addFamily(fam0, ts3);
            mutations.add(del1);
            del2 = new Delete(row0);
            del2.addFamily(fam1, ts3);
            mutations.add(del2);
            del3 = new Delete(row0);
            del3.addFamily(fam2, ts3);
            mutations.add(del3);
            ht1.mutateRow(mutations);
            mutations = new RowMutations(row0);
            del1 = new Delete(row0);
            del1.addFamily(fam0);
            mutations.add(del1);
            del2 = new Delete(row0);
            del2.addFamily(fam1);
            mutations.add(del2);
            del3 = new Delete(row0);
            del3.addFamily(fam2);
            mutations.add(del3);
            ht1.mutateRow(mutations);
            del1 = new Delete(row0);
            ht1.delete(del1);
            ht1.close();
        } else {
            TestDeletes.usage();
            return;
        }
        System.out.println("\n========Done.========");
    }

    public static enum DeleteType {
        LatestVersion(1),
        GivenVersion(2),
        UpToGivenVersion(3),
        UpToNow(4);

        private final byte code;

        private DeleteType(int code) {
            this.code = (byte)code;
        }

        public byte getCode() {
            return this.code;
        }
    }
}

