/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.test;

import com.mapr.fs.MapRFileSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;

public class DBTest {
    public static int rows = 1000;
    public static int keysize = 10;
    public static int columns = 3;
    public static int valuesize = 10;
    public static int batch = 1;
    public static int families = 3;
    public static long ops;
    public static int keytype;
    public static int test;
    public static String tablename;
    public static boolean createtable;
    public static boolean printrow;
    public static final byte[] QUALIFIER;
    public static final byte[] BYTES_FAMILY;
    public static final byte[] VALUE;
    public static final byte[][] GKEYS;
    public static final byte[][] KEYS;

    public static void usage() {
        System.err.println("DBTest -rows <1000> -keysize <10 bytes> -families <3> -columns <3> -valuesize <10 bytes> -threads <5> -keytype <random/mono> -batch <1> -debug -test <put/get/scan/mapred/increment/checkandput/append/delete/batch/rowmutations> -tablename maprfs:///myhtable -createtable -printrow");
        System.exit(1);
    }

    public static void formatkey(byte[] key, int row) {
        int d = Math.abs(row);
        for (int i = key.length - 1; i >= 0; --i) {
            key[i] = (byte)(d % 10 + 48);
            d /= 10;
        }
    }

    public static void main(String[] args) throws IOException {
        Configuration config = new Configuration();
        config.set("mapr.htable.impl", "com.mapr.fs.MapRHTable");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-rows")) {
                if (++i >= args.length) {
                    DBTest.usage();
                }
                rows = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-keysize")) {
                if (++i >= args.length) {
                    DBTest.usage();
                }
                keysize = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-tablename")) {
                if (++i >= args.length) {
                    DBTest.usage();
                }
                tablename = args[i];
                continue;
            }
            if (args[i].equals("-debug")) {
                config.set("fs.mapr.trace", "debug");
                continue;
            }
            if (args[i].equals("-createtable")) {
                createtable = true;
                continue;
            }
            if (args[i].equals("-printrow")) {
                printrow = true;
                continue;
            }
            if (args[i].equals("-columns")) {
                if (++i >= args.length) {
                    DBTest.usage();
                }
                columns = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-families")) {
                if (++i >= args.length) {
                    DBTest.usage();
                }
                families = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-valuesize")) {
                if (++i >= args.length) {
                    DBTest.usage();
                }
                valuesize = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-batch")) {
                if (++i >= args.length) {
                    DBTest.usage();
                }
                batch = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals("-keytype")) {
                if (++i >= args.length) {
                    DBTest.usage();
                }
                if (args[i].equals("random")) {
                    keytype = 0;
                    continue;
                }
                if (!args[i].equals("mono")) continue;
                keytype = 1;
                continue;
            }
            if (args[i].equals("-test")) {
                if (++i >= args.length) {
                    DBTest.usage();
                }
                if (args[i].equals("put")) {
                    test = 0;
                    continue;
                }
                if (args[i].equals("get")) {
                    test = 1;
                    continue;
                }
                if (args[i].equals("scan")) {
                    test = 2;
                    continue;
                }
                if (args[i].equals("mapred")) {
                    test = 3;
                    continue;
                }
                if (args[i].equals("increment")) {
                    test = 4;
                    continue;
                }
                if (args[i].equals("append")) {
                    test = 5;
                    continue;
                }
                if (args[i].equals("checkandput")) {
                    test = 6;
                    continue;
                }
                if (args[i].equals("checkanddelete")) {
                    test = 7;
                    continue;
                }
                if (args[i].equals("delete")) {
                    test = 8;
                    continue;
                }
                if (args[i].equals("batch")) {
                    test = 9;
                    continue;
                }
                if (!args[i].equals("rowmutations")) continue;
                test = 10;
                continue;
            }
            DBTest.usage();
        }
        if (tablename == null) {
            tablename = new String("maprfs:///mytable");
        }
        if (createtable) {
            System.out.println("creating table " + tablename);
            try {
                Path tablePath = new Path(tablename);
                MapRFileSystem maprfs = new MapRFileSystem();
                maprfs.initialize(tablePath.toUri(), config);
                maprfs.createTable(tablePath);
                System.out.println("created table " + tablename);
                maprfs.close();
            }
            catch (IOException ioe) {
                System.out.println("failed to create table " + tablename);
                System.exit(1);
            }
        }
        switch (test) {
            case 0: {
                DBTest.puttest(config);
                break;
            }
            case 1: {
                DBTest.gettest(config);
                break;
            }
            case 2: {
                DBTest.scantest(config);
                break;
            }
            case 3: {
                DBTest.testmapred(config);
                break;
            }
            case 4: {
                DBTest.testincrement(config);
                break;
            }
            case 5: {
                DBTest.testappend(config);
                break;
            }
            case 6: {
                DBTest.testcheckandput(config);
                break;
            }
            case 7: {
                DBTest.testcheckanddelete(config);
                break;
            }
            case 8: {
                DBTest.testdelete(config);
                break;
            }
            case 9: {
                DBTest.testbatch(config);
                break;
            }
            case 10: {
                break;
            }
        }
    }

    public static void printstartend(String msg, byte[] start, byte[] end) {
        String startKey = new String(Hex.encodeHex((byte[])start));
        String endKey = new String(Hex.encodeHex((byte[])end));
        if (startKey.equals("")) {
            startKey = "-INFINITY";
        }
        if (endKey.equals("")) {
            endKey = "INFINITY";
        }
        System.out.println(msg + " [" + startKey + "] -> [" + endKey + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testmapred(Configuration config) {
        HTable table = null;
        try {
            HRegionLocation loc1;
            table = new HTable(config, tablename);
            NavigableMap regions = table.getRegionLocations();
            Pair keys = table.getStartEndKeys();
            int i = 0;
            for (Map.Entry e : regions.entrySet()) {
                String k2;
                String k1;
                System.out.println("--------------------- [" + i + "] --------------------");
                HRegionInfo hri = (HRegionInfo)e.getKey();
                DBTest.printstartend("main ", hri.getStartKey(), hri.getEndKey());
                if (!Arrays.equals(((byte[][])keys.getFirst())[i], hri.getStartKey())) {
                    k1 = new String(((byte[][])keys.getFirst())[i]);
                    k2 = new String(hri.getStartKey());
                    System.out.println("ERROR1 start keys do not match k1=[" + k1 + "], k2=[" + k2 + "]");
                }
                if (!Arrays.equals(((byte[][])keys.getSecond())[i], hri.getEndKey())) {
                    k1 = new String(((byte[][])keys.getSecond())[i]);
                    k2 = new String(hri.getEndKey());
                    System.out.println("ERROR2 start keys do not match k1=[" + k1 + "], k2=[" + k2 + "]");
                }
                HRegionLocation loc = table.getRegionLocation(hri.getStartKey());
                DBTest.printstartend("Check 3", loc.getRegionInfo().getStartKey(), loc.getRegionInfo().getEndKey());
                if (!loc.getRegionInfo().equals((Object)hri)) {
                    // empty if block
                }
                byte[] key = new byte[hri.getStartKey().length];
                System.arraycopy(hri.getStartKey(), 0, key, 0, hri.getStartKey().length);
                if (key.length > 0) {
                    int n = key.length - 1;
                    key[n] = (byte)(key[n] + 1);
                } else {
                    key = new byte[]{1};
                }
                loc = table.getRegionLocation(key);
                DBTest.printstartend("Check 4", loc.getRegionInfo().getStartKey(), loc.getRegionInfo().getEndKey());
                if (!loc.getRegionInfo().equals((Object)hri)) {
                    // empty if block
                }
                if (hri.getEndKey().length != 0) {
                    loc = table.getRegionLocation(hri.getEndKey());
                    DBTest.printstartend("Check 5", loc.getRegionInfo().getStartKey(), loc.getRegionInfo().getEndKey());
                    if (loc.getRegionInfo().equals((Object)hri)) {
                        // empty if block
                    }
                }
                ++i;
            }
            String nkey = "";
            for (int j = 0; j < 10 && (loc1 = table.getRegionLocation(nkey)) != null; ++j) {
                DBTest.printstartend("region:" + j, loc1.getRegionInfo().getStartKey(), loc1.getRegionInfo().getEndKey());
                nkey = Bytes.toString((byte[])loc1.getRegionInfo().getEndKey());
                if (loc1.getRegionInfo().getEndKey().length != 0) continue;
                break;
            }
        }
        catch (IOException ioe) {
            System.err.println("error " + ioe);
        }
        finally {
            if (table != null) {
                try {
                    table.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void puttest(Configuration config) {
        StatsThread statsThread = new StatsThread();
        statsThread.setDaemon(true);
        statsThread.start();
        byte[][] cfamily = new byte[families][];
        for (int f = 0; f < families; ++f) {
            String fname = "CF-" + Integer.toString(f);
            cfamily[f] = Bytes.toBytes((String)fname);
        }
        byte[][] cnames = new byte[columns][];
        for (int j = 0; j < columns; ++j) {
            String cname = "Column-" + Integer.toString(j);
            cnames[j] = Bytes.toBytes((String)cname);
        }
        Random randomSeed = new Random(System.currentTimeMillis());
        Random random = new Random(randomSeed.nextLong());
        byte[][] values = new byte[1000][];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new byte[valuesize];
            random.nextBytes(values[i]);
        }
        byte[] key = new byte[keysize];
        Date date = new Date();
        System.out.println(date.toString() + " START [rows: " + rows + ", families: " + families + ", columns: " + columns + ", keysize: " + keysize + ", keytype: " + keytype + ", valuesize " + valuesize + "]");
        long stime = System.currentTimeMillis();
        try {
            HTable table = new HTable(config, tablename);
            for (int i = 0; i < rows; ++i) {
                if (keytype == 0) {
                    random.nextBytes(key);
                } else {
                    DBTest.formatkey(key, i);
                }
                Put p = new Put(key);
                for (int f = 0; f < families; ++f) {
                    for (int j = 0; j < columns; ++j) {
                        p.add(cfamily[f], cnames[j], values[Math.abs(random.nextInt()) % values.length]);
                    }
                }
                ++ops;
                table.put(p);
            }
            System.err.println("closing the table");
            table.flushCommits();
            table.close();
            System.err.println("done closing the table");
        }
        catch (IOException ioe) {
            System.err.println("Error : " + ioe);
        }
        finally {
            long time = System.currentTimeMillis() - stime;
            System.out.println("END rows " + rows + " time taken = " + time);
            statsThread.shutdown();
            statsThread.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gettest(Configuration config) {
        int i;
        Configuration cc = HBaseConfiguration.create();
        byte[][] cfamily = new byte[families][];
        for (int f = 0; f < families; ++f) {
            String fname = "CF-" + Integer.toString(f);
            cfamily[f] = Bytes.toBytes((String)fname);
        }
        byte[][] cnames = new byte[columns][];
        for (int j = 0; j < columns; ++j) {
            String cname = "Column-" + Integer.toString(j);
            cnames[j] = Bytes.toBytes((String)cname);
        }
        Random randomSeed = new Random(System.currentTimeMillis());
        Random random = new Random(randomSeed.nextLong());
        byte[][] values = new byte[1000][];
        for (int i2 = 0; i2 < values.length; ++i2) {
            values[i2] = new byte[valuesize];
            DBTest.formatkey(values[i2], i2);
        }
        byte[][] key = new byte[rows][];
        System.out.println("inserting [rows: " + rows + ", columns: " + columns + ", keysize: " + keysize + ", keytype: " + keytype + ", valuesize " + valuesize + "]");
        long stime = System.currentTimeMillis();
        try {
            HTable table = new HTable(config, tablename);
            for (i = 0; i < rows; ++i) {
                key[i] = new byte[keysize];
                DBTest.formatkey(key[i], i);
                Put p = new Put(key[i]);
                for (int f = 0; f < families; ++f) {
                    for (int j = 0; j < columns; ++j) {
                        p.add(cfamily[f], cnames[j], values[(i + j) % values.length]);
                    }
                }
                table.put(p);
            }
            table.close();
        }
        catch (IOException ioe) {
            System.err.println("error : " + ioe);
        }
        finally {
            long time = System.currentTimeMillis() - stime;
            System.out.println("END rows " + rows + " time taken = " + time);
        }
        System.out.println("reading..keys back");
        try {
            HTable table = new HTable(config, tablename);
            i = 0;
            while (i < rows) {
                if (batch == 1) {
                    Get g = new Get(key[i]);
                    Result result = table.get(g);
                    DBTest.verify(result, key, values, i, cfamily, cnames);
                    ++i;
                    continue;
                }
                int r = batch;
                if (i + r > rows) {
                    r = rows - i;
                }
                ArrayList<Get> gets = new ArrayList<Get>(r);
                for (int j = 0; j < r; ++j) {
                    Get g = new Get(key[i + j]);
                    gets.add(g);
                }
                Result[] results = table.get(gets);
                if (results.length != r) {
                    System.out.println("Incorrect result size ased for " + r + " got " + results.length);
                    System.exit(1);
                }
                for (int j = 0; j < r; ++j) {
                    DBTest.verify(results[j], key, values, i + j, cfamily, cnames);
                }
                i += r;
            }
            System.out.println("Closing table");
            table.close();
            System.out.println("done closing table");
        }
        catch (IOException ioe) {
            System.err.println("error : " + ioe);
        }
    }

    public static void verify(Result result, byte[][] key, byte[][] values, int i, byte[][] cfamily, byte[][] cnames) {
        String orig = new String(key[i]);
        if (!result.isEmpty()) {
            String got = new String(result.getRow());
            if (Arrays.equals(key[i], result.getRow())) {
                for (int f = 0; f < families; ++f) {
                    for (int j = 0; j < columns; ++j) {
                        byte[] val = result.getValue(cfamily[f], cnames[j]);
                        if (Arrays.equals(val, values[(i + j) % values.length])) continue;
                        String valstr = "NULL";
                        if (val != null) {
                            valstr = new String(val);
                        }
                        String ovalstr = new String(values[(i + j) % values.length]);
                        System.err.println(i + " : ERROR wrong VALUE @" + j + " key= " + got + " orig val =" + ovalstr + " got = " + valstr + " ROW: " + result.toString());
                        System.exit(1);
                    }
                }
                System.out.println(i + " : SUCCESS ROW: " + result.toString());
            } else {
                System.out.println(i + " : ERROR wrong key orig = " + orig + " got = " + got + " ROW: " + result.toString());
                System.exit(1);
            }
        } else {
            System.out.println(i + " : ERROR empty result orig = " + orig + " got = EMPTY");
            System.exit(1);
        }
    }

    public static void scantest(Configuration config) {
        byte[][] cfamily = new byte[families][];
        for (int f = 0; f < families; ++f) {
            String fname = "CF-" + Integer.toString(f);
            cfamily[f] = Bytes.toBytes((String)fname);
        }
        byte[][] cnames = new byte[columns][];
        for (int j = 0; j < columns; ++j) {
            String cname = "Column-" + Integer.toString(j);
            cnames[j] = Bytes.toBytes((String)cname);
        }
        try {
            Result[] results;
            HTable table = new HTable(config, tablename);
            Scan scan = new Scan(HConstants.EMPTY_START_ROW);
            ResultScanner scanner = table.getScanner(scan);
            for (int i = 0; i < rows && (results = scanner.next(batch)) != null; i += results.length) {
                System.out.println("batch : got  " + results.length + " rows");
                for (int r = 0; r < results.length; ++r) {
                    Result result = results[r];
                    int ir = i + r;
                    System.out.println(ir + " : SUCCESS ROW: " + result.toString());
                    if (!printrow) continue;
                    for (int f = 0; f < families; ++f) {
                        for (int j = 0; j < columns; ++j) {
                            String col = new String(cnames[j]);
                            byte[] val = result.getValue(cfamily[f], cnames[j]);
                            if (val != null) {
                                String v = new String(val);
                                System.out.println("col: " + j + " " + col + " val " + v);
                                continue;
                            }
                            System.out.println("col: " + j + " " + col + " val NULL *********");
                        }
                    }
                }
            }
            scanner.close();
            table.close();
        }
        catch (IOException ioe) {
            System.err.println("error : " + ioe);
        }
    }

    public static void testincrement(Configuration config) {
        byte[][] cfamily = new byte[families][];
        try {
            int i;
            Result r;
            KeyValue[] kvs;
            HTable ht = new HTable(config, tablename);
            for (int f = 0; f < families; ++f) {
                String fname = "CF-" + Integer.toString(f);
                cfamily[f] = Bytes.toBytes((String)fname);
            }
            byte[][] ROWS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g"), Bytes.toBytes((String)"h"), Bytes.toBytes((String)"i")};
            byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g"), Bytes.toBytes((String)"h"), Bytes.toBytes((String)"i")};
            byte[] FAMILY = cfamily[0];
            byte[] ROW = ROWS[0];
            System.out.println("PASS 1");
            long newval = ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[0], 1L);
            if (newval != 1L) {
                System.out.println("bad ret value 1");
            }
            if ((newval = ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[1], 2L)) != 2L) {
                System.out.println("bad ret value 2");
            }
            if ((newval = ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[2], 3L)) != 3L) {
                System.out.println("bad ret value 3");
            }
            if ((newval = ht.incrementColumnValue(ROW, FAMILY, QUALIFIERS[3], 4L)) != 4L) {
                System.out.println("bad ret value 4");
            }
            if ((kvs = (r = ht.get(new Get(ROW))).raw()).length != 4) {
                System.err.println("wrong kvs length " + kvs.length + " expected 4");
                System.exit(1);
            }
            DBTest.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[0], 1L);
            DBTest.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[1], 2L);
            DBTest.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 3L);
            DBTest.assertIncrementKey(kvs[3], ROW, FAMILY, QUALIFIERS[3], 4L);
            System.out.println("PASS 2");
            Increment inc = new Increment(ROW);
            inc.addColumn(FAMILY, QUALIFIERS[1], 1L);
            inc.addColumn(FAMILY, QUALIFIERS[3], 1L);
            inc.addColumn(FAMILY, QUALIFIERS[4], 1L);
            ht.increment(inc);
            System.out.println("PASS 3");
            r = ht.get(new Get(ROW));
            kvs = r.raw();
            if (kvs.length != 5) {
                System.err.println("wrong kvs length " + kvs.length + " expected 5");
                System.exit(1);
            }
            System.out.println("PASS 4");
            DBTest.assertIncrementKey(kvs[0], ROW, FAMILY, QUALIFIERS[0], 1L);
            DBTest.assertIncrementKey(kvs[1], ROW, FAMILY, QUALIFIERS[1], 3L);
            DBTest.assertIncrementKey(kvs[2], ROW, FAMILY, QUALIFIERS[2], 3L);
            DBTest.assertIncrementKey(kvs[3], ROW, FAMILY, QUALIFIERS[3], 5L);
            DBTest.assertIncrementKey(kvs[4], ROW, FAMILY, QUALIFIERS[4], 1L);
            System.out.println("PASS 5");
            inc = new Increment(ROWS[1]);
            for (i = 0; i < QUALIFIERS.length; ++i) {
                inc.addColumn(FAMILY, QUALIFIERS[i], (long)(i + 1));
            }
            ht.increment(inc);
            System.out.println("PASS 6");
            r = ht.get(new Get(ROWS[1]));
            kvs = r.raw();
            if (QUALIFIERS.length != kvs.length) {
                System.err.println("wrong kvs length 1 " + kvs.length + " expected " + QUALIFIERS.length);
            }
            for (i = 0; i < QUALIFIERS.length; ++i) {
                DBTest.assertIncrementKey(kvs[i], ROWS[1], FAMILY, QUALIFIERS[i], i + 1);
            }
            System.out.println("PASS 7");
            inc = new Increment(ROWS[1]);
            for (i = 0; i < QUALIFIERS.length; ++i) {
                inc.addColumn(FAMILY, QUALIFIERS[i], (long)(i + 1));
            }
            ht.increment(inc);
            System.out.println("PASS 8");
            r = ht.get(new Get(ROWS[1]));
            kvs = r.raw();
            if (QUALIFIERS.length != kvs.length) {
                System.err.println("wrong kvs length 2 " + kvs.length + " expected " + QUALIFIERS.length);
            }
            for (i = 0; i < QUALIFIERS.length; ++i) {
                DBTest.assertIncrementKey(kvs[i], ROWS[1], FAMILY, QUALIFIERS[i], 2 * (i + 1));
            }
            System.out.println("PASS 9");
        }
        catch (Exception ioe) {
            System.err.println(" error ioe " + ioe);
        }
    }

    public static void assertIncrementKey(KeyValue key, byte[] row, byte[] family, byte[] qualifier, long value) throws Exception {
        if (!Arrays.equals(row, key.getRow())) {
            System.err.println("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])key.getRow()) + "]");
            System.exit(1);
        }
        if (!Arrays.equals(family, key.getFamily())) {
            System.err.println("Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])key.getFamily()) + "]");
            System.exit(1);
        }
        if (!Arrays.equals(qualifier, key.getQualifier())) {
            System.err.println("Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])key.getQualifier()) + "]");
            System.exit(1);
        }
        if (Bytes.toLong((byte[])key.getValue()) != value) {
            System.err.println("Expected value [" + value + "] Got value [" + Bytes.toLong((byte[])key.getValue()) + "]");
            System.exit(1);
        }
    }

    public static void testcheckandput(Configuration config) {
        byte[][] cfamily = new byte[families][];
        try {
            HTable ht = new HTable(config, tablename);
            for (int f = 0; f < families; ++f) {
                String fname = "CF-" + Integer.toString(f);
                cfamily[f] = Bytes.toBytes((String)fname);
            }
            byte[][] ROWS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g"), Bytes.toBytes((String)"h"), Bytes.toBytes((String)"i")};
            byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g"), Bytes.toBytes((String)"h"), Bytes.toBytes((String)"i")};
            byte[] FAMILY = cfamily[0];
            byte[] ROW = ROWS[0];
            byte[] anotherrow = Bytes.toBytes((String)"anotherrow");
            byte[] value1 = Bytes.toBytes((String)"abcd1");
            byte[] value2 = Bytes.toBytes((String)"abcd2");
            Put put1 = new Put(ROW);
            put1.add(FAMILY, QUALIFIERS[0], value1);
            boolean ok = ht.checkAndPut(ROW, FAMILY, QUALIFIERS[0], value1, put1);
            if (ok) {
                System.err.println("Failed PASS 1");
                System.exit(1);
            } else {
                System.out.println("PASS 1");
            }
            ok = ht.checkAndPut(ROW, FAMILY, QUALIFIERS[0], null, put1);
            if (!ok) {
                System.err.println("Failed PASS 2");
                System.exit(1);
            } else {
                System.out.println("PASS 2");
            }
            ok = ht.checkAndPut(ROW, FAMILY, QUALIFIERS[0], null, put1);
            if (ok) {
                System.err.println("Failed PASS 3");
                System.exit(1);
            } else {
                System.out.println("PASS 3");
            }
            Put put2 = new Put(ROW);
            put2.add(FAMILY, QUALIFIERS[0], value2);
            ok = ht.checkAndPut(ROW, FAMILY, QUALIFIERS[0], value1, put2);
            if (!ok) {
                System.err.println("Failed PASS 4");
                System.exit(1);
            } else {
                System.out.println("PASS 4");
            }
            Put put3 = new Put(anotherrow);
            put3.add(FAMILY, QUALIFIERS[0], value1);
            try {
                ok = ht.checkAndPut(ROW, FAMILY, QUALIFIERS[0], value2, put3);
                System.err.println("trying to check and modify different rows should have failed.");
                System.exit(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            System.out.println("DONE");
        }
        catch (Exception e) {
            System.err.println("error " + e);
        }
    }

    public static void testcheckanddelete(Configuration config) {
    }

    public static byte[][] makeNAscii(byte[] base, int n) {
        if (n > 256) {
            return DBTest.makeNBig(base, n);
        }
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            byte[] tail = Bytes.toBytes((String)Integer.toString(i));
            ret[i] = Bytes.add((byte[])base, (byte[])tail);
        }
        return ret;
    }

    public static byte[][] makeN(byte[] base, int n) {
        if (n > 256) {
            return DBTest.makeNBig(base, n);
        }
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            ret[i] = Bytes.add((byte[])base, (byte[])new byte[]{(byte)i});
        }
        return ret;
    }

    public static byte[][] makeNBig(byte[] base, int n) {
        byte[][] ret = new byte[n][];
        for (int i = 0; i < n; ++i) {
            int byteA = i % 256;
            int byteB = i >> 8;
            ret[i] = Bytes.add((byte[])base, (byte[])new byte[]{(byte)byteB, (byte)byteA});
        }
        return ret;
    }

    public static long[] makeStamps(int n) {
        long[] stamps = new long[n];
        for (int i = 0; i < n; ++i) {
            stamps[i] = i + 1;
        }
        return stamps;
    }

    public static boolean equals(byte[] left, byte[] right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null && right.length == 0) {
            return true;
        }
        if (right == null && left.length == 0) {
            return true;
        }
        return Bytes.equals((byte[])left, (byte[])right);
    }

    public static void assertTrue(String arg, boolean condition) throws IOException {
        if (!condition) {
            System.err.println("assert failed msg = " + arg);
            throw new IOException(arg);
        }
    }

    public static void assertTrue(boolean condition) throws IOException {
        DBTest.assertTrue("empty msg", condition);
    }

    public static void assertNumKeys(Result result, int n) throws Exception {
        DBTest.assertTrue("Expected " + n + " keys but got " + result.size(), result.size() == n);
    }

    public static void assertNResult(Result result, byte[] row, byte[][] families, byte[][] qualifiers, byte[][] values, int[][] idxs) throws Exception {
        DBTest.assertTrue("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])result.getRow()) + "]", DBTest.equals(row, result.getRow()));
        DBTest.assertTrue("Expected " + idxs.length + " keys but result contains " + result.size(), result.size() == idxs.length);
        KeyValue[] keys = result.raw();
        for (int i = 0; i < keys.length; ++i) {
            byte[] family = families[idxs[i][0]];
            byte[] qualifier = qualifiers[idxs[i][1]];
            byte[] value = values[idxs[i][2]];
            KeyValue key = keys[i];
            DBTest.assertTrue("(" + i + ") Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])key.getFamily()) + "]", DBTest.equals(family, key.getFamily()));
            DBTest.assertTrue("(" + i + ") Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])key.getQualifier()) + "]", DBTest.equals(qualifier, key.getQualifier()));
            DBTest.assertTrue("(" + i + ") Expected value [" + Bytes.toString((byte[])value) + "] Got value [" + Bytes.toString((byte[])key.getValue()) + "]", DBTest.equals(value, key.getValue()));
        }
    }

    public static void assertNResult(Result result, byte[] row, byte[] family, byte[] qualifier, long[] stamps, byte[][] values, int start, int end) throws IOException {
        DBTest.assertTrue("Expected row [" + Bytes.toString((byte[])row) + "] Got row [" + Bytes.toString((byte[])result.getRow()) + "]", DBTest.equals(row, result.getRow()));
        int expectedResults = end - start + 1;
        DBTest.assertEquals(expectedResults, result.size());
        KeyValue[] keys = result.raw();
        for (int i = 0; i < keys.length; ++i) {
            byte[] value = values[end - i];
            long ts = stamps[end - i];
            KeyValue key = keys[i];
            DBTest.assertTrue("(" + i + ") Expected family [" + Bytes.toString((byte[])family) + "] Got family [" + Bytes.toString((byte[])key.getFamily()) + "]", DBTest.equals(family, key.getFamily()));
            DBTest.assertTrue("(" + i + ") Expected qualifier [" + Bytes.toString((byte[])qualifier) + "] Got qualifier [" + Bytes.toString((byte[])key.getQualifier()) + "]", DBTest.equals(qualifier, key.getQualifier()));
            DBTest.assertTrue("Expected ts [" + ts + "] Got ts [" + key.getTimestamp() + "]", ts == key.getTimestamp());
            DBTest.assertTrue("(" + i + ") Expected value [" + Bytes.toString((byte[])value) + "] Got value [" + Bytes.toString((byte[])key.getValue()) + "]", DBTest.equals(value, key.getValue()));
        }
    }

    public static void assertEquals(int i, int j) throws IOException {
        if (i != j) {
            throw new IOException("not equal arg1" + i + " arg2 " + j);
        }
    }

    public static void assertEquals(byte[] expected, byte[] actual) throws IOException {
        if (Bytes.compareTo((byte[])expected, (byte[])actual) != 0) {
            throw new IOException("expected:<" + Bytes.toStringBinary((byte[])expected) + "> but was:<" + Bytes.toStringBinary((byte[])actual) + ">");
        }
    }

    public static Result getSingleScanResult(HTable ht, Scan scan) throws IOException {
        ResultScanner scanner = ht.getScanner(scan);
        Result result = scanner.next();
        scanner.close();
        return result;
    }

    public static void testdelete(Configuration config) {
        byte[][] cfamily = new byte[families][];
        try {
            byte[] bytes;
            int i;
            byte[] bytes2;
            int i2;
            HTable ht = new HTable(config, tablename);
            for (int f = 0; f < families; ++f) {
                String fname = "CF-" + Integer.toString(f);
                cfamily[f] = Bytes.toBytes((String)fname);
            }
            byte[] ROW = Bytes.toBytes((String)"testRow");
            byte[] FAMILY = Bytes.toBytes((String)"CF-");
            byte[] QUALIFIER = Bytes.toBytes((String)"testQualifier");
            byte[] VALUE = Bytes.toBytes((String)"testValue");
            byte[][] ROWS = DBTest.makeNAscii(ROW, 6);
            byte[][] FAMILIES = DBTest.makeNAscii(FAMILY, 3);
            byte[][] VALUES = DBTest.makeN(VALUE, 5);
            long[] ts = new long[]{1000L, 2000L, 3000L, 4000L, 5000L};
            Put put = new Put(ROW);
            put.add(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
            put.add(FAMILIES[0], QUALIFIER, ts[1], VALUES[1]);
            ht.put(put);
            System.out.println("PASS 1");
            Delete delete = new Delete(ROW);
            delete.deleteFamily(FAMILIES[0], ts[0]);
            ht.delete(delete);
            System.out.println("PASS 2");
            Get get = new Get(ROW);
            get.addFamily(FAMILIES[0]);
            get.setMaxVersions(Integer.MAX_VALUE);
            Result result = ht.get(get);
            DBTest.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUES[1]}, 0, 0);
            System.out.println("PASS 3");
            Scan scan = new Scan(ROW);
            scan.addFamily(FAMILIES[0]);
            scan.setMaxVersions(Integer.MAX_VALUE);
            result = DBTest.getSingleScanResult(ht, scan);
            DBTest.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1]}, new byte[][]{VALUES[1]}, 0, 0);
            System.out.println("PASS 4");
            put = new Put(ROW);
            put.add(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
            put.add(FAMILIES[0], QUALIFIER, ts[2], VALUES[2]);
            put.add(FAMILIES[0], QUALIFIER, ts[3], VALUES[3]);
            put.add(FAMILIES[0], null, ts[4], VALUES[4]);
            put.add(FAMILIES[0], null, ts[2], VALUES[2]);
            put.add(FAMILIES[0], null, ts[3], VALUES[3]);
            ht.put(put);
            System.out.println("PASS 5");
            delete = new Delete(ROW);
            delete.deleteColumn(FAMILIES[0], QUALIFIER);
            ht.delete(delete);
            System.out.println("PASS 6");
            get = new Get(ROW);
            get.addColumn(FAMILIES[0], QUALIFIER);
            get.setMaxVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            DBTest.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
            System.out.println("PASS 7");
            scan = new Scan(ROW);
            scan.addColumn(FAMILIES[0], QUALIFIER);
            scan.setMaxVersions(Integer.MAX_VALUE);
            result = DBTest.getSingleScanResult(ht, scan);
            DBTest.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
            System.out.println("PASS 8");
            delete = new Delete(ROW);
            delete.deleteColumn(FAMILIES[0], null);
            ht.delete(delete);
            System.out.println("PASS 9");
            delete = new Delete(ROW);
            delete.deleteColumns(FAMILIES[0], null);
            ht.delete(delete);
            System.out.println("PASS 10");
            put = new Put(ROW);
            put.add(FAMILIES[0], QUALIFIER, ts[0], VALUES[0]);
            put.add(FAMILIES[0], QUALIFIER, ts[4], VALUES[4]);
            ht.put(put);
            System.out.println("PASS 11");
            get = new Get(ROW);
            get.addFamily(FAMILIES[0]);
            get.setMaxVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            DBTest.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
            System.out.println("PASS 12");
            scan = new Scan(ROW);
            scan.addFamily(FAMILIES[0]);
            scan.setMaxVersions(Integer.MAX_VALUE);
            result = DBTest.getSingleScanResult(ht, scan);
            DBTest.assertNResult(result, ROW, FAMILIES[0], QUALIFIER, new long[]{ts[1], ts[2], ts[3]}, new byte[][]{VALUES[1], VALUES[2], VALUES[3]}, 0, 2);
            System.out.println("PASS 13");
            put = new Put(ROWS[0]);
            put.add(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
            put.add(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
            put.add(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
            put.add(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
            ht.put(put);
            System.out.println("PASS 14");
            put = new Put(ROWS[1]);
            put.add(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
            put.add(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
            put.add(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
            put.add(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
            ht.put(put);
            System.out.println("PASS 15");
            put = new Put(ROWS[2]);
            put.add(FAMILIES[1], QUALIFIER, ts[0], VALUES[0]);
            put.add(FAMILIES[1], QUALIFIER, ts[1], VALUES[1]);
            put.add(FAMILIES[2], QUALIFIER, ts[2], VALUES[2]);
            put.add(FAMILIES[2], QUALIFIER, ts[3], VALUES[3]);
            ht.put(put);
            System.out.println("PASS 16");
            get = new Get(ROWS[2]);
            get.addFamily(FAMILIES[1]);
            get.addFamily(FAMILIES[2]);
            get.setMaxVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            DBTest.assertTrue("Expected 4 key but received " + result.size() + ": " + result, result.size() == 4);
            System.out.println("PASS 17");
            delete = new Delete(ROWS[0]);
            delete.deleteFamily(FAMILIES[2]);
            ht.delete(delete);
            System.out.println("PASS 18");
            delete = new Delete(ROWS[1]);
            delete.deleteColumns(FAMILIES[1], QUALIFIER);
            ht.delete(delete);
            System.out.println("PASS 19");
            delete = new Delete(ROWS[2]);
            delete.deleteColumn(FAMILIES[1], QUALIFIER);
            delete.deleteColumn(FAMILIES[1], QUALIFIER);
            delete.deleteColumn(FAMILIES[2], QUALIFIER);
            ht.delete(delete);
            System.out.println("PASS 20");
            get = new Get(ROWS[0]);
            get.addFamily(FAMILIES[1]);
            get.addFamily(FAMILIES[2]);
            get.setMaxVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            DBTest.assertTrue("Expected 2 keys but received " + result.size(), result.size() == 2);
            DBTest.assertNResult(result, ROWS[0], FAMILIES[1], QUALIFIER, new long[]{ts[0], ts[1]}, new byte[][]{VALUES[0], VALUES[1]}, 0, 1);
            System.out.println("PASS 21");
            scan = new Scan(ROWS[0]);
            scan.addFamily(FAMILIES[1]);
            scan.addFamily(FAMILIES[2]);
            scan.setMaxVersions(Integer.MAX_VALUE);
            result = DBTest.getSingleScanResult(ht, scan);
            DBTest.assertTrue("Expected 2 keys but received " + result.size(), result.size() == 2);
            DBTest.assertNResult(result, ROWS[0], FAMILIES[1], QUALIFIER, new long[]{ts[0], ts[1]}, new byte[][]{VALUES[0], VALUES[1]}, 0, 1);
            System.out.println("PASS 22");
            get = new Get(ROWS[1]);
            get.addFamily(FAMILIES[1]);
            get.addFamily(FAMILIES[2]);
            get.setMaxVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            DBTest.assertTrue("Expected 2 keys but received " + result.size(), result.size() == 2);
            System.out.println("PASS 23");
            scan = new Scan(ROWS[1]);
            scan.addFamily(FAMILIES[1]);
            scan.addFamily(FAMILIES[2]);
            scan.setMaxVersions(Integer.MAX_VALUE);
            result = DBTest.getSingleScanResult(ht, scan);
            DBTest.assertTrue("Expected 2 keys but received " + result.size(), result.size() == 2);
            System.out.println("PASS 24");
            get = new Get(ROWS[2]);
            get.addFamily(FAMILIES[1]);
            get.addFamily(FAMILIES[2]);
            get.setMaxVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            DBTest.assertEquals(1, result.size());
            DBTest.assertNResult(result, ROWS[2], FAMILIES[2], QUALIFIER, new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
            System.out.println("PASS 25");
            scan = new Scan(ROWS[2]);
            scan.addFamily(FAMILIES[1]);
            scan.addFamily(FAMILIES[2]);
            scan.setMaxVersions(Integer.MAX_VALUE);
            result = DBTest.getSingleScanResult(ht, scan);
            DBTest.assertEquals(1, result.size());
            DBTest.assertNResult(result, ROWS[2], FAMILIES[2], QUALIFIER, new long[]{ts[2]}, new byte[][]{VALUES[2]}, 0, 0);
            System.out.println("PASS 26");
            delete = new Delete(ROWS[3]);
            delete.deleteFamily(FAMILIES[1]);
            ht.delete(delete);
            System.out.println("PASS 27");
            put = new Put(ROWS[3]);
            put.add(FAMILIES[2], QUALIFIER, VALUES[0]);
            ht.put(put);
            System.out.println("PASS 28");
            put = new Put(ROWS[4]);
            put.add(FAMILIES[1], QUALIFIER, VALUES[1]);
            put.add(FAMILIES[2], QUALIFIER, VALUES[2]);
            ht.put(put);
            System.out.println("PASS 29");
            get = new Get(ROWS[3]);
            get.addFamily(FAMILIES[1]);
            get.addFamily(FAMILIES[2]);
            get.setMaxVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            DBTest.assertTrue("Expected 1 key but received " + result.size(), result.size() == 1);
            System.out.println("PASS 30");
            get = new Get(ROWS[4]);
            get.addFamily(FAMILIES[1]);
            get.addFamily(FAMILIES[2]);
            get.setMaxVersions(Integer.MAX_VALUE);
            result = ht.get(get);
            DBTest.assertTrue("Expected 2 keys but received " + result.size(), result.size() == 2);
            System.out.println("PASS 31");
            scan = new Scan(ROWS[3]);
            scan.addFamily(FAMILIES[1]);
            scan.addFamily(FAMILIES[2]);
            scan.setMaxVersions(Integer.MAX_VALUE);
            ResultScanner scanner = ht.getScanner(scan);
            result = scanner.next();
            DBTest.assertTrue("Expected 1 key but received " + result.size(), result.size() == 1);
            DBTest.assertTrue(Bytes.equals((byte[])result.raw()[0].getRow(), (byte[])ROWS[3]));
            DBTest.assertTrue(Bytes.equals((byte[])result.raw()[0].getValue(), (byte[])VALUES[0]));
            result = scanner.next();
            DBTest.assertTrue("Expected 2 keys but received " + result.size(), result.size() == 2);
            DBTest.assertTrue(Bytes.equals((byte[])result.raw()[0].getRow(), (byte[])ROWS[4]));
            DBTest.assertTrue(Bytes.equals((byte[])result.raw()[1].getRow(), (byte[])ROWS[4]));
            DBTest.assertTrue(Bytes.equals((byte[])result.raw()[0].getValue(), (byte[])VALUES[1]));
            DBTest.assertTrue(Bytes.equals((byte[])result.raw()[1].getValue(), (byte[])VALUES[2]));
            scanner.close();
            System.out.println("PASS 32");
            for (i2 = 0; i2 < 10; ++i2) {
                bytes2 = Bytes.toBytes((int)i2);
                put = new Put(bytes2);
                put.setWriteToWAL(false);
                put.add(FAMILIES[0], QUALIFIER, bytes2);
                ht.put(put);
            }
            System.out.println("PASS 33");
            for (i2 = 0; i2 < 10; ++i2) {
                bytes2 = Bytes.toBytes((int)i2);
                get = new Get(bytes2);
                get.addFamily(FAMILIES[0]);
                result = ht.get(get);
                DBTest.assertTrue(result.size() == 1);
            }
            System.out.println("PASS 34");
            ArrayList<Delete> deletes = new ArrayList<Delete>();
            for (i = 0; i < 10; ++i) {
                bytes = Bytes.toBytes((int)i);
                delete = new Delete(bytes);
                delete.deleteFamily(FAMILIES[0]);
                deletes.add(delete);
            }
            System.out.println("PASS 35");
            ht.delete(deletes);
            for (i = 0; i < 10; ++i) {
                bytes = Bytes.toBytes((int)i);
                get = new Get(bytes);
                get.addFamily(FAMILIES[0]);
                result = ht.get(get);
                DBTest.assertTrue(result.size() == 0);
            }
            System.out.println("DONE");
        }
        catch (Exception e) {
            System.err.println("error " + e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void testappend(Configuration config) {
        byte[][] cfamily = new byte[families][];
        try {
            HTable ht = new HTable(config, tablename);
            for (int f = 0; f < families; ++f) {
                String fname = "CF-" + Integer.toString(f);
                cfamily[f] = Bytes.toBytes((String)fname);
            }
            byte[][] ROWS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d"), Bytes.toBytes((String)"e"), Bytes.toBytes((String)"f"), Bytes.toBytes((String)"g"), Bytes.toBytes((String)"h"), Bytes.toBytes((String)"i")};
            byte[] FAMILY = cfamily[0];
            byte[] ROW = ROWS[0];
            byte[] v1 = Bytes.toBytes((String)"42");
            byte[] v2 = Bytes.toBytes((String)"23");
            byte[][] QUALIFIERS = new byte[][]{Bytes.toBytes((String)"a"), Bytes.toBytes((String)"b")};
            Append a = new Append(ROW);
            a.add(FAMILY, QUALIFIERS[0], v1);
            a.add(FAMILY, QUALIFIERS[1], v2);
            a.setReturnResults(false);
            if (ht.append(a) != null) {
                System.err.println("append test pass 1 failed non null return value");
                System.exit(1);
            }
            a = new Append(ROW);
            a.add(FAMILY, QUALIFIERS[0], v2);
            a.add(FAMILY, QUALIFIERS[1], v1);
            Result r = ht.append(a);
            if (Bytes.compareTo((byte[])Bytes.add((byte[])v1, (byte[])v2), (byte[])r.getValue(FAMILY, QUALIFIERS[0])) != 0) {
                System.err.println("append test pass 2 failed wrong values expected " + Bytes.toString((byte[])Bytes.add((byte[])v1, (byte[])v2)) + " got " + Bytes.toString((byte[])r.getValue(FAMILY, QUALIFIERS[0])));
            }
            if (Bytes.compareTo((byte[])Bytes.add((byte[])v2, (byte[])v1), (byte[])r.getValue(FAMILY, QUALIFIERS[1])) != 0) {
                System.err.println("append test pass 3 failed wrong values expected " + Bytes.toString((byte[])Bytes.add((byte[])v2, (byte[])v1)) + " got " + Bytes.toString((byte[])r.getValue(FAMILY, QUALIFIERS[1])));
            }
            System.out.println("DONE");
        }
        catch (Exception e) {
            System.err.println("error " + e);
            System.exit(1);
        }
    }

    public static List<Row> constructPutRequests() {
        ArrayList<Row> puts = new ArrayList<Row>();
        for (byte[] k : KEYS) {
            Put put = new Put(k);
            put.add(BYTES_FAMILY, QUALIFIER, VALUE);
            puts.add((Row)put);
        }
        return puts;
    }

    public static byte[][] makeKeys() {
        byte[] cp;
        byte[] k;
        int kIdx;
        int i;
        byte[][] starterKeys = GKEYS;
        int numKeys = (int)((float)starterKeys.length * 10.33f);
        ArrayList<byte[]> keys = new ArrayList<byte[]>();
        for (i = 0; i < numKeys; ++i) {
            kIdx = i % starterKeys.length;
            k = starterKeys[kIdx];
            cp = new byte[k.length + 1];
            System.arraycopy(k, 0, cp, 0, k.length);
            cp[k.length] = new Integer(i % 256).byteValue();
            keys.add(cp);
        }
        for (i = 0; i < 100; ++i) {
            kIdx = i % starterKeys.length;
            k = starterKeys[kIdx];
            cp = new byte[k.length + 1];
            System.arraycopy(k, 0, cp, 0, k.length);
            cp[k.length] = new Integer(i % 256).byteValue();
            keys.add(cp);
        }
        return (byte[][])keys.toArray((T[])new byte[][]{new byte[0]});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void testbatch(Configuration config) {
        try {
            HTable table = new HTable(config, tablename);
            System.out.println("testbatch: loading data");
            List<Row> puts = DBTest.constructPutRequests();
            table.batch(puts);
            System.out.println("testbatch: loading data done");
            table.flushCommits();
            System.out.println("testbatch: reading data with batch");
            ArrayList<Get> gets = new ArrayList<Get>();
            for (byte[] byArray : KEYS) {
                Get get = new Get(byArray);
                get.addColumn(BYTES_FAMILY, QUALIFIER);
                gets.add(get);
            }
            Object[] multiRes = new Result[gets.size()];
            table.batch(gets, multiRes);
            System.out.println("testbatch: reading data with batch done");
            System.out.println("testbatch: reading data with single call");
            ArrayList<Result> singleRes = new ArrayList<Result>();
            for (Row row : gets) {
                singleRes.add(table.get((Get)row));
            }
            System.out.println("testbatch: reading data with single call done");
            System.out.println("Check 1");
            DBTest.assertEquals(singleRes.size(), multiRes.length);
            System.out.println("Check 2 with in the rows " + singleRes.size());
            for (int i = 0; i < singleRes.size(); ++i) {
                DBTest.assertTrue(((Result)singleRes.get(i)).containsColumn(BYTES_FAMILY, QUALIFIER));
                KeyValue[] keyValueArray = ((Result)singleRes.get(i)).raw();
                KeyValue[] multiKvs = multiRes[i].raw();
                for (int j = 0; j < keyValueArray.length; ++j) {
                    if (!keyValueArray[j].equals((Object)multiKvs[j])) {
                        System.err.println("Error keyvalues are different row " + i + " keyvalue from single call " + keyValueArray[j].toString() + " keyvalue from batch call " + multiRes[j].toString());
                        System.exit(1);
                    }
                    DBTest.assertEquals(0, Bytes.compareTo((byte[])keyValueArray[j].getValue(), (byte[])multiKvs[j].getValue()));
                }
            }
            System.out.println("DONE");
            table.close();
        }
        catch (Exception e) {
            System.err.println("Error : " + e);
        }
    }

    static {
        keytype = 0;
        test = 0;
        tablename = null;
        createtable = false;
        printrow = false;
        QUALIFIER = Bytes.toBytes((String)"qual");
        BYTES_FAMILY = Bytes.toBytes((String)"CF-0");
        VALUE = Bytes.toBytes((String)"value");
        GKEYS = new byte[][]{HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"hhh"), Bytes.toBytes((String)"iii"), Bytes.toBytes((String)"jjj"), Bytes.toBytes((String)"kkk"), Bytes.toBytes((String)"lll"), Bytes.toBytes((String)"mmm"), Bytes.toBytes((String)"nnn"), Bytes.toBytes((String)"ooo"), Bytes.toBytes((String)"ppp"), Bytes.toBytes((String)"qqq"), Bytes.toBytes((String)"rrr"), Bytes.toBytes((String)"sss"), Bytes.toBytes((String)"ttt"), Bytes.toBytes((String)"uuu"), Bytes.toBytes((String)"vvv"), Bytes.toBytes((String)"www"), Bytes.toBytes((String)"xxx"), Bytes.toBytes((String)"yyy")};
        KEYS = DBTest.makeKeys();
    }

    public static class StatsThread
    extends Thread {
        long time = 0L;
        long lastops = 0L;
        boolean shutdown = false;

        @Override
        public void run() {
            while (!this.shutdown) {
                long diff = ops - this.lastops;
                System.out.println(this.time + ": #ops= " + diff);
                this.lastops = ops;
                ++this.time;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void shutdown() {
            this.shutdown = true;
        }
    }
}

