/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.fs.hbase.test;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;

public class PBSVolumeTest {
    private static final byte[] TABLE_NAME = Bytes.toBytes((String)"/TestPBSTable");
    private static final byte[] COLUMN_FAMILY_NAME = Bytes.toBytes((String)"address");
    private static final byte[] COLUMN1_NAME = Bytes.toBytes((String)"city");
    private static final byte[] COLUMN2_NAME = Bytes.toBytes((String)"number");
    private static final String ROW1 = "rowKey1";
    private static final String ROW2 = "rowKey2";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        Configuration conf = HBaseConfiguration.create();
        Connection connection = ConnectionFactory.createConnection((Configuration)conf);
        Admin admin = connection.getAdmin();
        TableName tname = TableName.valueOf((byte[])TABLE_NAME);
        HTableDescriptor tableDescriptor = new HTableDescriptor(tname);
        tableDescriptor.addFamily(new HColumnDescriptor(COLUMN_FAMILY_NAME));
        admin.createTable(tableDescriptor);
        System.out.println("Table created ");
        System.out.println("Adding data to table");
        Table table = connection.getTable(TableName.valueOf((byte[])TABLE_NAME));
        try {
            Put put1 = new Put(Bytes.toBytes((String)ROW1));
            long num1 = 1L;
            put1.addColumn(COLUMN_FAMILY_NAME, COLUMN1_NAME, Bytes.toBytes((String)"Sunnyvale"));
            put1.addColumn(COLUMN_FAMILY_NAME, COLUMN2_NAME, Bytes.toBytes((long)num1));
            table.put(put1);
            boolean isSuccessful = table.checkAndPut(Bytes.toBytes((String)ROW1), COLUMN_FAMILY_NAME, COLUMN1_NAME, null, put1);
            if (isSuccessful) {
                System.out.println("ERROR: CheckAndPut for rowKey1 succeeded, should have failed");
            } else {
                System.out.println("SUCCESS: CheckAndPut for rowKey1 failed, data already exists, as expected");
            }
            Put put2 = new Put(Bytes.toBytes((String)ROW2));
            long num2 = 2L;
            put2.addColumn(COLUMN_FAMILY_NAME, COLUMN1_NAME, Bytes.toBytes((String)"San Jose"));
            put2.addColumn(COLUMN_FAMILY_NAME, COLUMN2_NAME, Bytes.toBytes((long)num2));
            isSuccessful = table.checkAndPut(Bytes.toBytes((String)ROW2), COLUMN_FAMILY_NAME, COLUMN1_NAME, null, put2);
            if (isSuccessful) {
                System.out.println("SUCCESS: OK: CheckAndPut for rowKey2 succeeded");
            } else {
                System.out.println("ERROR: CheckAndPut for rowKey2 failed, data already exists");
            }
            Result getResult = table.get(new Get(Bytes.toBytes((String)ROW1)));
            String city = Bytes.toString((byte[])getResult.getValue(COLUMN_FAMILY_NAME, COLUMN1_NAME));
            long num = Bytes.toLong((byte[])getResult.getValue(COLUMN_FAMILY_NAME, COLUMN2_NAME));
            System.out.println("Get a single row by row key before increment");
            System.out.println("rowKey1:City:" + city + ", Num:" + num);
            Scan scan = new Scan();
            System.out.println("Scan for all cities and house numbers:");
            ResultScanner scanner = table.getScanner(scan);
            for (Result row : scanner) {
                byte[] valueBytes = row.getValue(COLUMN_FAMILY_NAME, COLUMN1_NAME);
                byte[] numBytes = row.getValue(COLUMN_FAMILY_NAME, COLUMN2_NAME);
                System.out.println("City:" + Bytes.toString((byte[])valueBytes) + ", Num:" + Bytes.toLong((byte[])numBytes));
            }
            Increment increment = new Increment(Bytes.toBytes((String)ROW1));
            increment.addColumn(COLUMN_FAMILY_NAME, COLUMN2_NAME, 1L);
            table.increment(increment);
            Result getResult2 = table.get(new Get(Bytes.toBytes((String)ROW1)));
            city = Bytes.toString((byte[])getResult2.getValue(COLUMN_FAMILY_NAME, COLUMN1_NAME));
            num = Bytes.toLong((byte[])getResult2.getValue(COLUMN_FAMILY_NAME, COLUMN2_NAME));
            System.out.println("Get a single row by row key after increment");
            System.out.println("rowKey1:City:" + city + ", Num:" + num);
            Append append = new Append(Bytes.toBytes((String)ROW1));
            append.add(COLUMN_FAMILY_NAME, COLUMN1_NAME, Bytes.toBytes((String)" City"));
            append.add(COLUMN_FAMILY_NAME, COLUMN2_NAME, Bytes.toBytes((long)num));
            Result appendResult = table.append(append);
            city = Bytes.toString((byte[])appendResult.getValue(COLUMN_FAMILY_NAME, COLUMN1_NAME));
            num = Bytes.toLong((byte[])appendResult.getValue(COLUMN_FAMILY_NAME, COLUMN2_NAME));
            System.out.println("Get a single row by row key after appending to rowKey1");
            System.out.println("rowKey1:City:" + city + ", Num:" + num);
        }
        finally {
            System.out.println("Delete the table");
            admin.disableTable(table.getName());
            admin.deleteTable(table.getName());
            table.close();
        }
    }
}

