/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.mapr.baseutils.cldbutils.CLDBRpcCommonUtils;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Security;
import com.mapr.kvstore.KvClientInterface;
import com.mapr.kvstore.KvStore;
import com.mapr.kvstore.KvStoreAdmin;
import com.mapr.kvstore.KvStoreClient;
import com.mapr.kvstore.KvTable;
import com.mapr.kvstore.Operation;
import com.mapr.kvstore.Scanner;
import java.net.URI;
import java.util.ArrayList;

public class TestKv {
    private static KvStoreClient kvClnt;
    static boolean keysOnly;
    static int testUid;
    static int testGid;
    static Security.CredentialsMsg creds;

    public static void main(String[] args) throws Exception {
        Fileserver.KvMsg msg;
        Fileserver.KvSetMsg chk;
        creds = Security.CredentialsMsg.newBuilder().setUid(testUid).addGids(testGid).build();
        try {
            URI uri = new URI("maprfs://localhost:5050");
            CLDBRpcCommonUtils.IpAddr host = new CLDBRpcCommonUtils.IpAddr(uri.getHost());
            kvClnt = new KvStoreClient("default", 1, host, 5660, true, creds);
        }
        catch (Exception e) {
            System.out.println("Exception KvStoreClient: " + e);
        }
        KvStore kvI = new KvStore(kvClnt, creds);
        KvStore kv = new KvStore(kvClnt, creds);
        KvStore kvVar = new KvStore(kvClnt, creds);
        System.out.println("Done with kvstore");
        Operation op = new Operation(kvClnt, creds);
        Operation op1 = new Operation(kvClnt, creds);
        Operation op2 = new Operation(kvClnt, creds);
        System.out.println("Done with operation");
        KvStoreAdmin kvAdmin = new KvStoreAdmin((KvClientInterface)kvClnt);
        System.out.println("Done with kvstore admin");
        if (kvAdmin.create("/kvstore/test.32kv", null, null, 511, Common.FSKeyType.UintKey.getNumber()) != 0) {
            System.out.println("Create /kvstore/test.32kv Failed");
        }
        if (kvAdmin.create("/kvstore/test.64kv", null, null, 511, Common.FSKeyType.LongKey.getNumber()) != 0) {
            System.out.println("Create /kvstore/test.64kv Failed");
        }
        if (kvAdmin.create("/kvstore/test.varkv", null, null, 511, Common.FSKeyType.VarKey.getNumber()) != 0) {
            System.out.println("Create /kvstore/test.varkv Failed");
        }
        int key = 4;
        Long lKey = new Long("4");
        String varKey = new String("Var#Key#");
        String varKey1 = new String("Var#L$$#");
        String varKey2 = new String("Var#L$##");
        Fileserver.KvSetMsg value = Fileserver.KvSetMsg.newBuilder().setValue(ByteString.copyFromUtf8((String)"dddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddddd################################$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$#############@@@@@@@@@@@@@@@@@@@@@&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&&^^^^^^^^^^^^^^^^^^^^$$$~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~##########################################################################################@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@")).build();
        if (kvI.open("/kvstore/test.32kv") != 0) {
            System.out.println("Open for /kvstore/test.32kv Failed");
            return;
        }
        if (kv.open("/kvstore/test.64kv") != 0) {
            System.out.println("Open for /kvstore/test.64kv Failed");
            return;
        }
        if (kvVar.open("/kvstore/test.varkv") != 0) {
            System.out.println("Open for /kvstore/test.varkv Failed");
            return;
        }
        System.out.println("Success opened");
        lKey = 12L;
        System.out.println("Chk key 12 can fail: " + kv.exists((Object)lKey));
        byte[] retValue = kv.lookup((Object)lKey);
        System.out.println("Return Value: " + retValue);
        Common.IPAddress ip = Common.IPAddress.newBuilder().setHost(2130706433).setPort(6000).build();
        ArrayList<Common.IPAddress> ips = new ArrayList<Common.IPAddress>();
        ips.add(ip);
        op1.insert((KvTable)kv, Long.valueOf(14L), (MessageLite)value, false);
        ArrayList resp = new ArrayList();
        op1.apply(resp);
        Fileserver.KvStoreMultiopResponse rsp = (Fileserver.KvStoreMultiopResponse)resp.get(0);
        System.out.println("Return Status" + rsp.getStatus());
        System.out.println("Error Type" + rsp.getOpFailed());
        lKey = 4L;
        op.insert((KvTable)kvVar, varKey, (MessageLite)value);
        op.insert((KvTable)kv, lKey, (MessageLite)value, false);
        op.insert((KvTable)kv, Long.valueOf(14L), (MessageLite)value, false);
        op.insert((KvTable)kvI, Integer.valueOf(16), (MessageLite)value, false);
        op.insert((KvTable)kvI, Integer.valueOf(18), (MessageLite)value, false);
        op.insert((KvTable)kv, Long.valueOf(22L), (MessageLite)value, false);
        op.insert((KvTable)kv, Long.valueOf(19L), (MessageLite)value, false);
        op.insert((KvTable)kv, Long.valueOf(15L), (MessageLite)value, false);
        op.insert((KvTable)kv, Long.valueOf(25L), (MessageLite)value, false);
        op.delete((KvTable)kv, Long.valueOf(lKey + 1L));
        op.apply();
        System.out.println("Chk key " + lKey + ":shd pass:" + kv.exists((Object)lKey));
        Fileserver.KvStoreKey retKey = kv.getMinKey();
        if (retKey != null) {
            System.out.println("Min Value: " + retKey.getLongKey());
        }
        if ((retKey = kv.getMaxKey()) != null) {
            System.out.println("Max Value: " + retKey.getLongKey());
        }
        if ((retValue = kv.lookup((Object)lKey)) != null) {
            chk = Fileserver.KvSetMsg.parseFrom((byte[])retValue);
            System.out.println("Return Value: " + chk.getValue().toStringUtf8());
        }
        Long stKey = new Long("1");
        Long enKey = new Long("100");
        Scanner scan = kv.getScanner((Object)stKey, (Object)enKey, keysOnly);
        System.out.println("KeyCnt " + kv.getKeyCnt());
        while ((msg = scan.next()) != null) {
            System.out.println("Returned Long Scan value: " + msg.getKey().getLongKey());
        }
        scan.close();
        scan = kv.getScanner((Object)stKey, keysOnly);
        while ((msg = scan.next()) != null) {
            System.out.println("Returned Long Scan value: " + msg.getKey().getLongKey());
        }
        scan.close();
        scan = kv.getScanner(keysOnly);
        while ((msg = scan.next()) != null) {
            System.out.println("Returned Long Scan value: " + msg.getKey().getLongKey());
        }
        scan.close();
        kv.close();
        Operation opVar = new Operation(kvClnt, creds);
        System.out.println("Chk key 12: can fail:" + kvVar.exists((Object)varKey));
        retValue = kvVar.lookup((Object)varKey);
        System.out.println("Return Value: " + retValue);
        opVar.insert((KvTable)kvVar, varKey, (MessageLite)value);
        opVar.insert((KvTable)kvVar, varKey1, (MessageLite)value);
        opVar.delete((KvTable)kvVar, varKey2);
        opVar.apply();
        System.out.println("Chk var key: shld pass:" + kvVar.exists((Object)varKey));
        retValue = kvVar.lookup((Object)varKey);
        chk = Fileserver.KvSetMsg.parseFrom((byte[])retValue);
        System.out.println("Return Value: " + chk.getValue().toStringUtf8());
        scan = kvVar.getScanner((Object)varKey, (Object)varKey1, keysOnly);
        while ((msg = scan.next()) != null) {
            System.out.println("Returned Scan value: " + msg.getKey().getVarKey().toStringUtf8());
        }
        scan.close();
        kvVar.close();
        if (kvAdmin.remove("/kvstore/test.32kv") != 0) {
            System.out.println("Remove /kvstore/test.32kv Failed");
        }
        if (kvAdmin.remove("/kvstore/test.64kv") != 0) {
            System.out.println("Remove /kvstore/test.64kv Failed");
        }
        if (kvAdmin.remove("/kvstore/test.varkv") != 0) {
            System.out.println("Remove /kvstore/test.varkv Failed");
        }
        kvClnt.close();
        System.out.println("End of Test");
    }

    static {
        keysOnly = true;
        testUid = 97;
        testGid = 47;
        try {
            System.loadLibrary("MapRClient");
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            System.err.println("Unable to load MapRClient native library");
        }
    }
}

