/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.kvstore.KvTable;

public interface KvDatabaseOp {
    public int insert(KvTable<Integer> var1, Integer var2, MessageLite var3, boolean var4);

    public int insert(KvTable<Long> var1, Long var2, MessageLite var3, boolean var4);

    public int insert(KvTable<String> var1, String var2, MessageLite var3);

    public int insert(KvTable<String> var1, String var2, MessageLite var3, boolean var4);

    public int insert(KvTable<String> var1, String var2, String var3);

    public int insert(KvTable<ByteString> var1, ByteString var2, MessageLite var3);

    public int insert(KvTable<?> var1, Fileserver.KvStoreKey var2, ByteString var3);

    public int delete(KvTable<Integer> var1, Integer var2);

    public int delete(KvTable<Long> var1, Long var2);

    public int delete(KvTable<String> var1, String var2);

    public int delete(KvTable<ByteString> var1, ByteString var2);

    public int delete(KvTable<?> var1, Fileserver.KvStoreKey var2);

    public int apply();

    public void setSkipLogFlush(boolean var1);

    public int hashedKeyInsert(KvTable<String> var1, String var2, int var3, boolean var4, boolean var5);

    public int hashedKeyInsert(KvTable<String> var1, String var2, int var3);

    public int hashedKeyInsertCollisionCount(KvTable<String> var1);

    public int hashedKeyDelete(KvTable<String> var1, String var2);

    public static Fileserver.KvStoreKey getKey(byte[] keyBytes, int keyLength) {
        ByteString keyB = ByteString.copyFrom((byte[])keyBytes, (int)0, (int)keyLength);
        return Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(keyB).build();
    }

    public void cleanUpForHashedStringTables();
}

