/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.mapr.fs.cldb.proto.CLDBProto;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.kvstore.HashedStringKvStore;
import com.mapr.kvstore.KvTable;
import com.mapr.kvstore.KvTableScanner;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashedStringScanner
implements KvTableScanner {
    private static final Logger LOG = LoggerFactory.getLogger(HashedStringScanner.class);
    KvTable<ByteString> kvTable;
    KvTableScanner scanner;

    public HashedStringScanner(KvTable<ByteString> kvTable, KvTableScanner scanner) {
        this.scanner = scanner;
        this.kvTable = kvTable;
    }

    @Override
    public Fileserver.KvMsg next() {
        Fileserver.KvMsg msg = this.scanner.next();
        if (msg == null) {
            return null;
        }
        if (Arrays.equals(msg.getKey().getVarKey().toByteArray(), HashedStringKvStore.MaxCollisionNrKey)) {
            LOG.info("Ignoring collision count key in hashedScanner");
            return this.next();
        }
        try {
            CLDBProto.HashedStringValue val = CLDBProto.HashedStringValue.parseFrom((ByteString)msg.getValue());
            Fileserver.KvStoreKey key = Fileserver.KvStoreKey.newBuilder().setType(Common.FSKeyType.VarKey).setVarKey(ByteString.copyFromUtf8((String)val.getOriginalKey())).build();
            CLDBProto.HashedStringValue returnVal = CLDBProto.HashedStringValue.newBuilder((CLDBProto.HashedStringValue)val).clearOriginalKey().build();
            Fileserver.KvMsg returnMsg = Fileserver.KvMsg.newBuilder((Fileserver.KvMsg)msg).clearKey().setKey(key).setValue(returnVal.toByteString()).build();
            return returnMsg;
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("InvalidProtocolBufferException:Error while parsing value for hashed key:{} for table:{}", (Object)msg.getKey(), (Object)this.kvTable.getTableName());
            return null;
        }
    }

    @Override
    public void close() {
        this.scanner.close();
    }
}

