/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import com.mapr.fs.proto.Fileserver;
import com.mapr.kvstore.HashedStringKvStore;
import com.mapr.kvstore.InMemoryByteStringKvTable;
import com.mapr.kvstore.InMemoryKvTable;
import com.mapr.kvstore.KvDatabaseOp;
import com.mapr.kvstore.KvTable;
import java.util.HashSet;

public class InMemoryKvDatabaseOp
implements KvDatabaseOp {
    private HashSet<HashedStringKvStore> pendingUnlockHashedTables = null;

    @Override
    public int insert(KvTable<Integer> kv, Integer key, MessageLite value, boolean verifyKey) {
        InMemoryKvTable kvTable = (InMemoryKvTable)kv;
        kvTable.insert(key, value.toByteString());
        return 0;
    }

    @Override
    public int insert(KvTable<Long> kv, Long key, MessageLite value, boolean verifyKey) {
        InMemoryKvTable kvTable = (InMemoryKvTable)kv;
        kvTable.insert(key, value.toByteString());
        return 0;
    }

    @Override
    public int insert(KvTable<String> kv, String key, MessageLite value) {
        return this.insert(kv, key, value, false);
    }

    @Override
    public int insert(KvTable<String> kv, String key, MessageLite value, boolean verifyKey) {
        InMemoryKvTable kvTable = (InMemoryKvTable)kv;
        kvTable.insert(key, value.toByteString());
        return 0;
    }

    @Override
    public int insert(KvTable<String> kv, String key, String value) {
        InMemoryKvTable kvTable = (InMemoryKvTable)kv;
        kvTable.insert(key, ByteString.copyFromUtf8((String)value));
        return 0;
    }

    @Override
    public int insert(KvTable<ByteString> kv, ByteString key, MessageLite value) {
        InMemoryByteStringKvTable kvTable = (InMemoryByteStringKvTable)kv;
        kvTable.insert(key, value.toByteString());
        return 0;
    }

    @Override
    public int insert(KvTable<?> kv, Fileserver.KvStoreKey key, ByteString value) {
        return -1;
    }

    @Override
    public int delete(KvTable<Integer> kv, Integer keyValue) {
        InMemoryKvTable kvTable = (InMemoryKvTable)kv;
        kvTable.delete(keyValue);
        return 0;
    }

    @Override
    public int delete(KvTable<Long> kv, Long keyValue) {
        InMemoryKvTable kvTable = (InMemoryKvTable)kv;
        kvTable.delete(keyValue);
        return 0;
    }

    @Override
    public int delete(KvTable<String> kv, String keyValue) {
        InMemoryKvTable kvTable = (InMemoryKvTable)kv;
        kvTable.delete(keyValue);
        return 0;
    }

    @Override
    public int delete(KvTable<ByteString> kv, ByteString keyValue) {
        InMemoryByteStringKvTable kvTable = (InMemoryByteStringKvTable)kv;
        kvTable.delete(keyValue);
        return 0;
    }

    @Override
    public int delete(KvTable<?> kv, Fileserver.KvStoreKey key) {
        return -1;
    }

    @Override
    public int apply() {
        this.releaseAllPendingLocks();
        return 0;
    }

    @Override
    public void setSkipLogFlush(boolean skipLogFlush) {
    }

    @Override
    public int hashedKeyInsert(KvTable<String> kv, String key, int value) {
        return this.hashedKeyInsert(kv, key, value, false, false);
    }

    @Override
    public int hashedKeyInsert(KvTable<String> kv, String key, int value, boolean skipCollisionCountUpdate, boolean verifyKey) {
        HashedStringKvStore hashedKv = (HashedStringKvStore)kv;
        int status = hashedKv.addInsertOp(this, key, value, skipCollisionCountUpdate, verifyKey, this.getPendingUnLockTableSet());
        if (status != 0) {
            this.releaseAllPendingLocks();
            return status;
        }
        return status;
    }

    @Override
    public int hashedKeyInsertCollisionCount(KvTable<String> kv) {
        HashedStringKvStore hashedKv = (HashedStringKvStore)kv;
        int status = hashedKv.insertCollisionCount(this, this.getPendingUnLockTableSet());
        if (status != 0) {
            this.releaseAllPendingLocks();
            return status;
        }
        return status;
    }

    @Override
    public int hashedKeyDelete(KvTable<String> kv, String key) {
        HashedStringKvStore hashedKv = (HashedStringKvStore)kv;
        int status = hashedKv.addDeleteOp(this, key, this.getPendingUnLockTableSet());
        if (status != 0) {
            this.releaseAllPendingLocks();
            return status;
        }
        return status;
    }

    private HashSet<HashedStringKvStore> getPendingUnLockTableSet() {
        if (this.pendingUnlockHashedTables == null) {
            this.pendingUnlockHashedTables = new HashSet(1);
        }
        return this.pendingUnlockHashedTables;
    }

    private void releaseAllPendingLocks() {
        if (this.pendingUnlockHashedTables == null) {
            return;
        }
        for (HashedStringKvStore hashedKv : this.pendingUnlockHashedTables) {
            hashedKv.releaseUpdateLock();
        }
        this.pendingUnlockHashedTables = null;
    }

    @Override
    public void cleanUpForHashedStringTables() {
        this.releaseAllPendingLocks();
    }
}

