/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.mapr.kvstore.InMemoryByteStringKvTable;
import com.mapr.kvstore.InMemoryKvDatabaseOp;
import com.mapr.kvstore.InMemoryKvTable;
import com.mapr.kvstore.KvDatabaseFactory;
import com.mapr.kvstore.KvDatabaseOp;
import com.mapr.kvstore.KvTable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryKvDatabase
implements KvDatabaseFactory {
    private boolean byteStringKeyTable = false;
    static Map<String, KvTable<?>> tables = new ConcurrentHashMap();

    public InMemoryKvDatabase() {
        this.byteStringKeyTable = false;
    }

    public InMemoryKvDatabase(boolean byteStringKeyTable) {
        this.byteStringKeyTable = byteStringKeyTable;
    }

    @Override
    public synchronized <T> KvTable<T> create() {
        if (!this.byteStringKeyTable) {
            return new InMemoryKvTable();
        }
        return new InMemoryByteStringKvTable();
    }

    @Override
    public synchronized <T> void createAndOpenTable(String tableName, KvTable<T> table, int keyType, boolean create) {
        if (tableName == null || table == null) {
            return;
        }
        if (tables.containsKey(tableName)) {
            return;
        }
        table.setType(keyType);
        tables.put(tableName, table);
    }

    @Override
    public synchronized <T> int openTableNoRetry(String tableName, KvTable<T> table, int keyType) {
        if (tableName == null || table == null) {
            return 2;
        }
        if (tables.containsKey(tableName)) {
            return 0;
        }
        return 2;
    }

    @Override
    public KvDatabaseOp getOperator() {
        return new InMemoryKvDatabaseOp();
    }

    @Override
    public <T> void createAndOpenTableBasedOnRole(String tableName, KvTable<T> table, int keyType, boolean create) throws Exception {
        this.createAndOpenTable(tableName, table, keyType, create);
    }
}

