/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.mapr.fs.cldb.proto.SnapshotDB;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.kvstore.InMemoryKvDatabase;
import com.mapr.kvstore.KvDatabaseOp;
import com.mapr.kvstore.KvTable;
import com.mapr.kvstore.KvTableScanner;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryKvTableTest {
    Logger logger = LoggerFactory.getLogger(InMemoryKvTableTest.class);

    @Test
    public void test() throws Exception {
        int SNAPCID_BLOCK_COUNT = 100;
        boolean GENERATION_ID = true;
        InMemoryKvDatabase kvDatabaseFactory = new InMemoryKvDatabase();
        KvTable snapcidsKvTable = kvDatabaseFactory.create();
        kvDatabaseFactory.createAndOpenTable("snapcids", snapcidsKvTable, Common.FSKeyType.UintKey.getNumber(), false);
        KvDatabaseOp operation = kvDatabaseFactory.getOperator();
        int startSnapcid = 258000001;
        SnapshotDB.SnapIdToSnapcidMapEntry snapIdToSnapcidEntry = SnapshotDB.SnapIdToSnapcidMapEntry.newBuilder().setGenerationId(1).setBlockCount(100).build();
        operation.insert(snapcidsKvTable, Integer.valueOf(startSnapcid), (MessageLite)snapIdToSnapcidEntry, false);
        KvTableScanner scanner = snapcidsKvTable.getScanner(false);
        if (scanner == null) {
            this.logger.warn("unable to obtain scanner for snapcids table");
            return;
        }
        Fileserver.KvMsg kvEntry = scanner.next();
        Fileserver.KvStoreKey kvStoreKey = kvEntry.getKey();
        int readStartSnapcid = (Integer)snapcidsKvTable.getKeyFromKvStoreKey(kvStoreKey);
        Assert.assertEquals((long)startSnapcid, (long)readStartSnapcid);
        ByteString value = kvEntry.getValue();
        try {
            snapIdToSnapcidEntry = SnapshotDB.SnapIdToSnapcidMapEntry.parseFrom((ByteString)value);
        }
        catch (InvalidProtocolBufferException e) {
            this.logger.warn("Unable to parse value from snapcids table");
        }
        Assert.assertEquals((long)snapIdToSnapcidEntry.getGenerationId(), (long)1L);
        Assert.assertEquals((long)snapIdToSnapcidEntry.getBlockCount(), (long)100L);
    }
}

