/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kvstore;

import com.google.protobuf.ByteString;
import com.mapr.fs.ShimLoader;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Fileserver;
import com.mapr.fs.proto.Security;
import com.mapr.kvstore.KvStore;
import com.mapr.kvstore.KvStoreClient;
import com.mapr.kvstore.KvTable;
import com.mapr.kvstore.Operation;
import com.mapr.kvstore.Scanner;
import java.net.InetAddress;
import java.net.URI;

public class KvCli {
    private static KvStoreClient kvClnt;
    static boolean keysOnly;
    private static String appName;
    static int testUid;
    static int testGid;
    static Security.CredentialsMsg creds;

    public static void dumpCmdUsage() {
        System.out.println(appName + " dump <kvstore>                  dumps all the key-value pairs in the kvstore");
    }

    public static void updateCmdUsage() {
        System.out.println(appName + " update <kvstore> <key> <value>  update key in kvstore with given value.");
    }

    public static void getkeyCmdUsage() {
        System.out.println(appName + " getkey <kvstore> <key>          gets key-value for key in kvstore.");
    }

    public static void printUsage() {
        System.out.println("Usage:");
        KvCli.dumpCmdUsage();
        KvCli.updateCmdUsage();
        KvCli.getkeyCmdUsage();
    }

    public static void main(String[] args) throws Exception {
        KvStore kv;
        if (args.length < 2) {
            KvCli.printUsage();
            return;
        }
        String cmd = new String(args[0]);
        creds = Security.CredentialsMsg.newBuilder().setUid(testUid).addGids(testGid).build();
        try {
            URI uri = new URI("maprfs://localhost:5050");
            InetAddress ia = InetAddress.getByName(uri.getHost());
            String host = ia.getHostAddress();
            kvClnt = new KvStoreClient("default", 1, host, 5660, true, creds);
        }
        catch (Exception e) {
            System.out.println("Exception KvStoreClient: " + e);
        }
        KvStore kvI = new KvStore(kvClnt, creds);
        KvStore kvL = new KvStore(kvClnt, creds);
        KvStore kvS = new KvStore(kvClnt, creds);
        Operation op = new Operation(kvClnt, creds);
        Common.FSKeyType type = KvStore.gettype((KvStoreClient)kvClnt, (String)args[1]);
        if (type == Common.FSKeyType.LongKey) {
            if (kvL.open(args[1]) != 0) {
                System.out.println("Open for args[1] Failed");
                return;
            }
            kv = kvL;
        } else if (type == Common.FSKeyType.UintKey) {
            if (kvI.open(args[1]) != 0) {
                System.out.println("Open for args[1] Failed");
                return;
            }
            kv = kvI;
        } else if (type == Common.FSKeyType.VarKey) {
            if (kvS.open(args[1]) != 0) {
                System.out.println("Open for args[1] Failed");
                return;
            }
            kv = kvS;
        } else {
            System.out.println("KeyType not supported.");
            return;
        }
        if (args[0].equals("dump")) {
            Fileserver.KvMsg msg;
            Fileserver.KvStoreKey maxKey;
            Fileserver.KvStoreKey minKey = kv.getMinKey();
            if (minKey != null) {
                kv.printKey(minKey);
            }
            if ((maxKey = kv.getMaxKey()) != null) {
                kv.printKey(maxKey);
            }
            Scanner scan = kv.getScanner(minKey, maxKey, keysOnly);
            while ((msg = scan.next()) != null) {
                kv.printKey(msg.getKey());
            }
            scan.close();
        } else if (args[0].equals("update")) {
            if (args.length != 4) {
                KvCli.updateCmdUsage();
                return;
            }
            Fileserver.KvStoreKey key = kv.parseKvStoreKey(args[2]);
            ByteString valBytes = ByteString.copyFromUtf8((String)args[3]);
            op.insert((KvTable)kv, key, valBytes);
            op.apply();
        } else if (args[0].equals("getkey")) {
            if (args.length != 3) {
                KvCli.getkeyCmdUsage();
                return;
            }
            Fileserver.KvStoreKey key = kv.parseKvStoreKey(args[2]);
            byte[] retValue = kv.lookup((Object)key);
            if (retValue == null) {
                System.out.println("Key doesnot exist.");
                return;
            }
            String value = new String(retValue);
            System.out.println("Return Value: " + retValue + "    " + value);
        } else {
            System.out.println("Op " + args[0] + " not supported.");
        }
        kv.close();
    }

    static {
        keysOnly = true;
        appName = new String("KvCli");
        testUid = 0;
        testGid = 0;
        try {
            ShimLoader.load();
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            System.err.println("Unable to load MapRClient native library");
        }
    }
}

