/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb.ssh;

import com.mapr.ycsb.ssh.Cluster;
import com.mapr.ycsb.ssh.SSHSession;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;

public abstract class NodeTask<T>
implements Callable<T> {
    protected final Cluster cluster;
    private final String host;

    protected NodeTask(Cluster cluster, String host) {
        this.cluster = cluster;
        this.host = host;
    }

    @Override
    public T call() throws Exception {
        SSHSession session = this.cluster.getSessionManager().getSession(this.getHost());
        Thread.currentThread().setName(session.getUserName() + "@" + session.getHost());
        return this.run(session);
    }

    protected void ack(OutputStream out) throws IOException {
        out.write(0);
        out.flush();
    }

    protected int checkAck(InputStream in) throws IOException {
        int b = in.read();
        switch (b) {
            case 1: 
            case 2: {
                int c;
                StringBuilder sb = new StringBuilder();
                sb.append("Error: " + b + ". ");
                while ((c = in.read()) != 10) {
                    sb.append((char)c);
                }
                throw new IOException(sb.toString());
            }
        }
        return b;
    }

    protected abstract T run(SSHSession var1) throws Exception;

    public String getHost() {
        return this.host;
    }
}

