/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb.db;

import com.mapr.client.ConnectionFactory;
import com.mapr.client.db.Table;
import com.mapr.client.impl.Constant;
import com.mapr.client.impl.MapRClient;
import com.mapr.ycsb.config.Config;
import com.mapr.ycsb.db.DocumentBuilder;
import com.mapr.ycsb.db.YCSBDocumentBuilder;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRDBJavaClient
extends DB {
    private static final Logger logger = LoggerFactory.getLogger(MapRDBJavaClient.class);
    public static final int Ok = 0;
    public static final int ServerError = -1;
    private static AtomicInteger insertCount = new AtomicInteger(0);
    private static AtomicInteger mapRClientRefCount = new AtomicInteger(0);
    private volatile Table table_ = null;
    private static volatile MapRClient client = null;
    private static volatile DocumentBuilder.Config config_;

    private static synchronized MapRClient getMapRClient() {
        if (client == null) {
            client = (MapRClient)ConnectionFactory.getConnection();
            client.start();
        }
        mapRClientRefCount.incrementAndGet();
        return client;
    }

    private static synchronized void stopMapRClient() {
        int refCount = mapRClientRefCount.decrementAndGet();
        if (refCount == 0 && client != null) {
            client.stop();
            client = null;
            logger.debug(insertCount.intValue() + " documents were inserted");
        }
    }

    public void init() {
        MapRDBJavaClient.getMapRClient();
    }

    public void cleanup() throws DBException {
        MapRDBJavaClient.stopMapRClient();
    }

    private static synchronized DocumentBuilder.Config getConfig(String file) throws DBException {
        if (config_ == null) {
            try {
                config_ = file != null ? Config.load(new File(file)).getBenchmark().getDocumentBuilderConfig() : new DocumentBuilder.Config();
            }
            catch (IOException e) {
                throw new DBException("Unable to load the specified config file: " + file, (Throwable)e);
            }
        }
        return config_;
    }

    public int scan(String tableName, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        throw new UnsupportedOperationException("Scan is not supported for MapR DB Java client.");
    }

    public int read(String tableName, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        throw new UnsupportedOperationException("Read is not supported for MapR DB Java client.");
    }

    public int update(String tableName, String key, HashMap<String, ByteIterator> values) {
        throw new UnsupportedOperationException("Update is not supported for MapR DB Java client.");
    }

    public int insert(String tableName, String key, HashMap<String, ByteIterator> values) {
        try {
            Table table = this.getTable(tableName);
            DocumentBuilder.Config config = MapRDBJavaClient.getConfig(this.getProperty("dbconfigfile"));
            YCSBDocumentBuilder recordBuilder = new YCSBDocumentBuilder(config);
            Document record = recordBuilder.newDocument(values);
            record.setId(key);
            table.insertOrReplaceAsync(record);
            insertCount.incrementAndGet();
            TimeUnit.MICROSECONDS.sleep(Constant.YCSB_INSERT_SLEEP_MICROSECONDS);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return -1;
        }
        return 0;
    }

    public int delete(String tableName, String key) {
        throw new UnsupportedOperationException("Delete is not supported for MapR DB Java client.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table getTable(String tableName) throws DBException, IOException {
        if (this.table_ == null) {
            MapRDBJavaClient mapRDBJavaClient = this;
            synchronized (mapRDBJavaClient) {
                if (this.table_ == null) {
                    this.table_ = client.getTable(tableName);
                }
            }
        }
        return this.table_;
    }
}

