/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mapr.ycsb.config.Config;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableInfo {
    private static final Logger _logger = LoggerFactory.getLogger(TableInfo.class);
    private String table = "usertable";
    private String family = "family";
    private String type = "hbase";
    private String keyprefix = "user";
    private String compression = "NONE";
    private int numRegions = 100;
    private boolean insertOrder = false;
    private boolean multicf = false;
    private String adminClass = " com.yahoo.ycsb.db.HBaseAdminClient ";

    public String getTable() {
        return this.table;
    }

    public String getFamily() {
        return this.family;
    }

    public String getKeyprefix() {
        return this.keyprefix;
    }

    public boolean getMulticf() {
        return this.multicf;
    }

    @JsonProperty(value="num_initial_regions")
    public int getNumRegions() {
        return this.numRegions;
    }

    @JsonProperty(value="insertion_order")
    public boolean getInsertOrder() {
        return this.insertOrder;
    }

    public String getType() {
        return this.type;
    }

    public String getCompression() {
        return this.compression;
    }

    public boolean createTable(Config config) {
        int err = 0;
        File logFile = new File(config.getWorkingDir(), "./logs/tablecreate_out.log");
        logFile.getParentFile().mkdirs();
        try (FileOutputStream logStream = new FileOutputStream(logFile);){
            String type = this.getType().trim().toLowerCase();
            if (type.equals("json") || type.equals("json-java")) {
                this.adminClass = " com.mapr.ycsb.db.MapRDBAdminClient ";
            }
            _logger.info("Running {}", (Object)this.adminClass);
            CommandLine cmdLine = config.getJavaCmdLine().addArgument(this.adminClass).addArgument(" -Dtype=" + this.getType()).addArgument(" -Dkey_prefix=" + this.getKeyprefix()).addArgument(" -Dnum_regions=" + this.getNumRegions()).addArgument(" -Dcompression=" + this.getCompression()).addArgument(" -Dfamily=" + config.getTableInfo().getFamily()).addArgument(" -Dinsertion_order=" + this.getInsertOrder()).addArgument(" -Dmulticf=" + this.getMulticf()).addArgument(" CREATE ").addArgument(config.getTableInfo().getTable());
            DefaultExecutor executor = new DefaultExecutor();
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)logStream));
            try {
                _logger.info("Creating table, logging output to '{}'", (Object)logFile);
                _logger.debug("Executing {}.", (Object)cmdLine);
                err = executor.execute(cmdLine);
            }
            catch (ExecuteException e) {
                err = e.getExitValue();
                _logger.error("Table creation failed. Error {}. See logfile for more detail.", (Object)err);
                _logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        catch (Exception e) {
            err = 1;
            _logger.error(e.getMessage());
            _logger.debug(e.getMessage(), (Throwable)e);
        }
        return err == 0;
    }
}

