/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb.db;

import com.mapr.db.JsonTable;
import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.ycsb.App;
import com.mapr.ycsb.config.Config;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutionException;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBSummary
extends App {
    private static final Logger _logger = LoggerFactory.getLogger(DBSummary.class);

    @Override
    protected int run0() throws Exception {
        try (JsonTable table = MapRDBImpl.getTable((String)this.config.getTableInfo().getTable());){
            table.setOption(Table.TableOption.EXCLUDEID, false);
            try (DocumentStream stream = table.find();){
                _logger.info("Sampling 10 documents from the table.");
                int count = 0;
                for (Document record : stream) {
                    _logger.info("{}", (Object)record.getIdString(), (Object)record);
                    if (++count != 10) continue;
                    break;
                }
            }
        }
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return _logger;
    }

    public static void printSummary(Config config) {
        File logFile = new File(config.getWorkingDir(), "./logs/dbsummary_out.log");
        logFile.getParentFile().mkdirs();
        try (FileOutputStream logStream = new FileOutputStream(logFile);){
            CommandLine cmdLine = config.getJavaCmdLine().addArgument(" com.mapr.ycsb.db.DBSummary ").addArgument(config.getConfigFile().getAbsolutePath());
            DefaultExecutor executor = new DefaultExecutor();
            executor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)logStream));
            executor.execute(cmdLine);
        }
        catch (Exception e) {
            _logger.error(e.getMessage());
            _logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException, Exception {
        _logger.info("Starting DBSummary");
        int ret = ToolRunner.run((Tool)new DBSummary(), (String[])args);
        System.exit(ret);
    }
}

