/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb.db;

import com.mapr.db.impl.MapRDBImpl;
import com.mapr.ycsb.db.DocumentBuilder;
import com.mapr.ycsb.db.ValueByteIterator;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DBException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.ojai.Document;
import org.ojai.Value;
import org.ojai.store.DocumentMutation;

public class YCSBDocumentBuilder
extends DocumentBuilder {
    public YCSBDocumentBuilder(DocumentBuilder.Config config) throws DBException {
        super(config);
    }

    @Override
    public Document newDocument0(HashMap<String, ByteIterator> values) {
        Document document = MapRDBImpl.newDocument();
        for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
            document.set(entry.getKey(), entry.getValue().toArray());
        }
        return document;
    }

    @Override
    public DocumentMutation newMutation(HashMap<String, ByteIterator> values) {
        DocumentMutation mutation = MapRDBImpl.newMutation();
        for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
            mutation.setOrReplace(entry.getKey(), ByteBuffer.wrap(entry.getValue().toArray()));
        }
        return mutation;
    }

    @Override
    public HashMap<String, ByteIterator> buildRowResult(Document document) {
        return this.buildRowResult(document, null);
    }

    @Override
    public HashMap<String, ByteIterator> buildRowResult(Document document, HashMap<String, ByteIterator> result) {
        if (document != null) {
            if (result == null) {
                result = new HashMap();
            }
            for (Map.Entry kv : document) {
                result.put((String)kv.getKey(), (ByteIterator)new ValueByteIterator((Value)kv.getValue()));
            }
        }
        return result;
    }
}

