/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb.ssh;

import com.jcraft.jsch.ChannelExec;
import com.mapr.ycsb.ssh.Cluster;
import com.mapr.ycsb.ssh.NodeTask;
import com.mapr.ycsb.ssh.SSHSession;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFromRemote
extends NodeTask<CopyFromRemote> {
    private static final Logger _logger = LoggerFactory.getLogger(CopyFromRemote.class);
    private String localFilePath;
    private String remoteFilePath;

    public CopyFromRemote(Cluster cluster, String host, String remoteFile, String localFile) {
        super(cluster, host);
        this.localFilePath = localFile;
        this.remoteFilePath = remoteFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CopyFromRemote run(SSHSession session) throws Exception {
        this.localFilePath = session.substituteId(this.localFilePath);
        this.remoteFilePath = session.substituteId(this.remoteFilePath);
        _logger.debug("Copying remote file {} to {}", (Object)this.remoteFilePath, (Object)this.localFilePath);
        StringBuilder command = new StringBuilder("scp -f ").append(this.remoteFilePath);
        ChannelExec channel = session.openChannelExec("exec");
        channel.setCommand(command.toString());
        OutputStream out = channel.getOutputStream();
        InputStream in = channel.getInputStream();
        channel.connect();
        try {
            byte[] buf = new byte[1024];
            this.ack(out);
            while (this.checkAck(in) == 67) {
                in.read(buf, 0, 5);
                long filesize = 0L;
                while (true) {
                    if (in.read(buf, 0, 1) < 0) {
                        throw new IOException("Error reading stream");
                    }
                    if (buf[0] == 32) break;
                    filesize = filesize * 10L + (long)(buf[0] - 48);
                }
                _logger.debug("Filesize: {}", (Object)filesize);
                String filename = null;
                int i = 0;
                while (true) {
                    in.read(buf, i, 1);
                    if (buf[i] == 10) break;
                    ++i;
                }
                filename = new String(buf, 0, i);
                _logger.debug("Filename: {}", (Object)filename);
                this.ack(out);
                try (FileOutputStream fos = new FileOutputStream(this.localFilePath);){
                    while (filesize > 0L) {
                        int readLen = (long)buf.length < filesize ? buf.length : (int)filesize;
                        if ((readLen = in.read(buf, 0, readLen)) < 0) {
                            throw new IOException("Error reading stream");
                        }
                        fos.write(buf, 0, readLen);
                        filesize -= (long)readLen;
                    }
                }
                if (this.checkAck(in) != 0) {
                    throw new IOException("Error reading stream");
                }
                this.ack(out);
            }
        }
        finally {
            if (channel.isConnected()) {
                channel.disconnect();
            }
        }
        _logger.debug("Transmission complete.");
        return this;
    }
}

