/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.ycsb.db;

import com.mapr.db.Table;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.ycsb.config.Config;
import com.mapr.ycsb.db.DocumentBuilder;
import com.mapr.ycsb.db.SchemaDocumentBuilder;
import com.mapr.ycsb.db.YCSBDocumentBuilder;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.RandomByteIterator;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ThreadLocalRandom;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentStream;
import org.ojai.store.DocumentMutation;
import org.ojai.store.QueryCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRDBClient
extends DB {
    private static final Logger _logger = LoggerFactory.getLogger(MapRDBClient.class);
    public static final int Ok = 0;
    public static final int ServerError = -1;
    public static final int HttpError = -2;
    public static final int NoMatchingRecord = -3;
    private volatile Table table_ = null;
    private DocumentBuilder recordBuilder;
    private boolean multicf = false;
    private boolean allcfs = true;
    private int nfields = 10;
    private static volatile boolean logOnce = false;
    private static volatile DocumentBuilder.Config config_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws DBException {
        DocumentBuilder.Config config = MapRDBClient.getConfig(this.getProperty("dbconfigfile"));
        switch (config.type) {
            case "withschema": {
                this.recordBuilder = new SchemaDocumentBuilder(config);
                break;
            }
            default: {
                this.recordBuilder = new YCSBDocumentBuilder(config);
            }
        }
        this.multicf = this.getPropertyBool("multicf");
        this.allcfs = this.getPropertyBool("allcfs");
        this.nfields = this.getPropertyInt("fieldcount");
        Object object = this;
        synchronized (object) {
            if (!logOnce) {
                logOnce = true;
                _logger.info("Using record builder {}.", (Object)this.recordBuilder.getClass().getName());
                _logger.info("Multi CF test: {}, operate on all cfs: {}, nfields {}", new Object[]{this.multicf, this.allcfs, this.nfields});
            }
        }
    }

    public void cleanup() throws DBException {
        if (this.table_ != null) {
            try {
                this.table_.close();
            }
            catch (Exception e) {
                throw new DBException((Throwable)e);
            }
        }
    }

    public int read(String tableName, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        try {
            Table table = this.getTable(tableName);
            if (this.multicf && !this.allcfs) {
                if (fields != null && fields.contains("field0")) {
                    fields.remove("field0");
                    if (fields.size() < 1) {
                        fields.add("field" + (ThreadLocalRandom.current().nextInt(this.nfields - 1) + 1));
                    }
                } else if (fields == null) {
                    fields = new HashSet<String>(this.nfields - 1);
                    for (int i = 1; i < this.nfields; ++i) {
                        fields.add("field" + i);
                    }
                }
            }
            Document record = table.findById(key, this.getFieldPaths(fields));
            this.recordBuilder.buildRowResult(record, result);
            return record == null ? -3 : 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int scan(String tableName, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        try {
            Table table = this.getTable(tableName);
            if (this.multicf && !this.allcfs) {
                if (fields != null && fields.contains("field0")) {
                    fields.remove("field0");
                    if (fields.size() < 1) {
                        fields.add("field" + (ThreadLocalRandom.current().nextInt(this.nfields - 1) + 1));
                    }
                } else if (fields == null) {
                    fields = new HashSet<String>(this.nfields - 1);
                    for (int i = 1; i < this.nfields; ++i) {
                        fields.add("field" + i);
                    }
                }
            }
            ConditionImpl condition = MapRDBImpl.newCondition().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, startkey).build();
            try (DocumentStream stream = table.find((QueryCondition)condition, this.getFieldPaths(fields));){
                int numResults = 0;
                for (Document record : stream) {
                    result.add(this.recordBuilder.buildRowResult(record));
                    if (++numResults < recordcount) continue;
                    break;
                }
            }
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int update(String tableName, String key, HashMap<String, ByteIterator> values) {
        try {
            Table table = this.getTable(tableName);
            if (this.multicf && values.containsKey("field0")) {
                ByteIterator data = values.get("field0");
                if (!this.allcfs) {
                    values.remove("field0");
                    if (values.size() < 1) {
                        values.put("field" + (ThreadLocalRandom.current().nextInt(this.nfields - 1) + 1), data);
                    }
                } else {
                    values.put("field0", (ByteIterator)new RandomByteIterator(data.bytesLeft() * 90L));
                }
            }
            DocumentMutation mutation = this.recordBuilder.newMutation(values);
            table.update(key, mutation);
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int insert(String tableName, String key, HashMap<String, ByteIterator> values) {
        try {
            Table table = this.getTable(tableName);
            if (this.multicf) {
                RandomByteIterator data = new RandomByteIterator(values.get("field0").bytesLeft() * 90L);
                values.put("field0", (ByteIterator)data);
            }
            Document record = this.recordBuilder.newDocument(values);
            table.insertOrReplace(key, record);
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int delete(String tableName, String key) {
        try {
            Table table = this.getTable(tableName);
            table.delete(key);
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table getTable(String tableName) throws DBException, IOException {
        if (this.table_ == null) {
            MapRDBClient mapRDBClient = this;
            synchronized (mapRDBClient) {
                if (this.table_ == null) {
                    this.table_ = MapRDBImpl.getTable((String)tableName);
                    this.table_.setOption(Table.TableOption.EXCLUDEID, true);
                    this.table_.setOption(Table.TableOption.BUFFERWRITE, this.getPropertyBool("MapRDBImpl.bufferWrite", true));
                }
            }
        }
        return this.table_;
    }

    private String[] getFieldPaths(Set<String> fields) {
        if (fields != null) {
            return fields.toArray(new String[fields.size()]);
        }
        return null;
    }

    private static synchronized DocumentBuilder.Config getConfig(String file) throws DBException {
        if (config_ == null) {
            try {
                config_ = file != null ? Config.load(new File(file)).getBenchmark().getDocumentBuilderConfig() : new DocumentBuilder.Config();
            }
            catch (IOException e) {
                throw new DBException("Unable to load the specified config file: " + file, (Throwable)e);
            }
        }
        return config_;
    }
}

