/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.rowcol.DBDocumentImpl;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.ojai.FieldPath;
import org.ojai.FieldSegment;
import org.ojai.Value;
import org.ojai.json.JsonOptions;
import org.ojai.util.DocumentReaders;

public final class IndexKeyComponentValueExtractor {
    static MissingValue mv = new MissingValue();
    private Document doc_;
    private List<String> indexFieldPaths_;
    private HashMap<String, FieldPathAttr> indexFieldPathAttrs_;
    private HashMap<String, ArrayList<ArrayList<String>>> matchingIndexPath_;
    private HashMap<String, ArrayList<ArrayList<String>>> matchingIndexPathArr_;
    private List<String> includedFieldPaths_;
    private HashMap<String, FieldPathAttr> includedFieldPathAttrs_;
    private HashMap<String, ArrayList<ArrayList<String>>> matchingIncludedPath_;
    private HashMap<String, ArrayList<ArrayList<String>>> matchingIncludedPathArr_;
    private String indexedArrayFieldPathCommonArrayPrefix_;
    private String indexedArrayFieldPathMainArrayPrefix_;
    private String indexedArrayFieldPath_;
    private int arrayIndex_;
    private List<Map<String, Object>> mapStack = new ArrayList<Map<String, Object>>();
    private List<ArrayRecord> arrayStack = new ArrayList<ArrayRecord>();

    public IndexKeyComponentValueExtractor(List<String> indexFieldPaths, List<String> includedFieldPaths) {
        this.reset(indexFieldPaths, includedFieldPaths);
    }

    public IndexKeyComponentValueExtractor(List<String> indexFieldPaths) {
        this.reset(indexFieldPaths, new ArrayList<String>());
    }

    private void reset(List<String> indexFieldPaths, List<String> includedFieldPaths) {
        this.doc_ = null;
        this.indexFieldPaths_ = new ArrayList<String>();
        this.indexFieldPathAttrs_ = new HashMap();
        this.matchingIndexPath_ = new HashMap();
        this.matchingIndexPathArr_ = new HashMap();
        this.includedFieldPaths_ = new ArrayList<String>();
        this.includedFieldPathAttrs_ = new HashMap();
        this.matchingIncludedPath_ = new HashMap();
        this.matchingIncludedPathArr_ = new HashMap();
        this.indexedArrayFieldPathCommonArrayPrefix_ = null;
        this.indexedArrayFieldPathMainArrayPrefix_ = null;
        this.indexedArrayFieldPath_ = null;
        this.arrayIndex_ = -1;
        this.buildIndexFieldPaths(indexFieldPaths);
        this.buildIndexFieldPathAttrs();
        this.buildIncludedFieldPaths(includedFieldPaths);
        this.buildIncludedFieldPathAttrs();
    }

    private void reset() {
        for (FieldPathAttr fpa : this.indexFieldPathAttrs_.values()) {
            fpa.keyValues_.clear();
            fpa.values_.clear();
            fpa.groupedValues_.clear();
        }
        for (FieldPathAttr fpa : this.includedFieldPathAttrs_.values()) {
            fpa.keyValues_.clear();
            fpa.values_.clear();
        }
    }

    public int getArrayIndex() {
        return this.arrayIndex_;
    }

    private void printAllValues() {
        for (String indexedField : this.indexFieldPathAttrs_.keySet()) {
            FieldPathAttr fpa = this.indexFieldPathAttrs_.get(indexedField);
            System.out.println("Path " + indexedField + "'s all values:");
            fpa.printValues();
            fpa.printGroupedValues();
        }
    }

    private boolean commonPrefixIsAnIndexPath() {
        for (String indexField : this.indexFieldPaths_) {
            if (!indexField.equals(this.indexedArrayFieldPathCommonArrayPrefix_)) continue;
            return true;
        }
        return false;
    }

    public Object[] getIndexFieldsPreprocessedForConditionGeneration() {
        HashMap<String, Integer> m1 = new HashMap<String, Integer>();
        HashMap<String, Integer> m2 = new HashMap<String, Integer>();
        String commonPrefix = this.indexedArrayFieldPathCommonArrayPrefix_ == null ? null : this.indexedArrayFieldPathCommonArrayPrefix_.substring(1);
        Object[] r = new Object[]{commonPrefix, m1, m2};
        int i = 0;
        if (this.indexedArrayFieldPathCommonArrayPrefix_ == null) {
            for (String indexField : this.indexFieldPaths_) {
                m2.put(indexField.substring(1), i++);
            }
        } else if (this.commonPrefixIsAnIndexPath()) {
            for (String indexField : this.indexFieldPaths_) {
                if (this.isArrayPath(indexField)) {
                    if (indexField.equals(this.indexedArrayFieldPathCommonArrayPrefix_)) {
                        m2.put(indexField.substring(1), i);
                    }
                    ++i;
                    continue;
                }
                m2.put(indexField.substring(1), i++);
            }
        } else {
            for (String indexField : this.indexFieldPaths_) {
                if (indexField.length() > this.indexedArrayFieldPathCommonArrayPrefix_.length() && indexField.substring(0, this.indexedArrayFieldPathCommonArrayPrefix_.length()).equals(this.indexedArrayFieldPathCommonArrayPrefix_)) {
                    int commonPrefixLength = this.indexedArrayFieldPathCommonArrayPrefix_.length() + 1;
                    String key = indexField.substring(commonPrefixLength);
                    m1.put(key, i++);
                    continue;
                }
                m2.put(indexField.substring(1), i++);
            }
        }
        return r;
    }

    public void getIndexKeyComponentValuesCombination(Object[] output, int idx) {
        int i = 0;
        for (String indexField : this.indexFieldPaths_) {
            output[i++] = this.indexFieldPathAttrs_.get(indexField).getValue(idx);
        }
        for (String includedField : this.includedFieldPaths_) {
            output[i++] = this.includedFieldPathAttrs_.get(includedField).getValues();
        }
    }

    private void makeAllMissingValuesIdentical() {
        for (String indexField : this.indexFieldPaths_) {
            this.indexFieldPathAttrs_.get(indexField).makeAllMissingValuesIdentical();
        }
        for (String includedField : this.includedFieldPaths_) {
            this.includedFieldPathAttrs_.get(includedField).makeAllMissingValuesIdentical();
        }
    }

    private void groupValues() {
        FieldPathAttr fpa = this.indexFieldPathAttrs_.get(this.indexedArrayFieldPath_);
        fpa.groupedValues_.add(fpa.values_);
        fpa.values_ = new ArrayList<Object>();
    }

    private boolean areEqual(FieldSegment a, FieldSegment b) {
        return a.isNamed() && b.isNamed() ? a.getNameSegment().getName().equals(b.getNameSegment().getName()) : a.isIndexed() && b.isIndexed();
    }

    private boolean isArrayPath(String fp) {
        return fp.replaceAll("[^\\[]", "").length() > 0;
    }

    private int calcFieldPathHierarchySize(String fp) {
        return fp.replaceAll("[^.\\[]", "").length();
    }

    private int getFieldPathHierarchySize(FieldPath fp) {
        return this.indexFieldPathAttrs_.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{".\u0001"}, (String)fp.toString())).hierarchySize_;
    }

    private int calculateLongestCommonPrefixSize(FieldPath fp0, FieldPath fp1, int upperBound) {
        int l;
        Iterator itr0 = fp0.iterator();
        Iterator itr1 = fp1.iterator();
        for (l = 0; itr0.hasNext() && itr1.hasNext() && this.areEqual((FieldSegment)itr0.next(), (FieldSegment)itr1.next()) && l < upperBound; ++l) {
        }
        return l;
    }

    private int calculateLongestCommonPrefixSize(List<FieldPath> fpList) {
        if (fpList.size() == 0) {
            return 0;
        }
        FieldPath fp0 = fpList.get(0);
        int l = this.getFieldPathHierarchySize(fp0);
        for (int i = 1; i < fpList.size(); ++i) {
            l = this.calculateLongestCommonPrefixSize(fp0, fpList.get(i), l);
        }
        return l;
    }

    private void buildIndexFieldPaths(List<String> indexFieldPaths) {
        for (String fp : indexFieldPaths) {
            this.indexFieldPaths_.add("." + fp.replaceAll("\"", ""));
        }
    }

    private void buildIndexFieldPathAttrs() {
        ArrayList<FieldPath> arrayFPList = new ArrayList<FieldPath>();
        int i = 0;
        for (String fp : this.indexFieldPaths_) {
            int hs = this.calcFieldPathHierarchySize(fp);
            this.indexFieldPathAttrs_.put(fp, new FieldPathAttr(i++, hs));
            if (!this.isArrayPath(fp)) continue;
            arrayFPList.add(FieldPath.parseFrom((String)fp.replaceFirst(".", "")));
        }
        int l = this.calculateLongestCommonPrefixSize(arrayFPList);
        if (l > 0) {
            FieldSegment fs;
            Object aux;
            String fp;
            if (arrayFPList.size() > 1) {
                fp = arrayFPList.get(0);
                Iterator itr = fp.iterator();
                aux = "";
                for (int j = 0; j < l; ++j) {
                    fs = (FieldSegment)itr.next();
                    if (fs.isIndexed()) {
                        this.indexedArrayFieldPathCommonArrayPrefix_ = aux = (String)aux + "[]";
                        continue;
                    }
                    aux = (String)aux + "." + fs.asJsonString();
                }
                if (this.indexedArrayFieldPathCommonArrayPrefix_ != null) {
                    this.indexedArrayFieldPathCommonArrayPrefix_ = this.indexedArrayFieldPathCommonArrayPrefix_.replaceAll("\"", "");
                }
            } else {
                l = 0;
            }
            block2: for (i = 0; i < arrayFPList.size(); ++i) {
                fp = arrayFPList.get(i);
                int k = 0;
                aux = "";
                Iterator j = fp.iterator();
                while (j.hasNext()) {
                    fs = (FieldSegment)j.next();
                    ++k;
                    if (fs.isIndexed()) {
                        this.indexedArrayFieldPathMainArrayPrefix_ = aux = (String)aux + "[]";
                        if (k <= l) continue;
                        this.indexedArrayFieldPath_ = "." + fp.toString().replaceAll("\"", "");
                        break;
                    }
                    aux = (String)aux + "." + fs.asJsonString();
                }
                if (this.indexedArrayFieldPathMainArrayPrefix_ != null) {
                    this.indexedArrayFieldPathMainArrayPrefix_ = this.indexedArrayFieldPathMainArrayPrefix_.replaceAll("\"", "");
                }
                if (this.indexedArrayFieldPath_ == null) continue;
                int j2 = 0;
                for (String fieldPath : this.indexFieldPaths_) {
                    if (this.indexedArrayFieldPath_.equals(fieldPath)) {
                        this.arrayIndex_ = j2;
                        break block2;
                    }
                    ++j2;
                }
                break;
            }
        }
    }

    private void buildIncludedFieldPaths(List<String> includedFieldPaths) {
        for (String fp : includedFieldPaths) {
            this.includedFieldPaths_.add("." + fp.replaceAll("\"", ""));
        }
    }

    private void buildIncludedFieldPathAttrs() {
        int i = 0;
        for (String fp : this.includedFieldPaths_) {
            this.includedFieldPathAttrs_.put(fp, new FieldPathAttr(i++, 0));
        }
    }

    private String concat(List<String> list) {
        Object result = "";
        for (String s : list) {
            result = (String)result + s;
        }
        return result;
    }

    private int comparePaths(String currentPath, String indexField, boolean array) {
        boolean collapsedSqBrCount = false;
        int i = 0;
        int j = 0;
        while (i < currentPath.length() && j < indexField.length()) {
            if (currentPath.charAt(i) != indexField.charAt(j)) {
                if (collapsedSqBrCount) {
                    return 1;
                }
                if (indexField.charAt(j) == '[' && indexField.charAt(j + 1) == ']') {
                    collapsedSqBrCount = true;
                    j += 2;
                    continue;
                }
                return 1;
            }
            collapsedSqBrCount = false;
            ++i;
            ++j;
        }
        if (!array && j < indexField.length() && indexField.charAt(j) == '[' && indexField.charAt(j + 1) == ']') {
            j += 2;
        }
        if (j == indexField.length() && i == currentPath.length()) {
            return 0;
        }
        if (j < indexField.length()) {
            return -1;
        }
        return 1;
    }

    private List<ArrayList<String>> getMatchingPath(List<String> currPath, boolean array, HashMap<String, ArrayList<ArrayList<String>>> matchingPath, List<String> fieldPaths) {
        String currentPath = this.concat(currPath);
        ArrayList<ArrayList<String>> result = matchingPath.get(currentPath);
        if (result != null) {
            return result;
        }
        result = new ArrayList();
        result.add(new ArrayList());
        result.add(new ArrayList());
        for (String fp : fieldPaths) {
            int c = this.comparePaths(currentPath, fp, array);
            if (c <= 0) {
                result.get(0).add(fp);
            }
            if (c != 0) continue;
            result.get(1).add(fp);
        }
        matchingPath.put(currentPath, result);
        return result;
    }

    private void addMissingValue(List<String> currPath, String indexField, HashMap<String, FieldPathAttr> fieldPathAttrs) {
        String last = currPath.remove(currPath.size() - 1);
        String key = this.concat(currPath);
        String currentPath = key + last;
        FieldPathAttr fpa = fieldPathAttrs.get(indexField);
        Object oldValue = fpa.keyValues_.remove(key);
        fpa.values_.remove(oldValue);
        UniqueMissingValue newValue = new UniqueMissingValue();
        fpa.keyValues_.put(currentPath, newValue);
        fpa.values_.add(newValue);
        currPath.add(last);
    }

    private void addValue(List<String> currPath, String indexPath, Object value, HashMap<String, FieldPathAttr> fieldPathAttrs) {
        FieldPathAttr fpa = fieldPathAttrs.get(indexPath);
        String currentPath = this.concat(currPath);
        Object oldValue = fpa.keyValues_.remove(currentPath);
        fpa.values_.remove(oldValue);
        fpa.keyValues_.put(currentPath, value);
        fpa.values_.add(value);
    }

    public int calcMaxValueListSize() {
        int maxSize = 0;
        if (this.indexedArrayFieldPath_ != null) {
            maxSize = this.indexFieldPathAttrs_.get((Object)this.indexedArrayFieldPath_).groupedValues_.size();
        } else {
            for (String indexedField : this.indexFieldPathAttrs_.keySet()) {
                FieldPathAttr fpa = this.indexFieldPathAttrs_.get(indexedField);
                if (maxSize >= fpa.values_.size()) continue;
                maxSize = fpa.values_.size();
            }
        }
        return maxSize > 0 ? maxSize : 1;
    }

    private boolean objectNeedsToBeAttached() {
        return this.mapStack.size() + this.arrayStack.size() > 0;
    }

    private Object newMapObject() {
        LinkedHashMap map = new LinkedHashMap();
        this.mapStack.add(map);
        return map;
    }

    private Object finishMapEncoding() {
        return this.mapStack.size() > 0 ? this.mapStack.remove(this.mapStack.size() - 1) : null;
    }

    private Map<String, Object> getParentMap() {
        return this.mapStack.get(this.mapStack.size() - 1);
    }

    private Object newArrayObject() {
        ArrayList<Object> array = new ArrayList<Object>();
        this.arrayStack.add(new ArrayRecord(array));
        return array;
    }

    private Object finishArrayEncoding() {
        return this.arrayStack.size() > 0 ? this.arrayStack.remove((int)(this.arrayStack.size() - 1)).array_ : null;
    }

    private ArrayRecord getParentArrayRecord() {
        return this.arrayStack.get(this.arrayStack.size() - 1);
    }

    private void attachObjectToParent(Object o, DocumentReader dr) {
        if (dr.inMap()) {
            Map<String, Object> parent = this.getParentMap();
            parent.put(dr.getFieldName(), o);
        } else {
            ArrayRecord prntRcrd = this.getParentArrayRecord();
            prntRcrd.addToArrayList(dr.getArrayIndex(), o);
        }
    }

    private Object getObject(DocumentReader dr, DocumentReader.EventType et) {
        switch (et) {
            case START_MAP: {
                Map childMap = DocumentReaders.encodeMap((DocumentReader)dr);
                this.mapStack.add(childMap);
                return childMap;
            }
            case START_ARRAY: {
                List childList = DocumentReaders.encodeArray((DocumentReader)dr);
                this.arrayStack.add(new ArrayRecord(childList));
                return childList;
            }
        }
        return DocumentReaders.encodeValue((DocumentReader)dr);
    }

    private void updateValues(DocumentReader dr, DocumentReader.EventType et, List<String> currPath, boolean array) {
        currPath.add((String)(dr.inMap() ? "." + dr.getFieldName() : "[]"));
        Object o = null;
        if (this.objectNeedsToBeAttached()) {
            o = this.getObject(dr, et);
            this.attachObjectToParent(o, dr);
        }
        List<ArrayList<String>> indexPaths = this.getMatchingPath(currPath, array, array ? this.matchingIndexPathArr_ : this.matchingIndexPath_, this.indexFieldPaths_);
        for (String indexPath : indexPaths.get(0)) {
            this.addMissingValue(currPath, indexPath, this.indexFieldPathAttrs_);
        }
        if (indexPaths.get(1).size() > 0) {
            if (o == null) {
                o = this.getObject(dr, et);
            }
            for (String indexPath : indexPaths.get(1)) {
                this.addValue(currPath, indexPath, o, this.indexFieldPathAttrs_);
            }
        }
        List<ArrayList<String>> includedPaths = this.getMatchingPath(currPath, array, array ? this.matchingIncludedPathArr_ : this.matchingIncludedPath_, this.includedFieldPaths_);
        for (String includedPath : includedPaths.get(0)) {
            this.addMissingValue(currPath, includedPath, this.includedFieldPathAttrs_);
        }
        if (includedPaths.get(1).size() > 0) {
            if (o == null) {
                o = this.getObject(dr, et);
            }
            for (String includedPath : includedPaths.get(1)) {
                this.addValue(currPath, includedPath, o, this.includedFieldPathAttrs_);
            }
        }
        switch (et) {
            case START_MAP: 
            case START_ARRAY: {
                if (o == null && (o != null || indexPaths.get(0).size() + includedPaths.get(0).size() != 0)) break;
                currPath.remove(currPath.size() - 1);
                dr.skipChildren();
            }
        }
    }

    public void extractValues(Document doc) {
        if (doc == this.doc_) {
            return;
        }
        this.reset();
        DBDocumentImpl priDoc = null;
        if (doc instanceof DBDocumentImpl) {
            priDoc = (DBDocumentImpl)doc;
        } else {
            String docString = doc.asJsonString(JsonOptions.WITHOUT_TAGS);
            priDoc = (DBDocumentImpl)MapRDBImpl.newDocument(docString);
        }
        for (Map.Entry<String, FieldPathAttr> fpEntry : this.indexFieldPathAttrs_.entrySet()) {
            String idxFieldStr = fpEntry.getKey();
            FieldPath idxField = FieldPath.parseFrom((String)idxFieldStr.substring(1));
            Set<Value> idxValues = priDoc.getUniqueValues(idxField);
            if (idxValues == null) continue;
            boolean isArrIdxField = idxFieldStr.equals(this.indexedArrayFieldPath_);
            FieldPathAttr fpAttr = fpEntry.getValue();
            if (isArrIdxField) {
                ArrayList<Value> valList = new ArrayList<Value>(idxValues);
                fpAttr.groupedValues_.add(valList);
                continue;
            }
            for (Value val : idxValues) {
                fpAttr.values_.add(val);
            }
        }
        for (Map.Entry<String, FieldPathAttr> fpEntry : this.includedFieldPathAttrs_.entrySet()) {
            FieldPath inclField = FieldPath.parseFrom((String)fpEntry.getKey().substring(1));
            Set<Value> inclValues = priDoc.getUniqueValues(inclField);
            if (inclValues == null) continue;
            FieldPathAttr fpAttr = fpEntry.getValue();
            for (Value val : inclValues) {
                fpAttr.values_.add(val);
            }
        }
        this.makeAllMissingValuesIdentical();
    }

    private class FieldPathAttr {
        public final int idx_;
        public final int hierarchySize_;
        public HashMap<String, Object> keyValues_;
        public List<Object> values_;
        public List<List<Object>> groupedValues_;

        public FieldPathAttr(int idx, int hierarchySize) {
            this.idx_ = idx;
            this.hierarchySize_ = hierarchySize;
            this.keyValues_ = new HashMap();
            this.values_ = new ArrayList<Object>();
            this.groupedValues_ = new ArrayList<List<Object>>();
        }

        Object getValue(int idx) {
            if (this.values_.size() == 0) {
                return this.groupedValues_.get(idx);
            }
            if (this.values_.size() == 1) {
                return this.values_.get(0);
            }
            return this.values_.get(idx);
        }

        List<Object> getValues() {
            return this.values_;
        }

        void printValues() {
            System.out.println("values start");
            for (int i = 0; i < this.values_.size(); ++i) {
                System.out.println(this.values_.get(i) + " ");
            }
            System.out.println("");
            System.out.println("values finish");
        }

        List<List<Object>> getGroupedValues() {
            return this.groupedValues_;
        }

        void printGroupedValues() {
            System.out.println("groupedValues start");
            for (int i = 0; i < this.groupedValues_.size(); ++i) {
                List<Object> l = this.groupedValues_.get(i);
                for (int j = 0; j < l.size(); ++j) {
                    System.out.println(l.get(j) + " ");
                }
                System.out.println("");
            }
            System.out.println("groupedValues finish");
        }

        private void makeAllMissingValuesIdentical(List<Object> l) {
            for (int i = 0; i < l.size(); ++i) {
                if (!(l.get(i) instanceof UniqueMissingValue)) continue;
                l.set(i, mv);
            }
        }

        public void makeAllMissingValuesIdentical() {
            if (this.values_.size() == 0 && this.groupedValues_.size() == 0) {
                this.values_.add(mv);
            } else {
                this.makeAllMissingValuesIdentical(this.values_);
                for (List<Object> l : this.groupedValues_) {
                    this.makeAllMissingValuesIdentical(l);
                }
            }
        }
    }

    private static class UniqueMissingValue {
        private UniqueMissingValue() {
        }
    }

    private class ArrayRecord {
        public int lastIdx_ = -1;
        public List<Object> array_;

        public ArrayRecord(List<Object> array) {
            this.array_ = array;
        }

        public void addToArrayList(int idx, Object o) {
            for (int i = this.lastIdx_ + 1; i < idx; ++i) {
                this.array_.add(null);
            }
            this.array_.add(o);
            this.lastIdx_ = idx;
        }
    }

    public static class MissingValue {
        public boolean equals(Object o) {
            return this.getClass().equals(o.getClass());
        }
    }
}

