/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.ojai;

import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.ojai.DBDOMDocumentReader;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBList;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestDBDOMDocumentReaderWithCluster
extends BaseTest {
    private static final Logger logger_ = LoggerFactory.getLogger(TestDBDOMDocumentReaderWithCluster.class);
    private static DBDocumentImpl record = new DBDocumentImpl();
    private static Table t = null;

    @BeforeClass
    public static void setUp() throws Exception {
        record.set("map.num1", (byte)127);
        record.set("map.name.first", "John");
        record.set("map.name.last", "Doe");
        record.set("map.address.street.no", 350);
        record.set("map.address.street.name", "Front St");
        record.set("map.address.zip", 95134L);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("Field1");
        values.add(new Short(500));
        values.add(new Double(5555.5555));
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("key1", 100);
        m.put("key2", "xyz");
        values.add(m);
        ArrayList<Constable> l = new ArrayList<Constable>();
        l.add(Double.valueOf(123.4567));
        l.add(Boolean.valueOf(true));
        values.add(l);
        values.add(null);
        values.add("eureka");
        record.set("map.list", values);
        t = DBTests.createOrReplaceTable("tab1");
    }

    @AfterClass
    public static void cleanUp() {
        if (t != null) {
            t.close();
        }
    }

    @Test
    public void testDOMReaderWithArrayProjection() throws Exception {
        t.insertOrReplace("r1", (Document)record);
        t.flush();
        Iterator iter = t.find(new String[]{"map.list[1]", "map.list[4]"}).iterator();
        Document newDoc = (Document)iter.next();
        newDoc.set("a", "eureka");
        DocumentReader r = newDoc.asReader();
        Assert.assertTrue((boolean)(r instanceof DBDOMDocumentReader));
        DocumentReader.EventType et = null;
        et = r.next();
        Assert.assertNotNull((Object)et);
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
        et = r.next();
        Assert.assertNotNull((Object)et);
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
        Assert.assertEquals((Object)"r1", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"map", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)"list", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.SHORT, (Object)r.next());
        Assert.assertEquals((long)500L, (long)r.getShort());
        Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)r.getArrayIndex());
        Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
        Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)r.getArrayIndex());
        Assert.assertEquals((Object)DocumentReader.EventType.DOUBLE, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)r.next());
        Assert.assertTrue((boolean)r.getBoolean());
        Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"eureka", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }

    @Test
    public void testDOMReaderWithSecondLevelProjection() throws Exception {
        t.insertOrReplace("r1", (Document)record);
        t.flush();
        Iterator iter = t.find(new String[]{"map.list[3].key2", "map.list[4][1]"}).iterator();
        Document newDoc = (Document)iter.next();
        newDoc.set("a", "eureka");
        logger_.info(newDoc.toString());
        DocumentReader r = newDoc.asReader();
        Assert.assertTrue((boolean)(r instanceof DBDOMDocumentReader));
        DocumentReader.EventType et = null;
        et = r.next();
        Assert.assertNotNull((Object)et);
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
        et = r.next();
        Assert.assertNotNull((Object)et);
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
        Assert.assertEquals((Object)"r1", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"map", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)"list", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"xyz", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
        Assert.assertEquals((long)3L, (long)r.getArrayIndex());
        Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
        Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
        Assert.assertEquals((long)4L, (long)r.getArrayIndex());
        Assert.assertEquals((Object)DocumentReader.EventType.BOOLEAN, (Object)r.next());
        Assert.assertTrue((boolean)r.getBoolean());
        Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"eureka", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }

    @Test
    public void testDOMReaderWithProjectionOnNullElem() throws Exception {
        t.insertOrReplace("r1", (Document)record);
        t.flush();
        Iterator iter = t.find(new String[]{"map.list[5]", "map.list[6]"}).iterator();
        Document newDoc = (Document)iter.next();
        newDoc.set("a", "xyz");
        DocumentReader r = newDoc.asReader();
        Assert.assertTrue((boolean)(r instanceof DBDOMDocumentReader));
        DocumentReader.EventType et = null;
        et = r.next();
        Assert.assertNotNull((Object)et);
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)et);
        et = r.next();
        Assert.assertNotNull((Object)et);
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)et);
        Assert.assertEquals((Object)"r1", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.START_MAP, (Object)r.next());
        Assert.assertEquals((Object)"map", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.START_ARRAY, (Object)r.next());
        Assert.assertEquals((Object)"list", (Object)r.getFieldName());
        Assert.assertEquals((Object)DocumentReader.EventType.NULL, (Object)r.next());
        Assert.assertTrue((!r.inMap() ? 1 : 0) != 0);
        Assert.assertEquals((long)5L, (long)r.getArrayIndex());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"eureka", (Object)r.getString());
        Assert.assertEquals((long)6L, (long)r.getArrayIndex());
        Assert.assertEquals((Object)DocumentReader.EventType.END_ARRAY, (Object)r.next());
        Assert.assertTrue((boolean)r.inMap());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertEquals((Object)DocumentReader.EventType.STRING, (Object)r.next());
        Assert.assertEquals((Object)"xyz", (Object)r.getString());
        Assert.assertEquals((Object)DocumentReader.EventType.END_MAP, (Object)r.next());
        Assert.assertNull((Object)r.next());
    }

    @Test
    public void testSparseDBListIterator() {
        Document doc = MapRDBImpl.newDocument().set("a", "xyz").set("d[0]", 21).set("d[1]", 55).set("d[2]", 22).set("d[3]", -54).set("d[4]", 30).set("d[5]", 77).set("d[6]", 50).set("d[7]", 15).setNull("d[8]");
        t.insertOrReplace("r1", doc);
        t.flush();
        Iterator iter = t.find(new String[]{"d[2]", "d[4]", "d[7]", "d[8]"}).iterator();
        Document newDoc = (Document)iter.next();
        DBList l = (DBList)newDoc.getList("d");
        ListIterator liter = l.listIterator();
        Assert.assertTrue((boolean)liter.hasNext());
        Assert.assertEquals((long)-1L, (long)liter.previousIndex());
        Assert.assertNull(liter.next());
        Assert.assertNull(liter.next());
        Assert.assertEquals((Object)22, liter.next());
        Assert.assertTrue((boolean)liter.hasPrevious());
        Assert.assertEquals((long)3L, (long)liter.nextIndex());
        Assert.assertEquals((long)2L, (long)liter.previousIndex());
        Assert.assertNull(liter.next());
        Assert.assertEquals((Object)30, liter.next());
        Assert.assertEquals((long)5L, (long)liter.nextIndex());
        Assert.assertEquals((Object)30, liter.previous());
        Assert.assertEquals((long)3L, (long)liter.previousIndex());
        Assert.assertEquals((Object)30, liter.next());
        Assert.assertEquals((long)5L, (long)liter.nextIndex());
        Assert.assertNull(liter.next());
        Assert.assertNull(liter.next());
        Assert.assertEquals((Object)15, liter.next());
        Assert.assertEquals((long)8L, (long)liter.nextIndex());
        Assert.assertNull(liter.next());
        Assert.assertEquals((long)9L, (long)liter.nextIndex());
        Assert.assertFalse((boolean)liter.hasNext());
    }

    @Test
    public void testDBListIterator() {
        Document doc = MapRDBImpl.newDocument().set("a", "xyz").set("d[0]", 21).set("d[1]", 55).set("d[2]", 22).set("d[3]", -54).set("d[4]", 30).set("d[5]", 77).set("d[6]", 50).set("d[7]", 15).setNull("d[7]");
        t.insertOrReplace("r1", doc);
        t.flush();
        Iterator iter = t.find().iterator();
        Document newDoc = (Document)iter.next();
        DBList l = (DBList)newDoc.getList("d");
        ListIterator liter = l.listIterator();
        Assert.assertTrue((boolean)liter.hasNext());
        Assert.assertEquals((long)-1L, (long)liter.previousIndex());
        Assert.assertEquals((Object)21, liter.next());
        Assert.assertEquals((long)1L, (long)liter.nextIndex());
        Assert.assertEquals((long)0L, (long)liter.previousIndex());
        Assert.assertEquals((Object)55, liter.next());
        Assert.assertEquals((long)2L, (long)liter.nextIndex());
        Assert.assertEquals((Object)55, liter.previous());
        Assert.assertEquals((long)0L, (long)liter.previousIndex());
        Assert.assertEquals((Object)55, liter.next());
        Assert.assertEquals((long)2L, (long)liter.nextIndex());
        Assert.assertEquals((Object)22, liter.next());
        Assert.assertEquals((long)3L, (long)liter.nextIndex());
    }
}

