/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableMap;
import com.mapr.db.JsonTable;
import com.mapr.db.Table;
import com.mapr.db.impl.ConditionDescriptor;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.db.tests.utils.Datasets;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.store.DocumentMutation;
import org.ojai.store.QueryCondition;
import org.ojai.store.exceptions.DocumentExistsException;
import org.ojai.store.exceptions.DocumentNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestCheckAndXXX_MultiFamilies
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestCheckAndXXX_MultiFamilies.class);
    private static final String TABLE_NAME = "testtable-TestCheckAndXXX_MultiFamilies";
    private static final Map<String, String> FAMILY_MAP;

    private JsonTable createOrReplaceTable() throws IOException {
        return DBTests.createOrReplaceTable(TABLE_NAME, FAMILY_MAP).setOption(Table.TableOption.BUFFERWRITE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConditionDescriptor() throws Exception {
        try (MapRDBTableImpl table = (MapRDBTableImpl)this.createOrReplaceTable();){
            ConditionImpl condition = MapRDBImpl.newCondition().and().equals("a.b.c", Datasets.ADDRESSES[0]).equals("a.b.c.d", Datasets.ADDRESSES[0]).equals("a.b.c.d.e", Datasets.ADDRESSES[0]).is("p.q.r.s", QueryCondition.Op.EQUAL, 105).exists("o.m.g").notExists("a.b.e").notExists("a.b.e.p").exists("n.e.s.t.e.d").exists("n.e.s.t.e").exists("n.e.s.t").exists("n.e.s").exists("n.e").exists("n").exists("n.e.x.t").close().build();
            BiMap idPathMap = table.idPathMap();
            ConditionDescriptor condDesc = condition.getDescriptor(idPathMap, null);
            Map familyFieldPathsMap = condDesc.getFamilyFieldPathsMap();
            Assert.assertEquals((long)9L, (long)familyFieldPathsMap.size());
            Set fieldPathsInDefault = (Set)familyFieldPathsMap.get(idPathMap.get((Object)FieldPath.EMPTY));
            Assert.assertEquals((long)2L, (long)fieldPathsInDefault.size());
            Iterator itr = fieldPathsInDefault.iterator();
            Assert.assertEquals((Object)FieldPath.parseFrom((String)"n"), itr.next());
            Assert.assertEquals((Object)FieldPath.parseFrom((String)"o.m.g"), itr.next());
            Set fieldPathsInF1 = (Set)familyFieldPathsMap.get(idPathMap.get((Object)FieldPath.parseFrom((String)"a.b.c")));
            Assert.assertEquals((long)3L, (long)fieldPathsInF1.size());
            itr = fieldPathsInF1.iterator();
            Assert.assertEquals((Object)FieldPath.parseFrom((String)"v"), itr.next());
            Assert.assertEquals((Object)FieldPath.parseFrom((String)"v.d"), itr.next());
            Assert.assertEquals((Object)FieldPath.parseFrom((String)"v.d.e"), itr.next());
            Set fieldPathsInF2 = (Set)familyFieldPathsMap.get(idPathMap.get((Object)FieldPath.parseFrom((String)"p.q.r")));
            Assert.assertEquals((long)1L, (long)fieldPathsInF2.size());
            itr = fieldPathsInF2.iterator();
            Assert.assertEquals((Object)FieldPath.parseFrom((String)"v.s"), itr.next());
            Set fieldPathsInF3 = (Set)familyFieldPathsMap.get(idPathMap.get((Object)FieldPath.parseFrom((String)"a.b.e")));
            Assert.assertEquals((long)2L, (long)fieldPathsInF3.size());
            itr = fieldPathsInF3.iterator();
            Assert.assertEquals((Object)FieldPath.parseFrom((String)"v"), itr.next());
            Assert.assertEquals((Object)FieldPath.parseFrom((String)"v.p"), itr.next());
            Set fieldPathsInF4 = (Set)familyFieldPathsMap.get(idPathMap.get((Object)FieldPath.parseFrom((String)"n.e")));
            Assert.assertEquals((long)2L, (long)fieldPathsInF4.size());
            itr = fieldPathsInF4.iterator();
            Assert.assertEquals((Object)FieldPath.parseFrom((String)"v"), itr.next());
            Assert.assertEquals((Object)FieldPath.parseFrom((String)"v.x.t"), itr.next());
            Set fieldPathsInF5 = (Set)familyFieldPathsMap.get(idPathMap.get((Object)FieldPath.parseFrom((String)"n.e.s")));
            Assert.assertEquals((long)1L, (long)fieldPathsInF5.size());
            itr = fieldPathsInF5.iterator();
            Assert.assertEquals((Object)FieldPath.parseFrom((String)"v"), itr.next());
            Set fieldPathsInF6 = (Set)familyFieldPathsMap.get(idPathMap.get((Object)FieldPath.parseFrom((String)"n.e.s.t")));
            Assert.assertEquals((long)1L, (long)fieldPathsInF6.size());
            itr = fieldPathsInF6.iterator();
            Assert.assertEquals((Object)FieldPath.parseFrom((String)"v"), itr.next());
            Set fieldPathsInF7 = (Set)familyFieldPathsMap.get(idPathMap.get((Object)FieldPath.parseFrom((String)"n.e.s.t.e")));
            Assert.assertEquals((long)1L, (long)fieldPathsInF7.size());
            itr = fieldPathsInF7.iterator();
            Assert.assertEquals((Object)FieldPath.parseFrom((String)"v"), itr.next());
            Set fieldPathsInF8 = (Set)familyFieldPathsMap.get(idPathMap.get((Object)FieldPath.parseFrom((String)"n.e.s.t.e.d")));
            Assert.assertEquals((long)1L, (long)fieldPathsInF8.size());
            itr = fieldPathsInF8.iterator();
            Assert.assertEquals((Object)FieldPath.parseFrom((String)"v"), itr.next());
        }
        catch (Throwable throwable) {
            DBTests.deleteTables(TABLE_NAME);
            throw throwable;
        }
        DBTests.deleteTables(TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAndMutateMultiFamilies() throws Exception {
        try (JsonTable table = this.createOrReplaceTable();){
            Document developer = MapRDBImpl.newDocument();
            developer.set("a.b.c.d", Datasets.NAMES[0]);
            developer.set("a.b.e", Datasets.ADDRESSES[0]);
            developer.set("p.q.r.s", 105);
            table.insertOrReplace(Datasets.IDS[0], developer);
            developer.set("p.q.r.s", 104);
            table.insertOrReplace(Datasets.IDS[1], developer);
            ConditionImpl condition = MapRDBImpl.newCondition().and().equals("a.b.e", Datasets.ADDRESSES[0]).is("p.q.r.s", QueryCondition.Op.EQUAL, 105).close().build();
            DocumentMutation rm = MapRDBImpl.newMutation();
            rm.set("x.y.z", 42);
            rm.increment("p.q.r.s", 10);
            Assert.assertTrue((boolean)table.checkAndMutate(Datasets.IDS[0], (QueryCondition)condition, rm));
            Document newRec = table.findById(Datasets.IDS[0]);
            Assert.assertNotNull((Object)newRec);
            Assert.assertEquals((long)42L, (long)newRec.getInt("x.y.z"));
            Assert.assertEquals((long)115L, (long)newRec.getInt("p.q.r.s"));
            Assert.assertFalse((boolean)table.checkAndMutate(Datasets.IDS[1], (QueryCondition)condition, rm));
            newRec = table.findById(Datasets.IDS[1]);
            Assert.assertNotNull((Object)newRec);
            try {
                newRec.getInt("x.y.z");
                Assert.fail((String)"DocumentMutation succeeded when it shouldn't have.");
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            Assert.assertEquals((long)104L, (long)newRec.getInt("p.q.r.s"));
        }
        catch (Throwable throwable) {
            DBTests.deleteTables(TABLE_NAME);
            throw throwable;
        }
        DBTests.deleteTables(TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInsertMultiFamily() throws Exception {
        try (JsonTable table = this.createOrReplaceTable();){
            Document developer = MapRDBImpl.newDocument();
            developer.set("a.b.c.d", Datasets.NAMES[0]);
            developer.set("a.b.e", Datasets.ADDRESSES[0]);
            developer.set("p.q.r.s", 105);
            table.insert(Datasets.IDS[0], developer);
            try {
                table.insert(Datasets.IDS[0], developer);
                Assert.fail((String)"Shouldn't be able to insert same record twice");
            }
            catch (DocumentExistsException documentExistsException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            DBTests.deleteTables(TABLE_NAME);
            throw throwable;
        }
        DBTests.deleteTables(TABLE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplaceMultiFamily() throws Exception {
        try (JsonTable table = this.createOrReplaceTable();){
            Document developer = MapRDBImpl.newDocument();
            developer.set("a.b.c.d", Datasets.NAMES[0]);
            developer.set("a.b.e", Datasets.ADDRESSES[0]);
            developer.set("p.q.r.s", 105);
            try {
                table.replace(Datasets.IDS[0], developer);
                Assert.fail((String)"Shouldn't be able to replace a non-existent record");
            }
            catch (DocumentNotFoundException documentNotFoundException) {
                // empty catch block
            }
            table.insert(Datasets.IDS[0], developer);
            table.replace(Datasets.IDS[0], developer);
        }
        catch (Throwable throwable) {
            DBTests.deleteTables(TABLE_NAME);
            throw throwable;
        }
        DBTests.deleteTables(TABLE_NAME);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        FAMILY_MAP = builder.put((Object)"f1", (Object)"a.b.c").put((Object)"f2", (Object)"p.q.r").put((Object)"f3", (Object)"a.b.e").put((Object)"f4", (Object)"n.e").put((Object)"f5", (Object)"n.e.s").put((Object)"f6", (Object)"n.e.s.t").put((Object)"f7", (Object)"n.e.s.t.e").put((Object)"f8", (Object)"n.e.s.t.e.d").build();
    }
}

