/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.ojai;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;

@Category(value={SimpleTest.class})
public class TestKeyValue
extends BaseTest {
    @Test
    public void testAsJsonString() throws IOException {
        URL url = Resources.getResource((String)"com/mapr/db/tests/json/test0.json");
        String content = Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        Document document = MapRDBImpl.newDocument((String)content);
        Assert.assertEquals((Object)"true", (Object)document.getValue("boolean").asJsonString());
        Assert.assertEquals((Object)"\"eureka\"", (Object)document.getValue("string").asJsonString());
        Assert.assertEquals((Object)"{\"$numberLong\":127}", (Object)document.getValue("byte").asJsonString());
        Assert.assertEquals((Object)"{\"$numberLong\":32767}", (Object)document.getValue("short").asJsonString());
        Assert.assertEquals((Object)"{\"$numberLong\":2147483647}", (Object)document.getValue("int").asJsonString());
        Assert.assertEquals((Object)"{\"$numberLong\":9223372036854775807}", (Object)document.getValue("long").asJsonString());
        Assert.assertEquals((Object)"3.4028235", (Object)document.getValue("float").asJsonString());
        Assert.assertEquals((Object)"1.7976931348623157E308", (Object)document.getValue("double").asJsonString());
        Assert.assertEquals((Object)"\"123456789012345678901234567890123456789012345678901.23456789\"", (Object)document.getValue("decimal").asJsonString());
        Assert.assertEquals((Object)"{\"$dateDay\":\"2012-10-20\"}", (Object)document.getValue("date").asJsonString());
        Assert.assertEquals((Object)"{\"$time\":\"07:42:46.123\"}", (Object)document.getValue("time").asJsonString());
        Assert.assertEquals((Object)"{\"$date\":\"2012-10-20T14:42:46.123Z\"}", (Object)document.getValue("timestamp").asJsonString());
        Assert.assertEquals((Object)"172800000", (Object)document.getValue("interval").asJsonString());
        Assert.assertEquals((Object)"{\"$binary\":\"YWJjZA==\"}", (Object)document.getValue("binary").asJsonString());
    }
}

