/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.impl;

import com.google.common.base.Preconditions;
import com.mapr.db.impl.ClonedCondition;
import com.mapr.db.impl.ConditionNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.ojai.FieldPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CorrelationTracker {
    private static final Logger _logger = LoggerFactory.getLogger(CorrelationTracker.class);
    final HashMap<String, TrackedCondition> trackedConditions = new HashMap();
    private static final Pattern OPEN_ARRAY = Pattern.compile("\\[\\]");
    private final Stack<ConditionNode> logicalStack = new Stack();

    public static boolean isOpenArrayPath(String fieldPath) {
        return fieldPath.indexOf("[]") > 0;
    }

    public static boolean isOpenArrayPath(FieldPath fieldPath) {
        return CorrelationTracker.isOpenArrayPath(fieldPath.toString());
    }

    public static boolean hasMultiLevelArray(String fieldPath) {
        return OPEN_ARRAY.matcher(fieldPath).results().count() > 1L;
    }

    public Set<ClonedCondition> getClonedConditions(String fieldPath) {
        TrackedCondition tc = this.trackedConditions.get(fieldPath);
        if (tc == null || tc.clonedConditions.size() == 0) {
            return Collections.EMPTY_SET;
        }
        return Collections.unmodifiableSet(tc.clonedConditions);
    }

    public int getTrackedConditionCount(String fieldPath) {
        TrackedCondition tc = this.trackedConditions.get(fieldPath);
        if (tc == null) {
            return 0;
        }
        return tc.conditions.size();
    }

    public void addKeyCondition(String fieldPath, String strCondition, ClonedCondition clonedCondition) {
        Preconditions.checkArgument((boolean)CorrelationTracker.isOpenArrayPath(fieldPath), (Object)("fieldPath is not an array path " + fieldPath));
        TrackedCondition tc = this.trackedConditions.get(fieldPath);
        if (tc == null) {
            tc = new TrackedCondition(fieldPath);
            this.trackedConditions.put(fieldPath, tc);
        }
        tc.conditions.add(strCondition);
        if (clonedCondition != null) {
            tc.clonedConditions.add(clonedCondition);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{trackedConditions = ");
        sb.append(this.trackedConditions.toString());
        sb.append(", logicalStack = ");
        sb.append(this.logicalStack);
        sb.append('}');
        return sb.toString();
    }

    public void push(ConditionNode conditionNode) {
        this.logicalStack.push(conditionNode);
    }

    public void pop(ConditionNode conditionNode) {
        ConditionNode poppedNode = this.logicalStack.pop();
        if (poppedNode != conditionNode) {
            throw new IllegalStateException();
        }
    }

    public boolean underCorrelation() {
        return !this.logicalStack.isEmpty() && this.logicalStack.peek() != null;
    }

    class TrackedCondition {
        String fieldPath;
        Set<String> conditions;
        Set<ClonedCondition> clonedConditions;

        TrackedCondition(String path) {
            this.fieldPath = path;
            this.conditions = new HashSet<String>();
            this.clonedConditions = new HashSet<ClonedCondition>();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.conditions);
            sb.append(":");
            sb.append(this.clonedConditions.toString());
            return sb.toString();
        }
    }
}

