/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tools;

import com.mapr.db.JsonTable;
import com.mapr.db.Table;
import com.mapr.db.impl.MapRDBImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.ojai.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportJson
extends Configured
implements Tool {
    private static final Logger logger = LoggerFactory.getLogger(ExportJson.class);
    private Path jsonFilePath_;
    private Path tablePath_;

    public ExportJson(Path tablePath, Path jsonFilePath) {
        this.tablePath_ = tablePath;
        this.jsonFilePath_ = jsonFilePath;
    }

    public ExportJson() {
    }

    public int run(String[] args) throws Exception {
        String[] otherArgs = new GenericOptionsParser(this.getConf(), args).getRemainingArgs();
        if (otherArgs == null || otherArgs.length != 2) {
            throw new IllegalArgumentException("ExportJson requires table name and json file path as argument. All other parameters must be specified as properties.");
        }
        this.tablePath_ = new Path(otherArgs[0]);
        this.jsonFilePath_ = new Path(otherArgs[1]);
        return this.run0();
    }

    public int run0() throws Exception {
        int code = 0;
        int recordCount = 0;
        boolean overwrite = this.getConf().getBoolean("export.overwrite", false);
        int printStatusEveryXRecord = this.getConf().getInt("print.status.every.x.record", 10000);
        FileSystem exportFileFS = FileSystem.get((URI)this.jsonFilePath_.toUri(), (Configuration)this.getConf());
        if (exportFileFS.exists(this.jsonFilePath_) && !overwrite) {
            throw new IOException("The output file '" + this.jsonFilePath_ + "' already exists.");
        }
        try (JsonTable table = MapRDBImpl.getTable(this.tablePath_);
             PrintStream out = new PrintStream((OutputStream)exportFileFS.create(this.jsonFilePath_, null, overwrite, 8192, exportFileFS.getDefaultReplication(this.jsonFilePath_), exportFileFS.getDefaultBlockSize(this.jsonFilePath_), null));){
            table.setOption(Table.TableOption.EXCLUDEID, false);
            for (Document record : table.find()) {
                out.println(record);
                if (++recordCount % printStatusEveryXRecord != 0) continue;
                logger.info("Exported {} records.", (Object)recordCount);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        logger.info("{} records exported.", (Object)recordCount);
        return code;
    }

    public static void main(String[] args) throws Exception {
        int ret = ToolRunner.run((Tool)new ExportJson(), (String[])args);
        System.exit(ret);
    }
}

