/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.ojai;

import com.mapr.db.impl.DBDocumentStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.ojai.Document;
import org.ojai.DocumentReader;

public class DBDocumentReaderIterable
implements Iterable<DocumentReader> {
    private final DBDocumentStream mapRDBRecordStream;
    Iterator<Document> recordIterator;

    public DBDocumentReaderIterable(DBDocumentStream recordStream) {
        this.mapRDBRecordStream = recordStream;
        this.recordIterator = this.mapRDBRecordStream.iterator();
    }

    @Override
    public Iterator<DocumentReader> iterator() {
        return new Iterator<DocumentReader>(){
            Document rec = null;

            @Override
            public boolean hasNext() {
                if (this.rec == null) {
                    if (DBDocumentReaderIterable.this.recordIterator.hasNext()) {
                        this.rec = DBDocumentReaderIterable.this.recordIterator.next();
                        return true;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public DocumentReader next() {
                if (this.rec == null && !this.hasNext()) {
                    throw new NoSuchElementException("next() called after hasNext() returned false.");
                }
                Document temp = this.rec;
                this.rec = null;
                return temp.asReader();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

