/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.kwps;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.mapr.fs.ServiceWatcher;
import com.mapr.kwps.BrokerDescriptor;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerWatcher
extends ServiceWatcher {
    private static final Logger log = LoggerFactory.getLogger(BrokerWatcher.class);
    private static final ObjectMapper JSON_SERDE = new ObjectMapper();
    private static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    private static final String SASL_MECHANISM = "sasl.mechanism";
    private static final String SECURITY_PROTOCOL_CONFIG = "security.protocol";
    private static final String DEFAULT_CLUSTER = "default-cluster";
    private static final String BROKERS_PATH_FORMAT = "/kafka-wire-protocol/%s/brokers";
    private static final String CONTROLLER_PATH_FORMAT = "/kafka-wire-protocol/%s/controller";
    private static final String METADATA_CHANGE_PATH_FORMAT = "/kafka-wire-protocol/%s/metadata/change";
    private final String brokersPath;
    private final String controllerPath;
    private final String metadataChangePath;
    private final Map<String, String> connectionProperties = new HashMap<String, String>();

    public BrokerWatcher(String zkConnectString, String zkClusterName) {
        this(zkConnectString, zkClusterName, Optional.empty());
    }

    public BrokerWatcher(String zkConnectString, String zkClusterName, Optional<String> kafkaCluster) {
        super(zkConnectString, zkClusterName);
        String kafkaClusterName = kafkaCluster.isEmpty() ? DEFAULT_CLUSTER : kafkaCluster.get();
        this.brokersPath = String.format(BROKERS_PATH_FORMAT, kafkaClusterName);
        this.controllerPath = String.format(CONTROLLER_PATH_FORMAT, kafkaClusterName);
        this.metadataChangePath = String.format(METADATA_CHANGE_PATH_FORMAT, kafkaClusterName);
    }

    public BrokerDescriptor getController() throws Exception {
        log.debug("Controller path: {}.", (Object)this.controllerPath);
        try {
            byte[] data = this.getData(this.controllerPath);
            return (BrokerDescriptor)JSON_SERDE.readValue(data, BrokerDescriptor.class);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public Iterable<BrokerDescriptor> getBrokers() throws Exception {
        ImmutableList.Builder builder = ImmutableList.builder();
        log.debug("Brokers path: {}.", (Object)this.brokersPath);
        try {
            ListIterator brokersItr = this.getChildren(this.brokersPath).listIterator();
            while (brokersItr.hasNext()) {
                BrokerDescriptor broker = this.getBroker((String)brokersItr.next());
                if (broker == null) continue;
                builder.add((Object)broker);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return builder.build();
    }

    public Map<String, String> getConnectionProperties() throws Exception {
        StringBuilder bootstrapServers = new StringBuilder();
        log.debug("Brokers path: {}.", (Object)this.brokersPath);
        try {
            ListIterator brokersItr = this.getChildren(this.brokersPath).listIterator();
            while (brokersItr.hasNext()) {
                this.readBrokerProps((String)brokersItr.next(), bootstrapServers);
            }
            if (bootstrapServers.length() > 0) {
                this.connectionProperties.put(BOOTSTRAP_SERVERS_CONFIG, bootstrapServers.substring(1));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return this.connectionProperties;
    }

    private BrokerDescriptor getBroker(String broker) throws Exception {
        try {
            byte[] data = this.getData(String.format("%s/%s", this.brokersPath, broker));
            String jsonStr = Bytes.toString((byte[])data);
            Map brokerProps = (Map)JSON_SERDE.readValue(jsonStr, HashMap.class);
            int brokerId = Integer.valueOf(broker.substring(broker.lastIndexOf(45) + 1));
            return new BrokerDescriptor(brokerId, brokerProps);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private void readBrokerProps(String broker, StringBuilder bootstrapServers) throws Exception {
        String saslMechanism;
        String securityProtocol;
        byte[] data = this.getData(String.format("%s/%s", this.brokersPath, broker));
        String jsonStr = Bytes.toString((byte[])data);
        Map brokerProps = (Map)JSON_SERDE.readValue(jsonStr, HashMap.class);
        String serverPort = (String)brokerProps.get(BOOTSTRAP_SERVERS_CONFIG);
        if (serverPort != null) {
            bootstrapServers.append(',').append(serverPort);
        }
        if ((securityProtocol = (String)brokerProps.get(SECURITY_PROTOCOL_CONFIG)) != null) {
            this.connectionProperties.putIfAbsent(SECURITY_PROTOCOL_CONFIG, securityProtocol);
        }
        if ((saslMechanism = (String)brokerProps.get(SASL_MECHANISM)) != null) {
            this.connectionProperties.putIfAbsent(SASL_MECHANISM, saslMechanism);
        }
    }

    public void notifyMetadataChange() throws IOException, InterruptedException, KeeperException {
        this.increment(this.metadataChangePath);
    }
}

