/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.securitypolicy;

import com.mapr.db.tests.utils.DBTests;
import com.mapr.fs.utils.ssh.RunCommand;
import com.mapr.fs.utils.ssh.TestCluster;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.ClusterTest;
import org.apache.hadoop.fs.Path;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ClusterTest.class})
public class TestJSONSecurityPolicySupportWithCluster
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestJSONSecurityPolicySupportWithCluster.class);
    private static String TABLE_NAME1;
    private static String TABLE_NAME2;
    private static String TABLE_NAME3;
    private static String TABLE_NAME4;
    private static String TABLE_NAME5;
    private static String TABLE_NAME6;
    private static String TABLE_NAME7;
    private static String TABLE_NAME8;
    private static String TABLE_NAME9;
    private static String TABLE_NAME10;
    private static String TABLE_NAME11;
    private static String TABLE_NAME12;
    private static String TABLE_NAME13;
    private static String TABLE_NAME14;
    private static String TABLE_NAME15;
    private static String TABLE_NAME16;
    private static String TABLE_NAME17;
    private static String TABLE_NAME18;
    private static String TABLE_NAME19;
    private static String TABLE_NAME20;
    private static Path tablePath5;
    private static Path tablePath6;
    private static Path tablePath7;
    private static Path tablePath8;
    private static Path tablePath9;
    private static Path tablePath10;
    private static Path tablePath11;
    private static Path tablePath12;
    private static Path tablePath13;
    private static Path tablePath14;
    private static Path tablePath15;
    private static Path tablePath16;
    private static Path tablePath17;
    private static Path tablePath18;
    private static Path tablePath19;
    private static Path tablePath20;

    @BeforeClass
    public static void prep() throws Exception {
        int exitCode = 0;
        TABLE_NAME1 = "testtable-TestJSONSecurityPolicySupport1";
        TABLE_NAME2 = "testtable-TestJSONSecurityPolicySupport2";
        TABLE_NAME3 = "testtable-TestJSONSecurityPolicySupport3";
        TABLE_NAME4 = "testtable-TestJSONSecurityPolicySupport4";
        TABLE_NAME5 = "testtable-TestJSONSecurityPolicySupport5";
        TABLE_NAME6 = "testtable-TestJSONSecurityPolicySupport6";
        TABLE_NAME7 = "testtable-TestJSONSecurityPolicySupport7";
        TABLE_NAME8 = "testtable-TestJSONSecurityPolicySupport8";
        TABLE_NAME9 = "testtable-TestJSONSecurityPolicySupport9";
        TABLE_NAME10 = "testtable-TestJSONSecurityPolicySupport10";
        TABLE_NAME11 = "testtable-TestJSONSecurityPolicySupport11";
        TABLE_NAME12 = "testtable-TestJSONSecurityPolicySupport12";
        TABLE_NAME13 = "testtable-TestJSONSecurityPolicySupport13";
        TABLE_NAME14 = "testtable-TestJSONSecurityPolicySupport14";
        TABLE_NAME15 = "testtable-TestJSONSecurityPolicySupport15";
        TABLE_NAME16 = "testtable-TestJSONSecurityPolicySupport16";
        TABLE_NAME17 = "testtable-TestJSONSecurityPolicySupport17";
        TABLE_NAME18 = "testtable-TestJSONSecurityPolicySupport18";
        TABLE_NAME19 = "testtable-TestJSONSecurityPolicySupport19";
        TABLE_NAME20 = "testtable-TestJSONSecurityPolicySupport20";
        tablePath5 = DBTests.getTablePath(TABLE_NAME5);
        tablePath6 = DBTests.getTablePath(TABLE_NAME6);
        tablePath7 = DBTests.getTablePath(TABLE_NAME7);
        tablePath8 = DBTests.getTablePath(TABLE_NAME8);
        tablePath9 = DBTests.getTablePath(TABLE_NAME9);
        tablePath10 = DBTests.getTablePath(TABLE_NAME10);
        tablePath11 = DBTests.getTablePath(TABLE_NAME11);
        tablePath12 = DBTests.getTablePath(TABLE_NAME12);
        tablePath13 = DBTests.getTablePath(TABLE_NAME13);
        tablePath14 = DBTests.getTablePath(TABLE_NAME14);
        tablePath15 = DBTests.getTablePath(TABLE_NAME15);
        tablePath16 = DBTests.getTablePath(TABLE_NAME16);
        tablePath17 = DBTests.getTablePath(TABLE_NAME17);
        tablePath18 = DBTests.getTablePath(TABLE_NAME18);
        tablePath19 = DBTests.getTablePath(TABLE_NAME19);
        tablePath20 = DBTests.getTablePath(TABLE_NAME20);
        _logger.info("Setting CLDB to global PBS master");
        DBTests.updatePolicyServiceMasterStatus();
        _logger.info("Checking if security policy pci exists");
        exitCode = TestCluster.runCommand((String)"maprcli security policy info -columns policyname -name pci").getExitCode();
        if (exitCode != 0) {
            _logger.info("Security policy pci does not exist, creating");
            TestCluster.runCommand((String)"maprcli security policy create -name pci -allowtagging true");
        } else {
            _logger.info("Security policy pci already exists, setting allowtagging to true");
            TestCluster.runCommand((String)"maprcli security policy modify -name pci -allowtagging true");
        }
        _logger.info("Checking if security policy hipaa exists");
        exitCode = TestCluster.runCommand((String)"maprcli security policy info -columns policyname -name hipaa").getExitCode();
        if (exitCode != 0) {
            _logger.info("Security policy hipaa does not exist, creating");
            TestCluster.runCommand((String)"maprcli security policy create -name hipaa -allowtagging true");
        } else {
            _logger.info("Security policy hipaa already exists, setting allowtagging to true");
            TestCluster.runCommand((String)"maprcli security policy modify -name hipaa -allowtagging true");
        }
        _logger.info("Checking if security policy general exists");
        exitCode = TestCluster.runCommand((String)"maprcli security policy info -columns policyname -name general").getExitCode();
        if (exitCode != 0) {
            _logger.info("Security policy general does not exist, creating");
            TestCluster.runCommand((String)"maprcli security policy create -name general -allowtagging true");
        } else {
            _logger.info("Security policy general already exists, setting allowtagging to true");
            TestCluster.runCommand((String)"maprcli security policy modify -name general -allowtagging true");
        }
        _logger.info("Checking if security policy nottaggable exists");
        exitCode = TestCluster.runCommand((String)"maprcli security policy info -columns policyname -name nottaggable").getExitCode();
        if (exitCode != 0) {
            _logger.info("Security policy nottaggable does not exist, creating");
            TestCluster.runCommand((String)"maprcli security policy create -name nottaggable -allowtagging false");
        } else {
            _logger.info("Security policy nottaggable already exists, setting allowtagging to false");
            TestCluster.runCommand((String)"maprcli security policy modify -name nottaggable -allowtagging false");
        }
    }

    @AfterClass
    public static void cleanup() throws Exception {
        DBTests.deleteTables(TABLE_NAME1);
        DBTests.deleteTables(TABLE_NAME2);
        DBTests.deleteTables(TABLE_NAME3);
        DBTests.deleteTables(TABLE_NAME4);
        DBTests.deleteTables(TABLE_NAME5);
        DBTests.deleteTables(TABLE_NAME6);
        DBTests.deleteTables(TABLE_NAME7);
        DBTests.deleteTables(TABLE_NAME8);
        DBTests.deleteTables(TABLE_NAME9);
        DBTests.deleteTables(TABLE_NAME10);
        DBTests.deleteTables(TABLE_NAME11);
        DBTests.deleteTables(TABLE_NAME11);
        DBTests.deleteTables(TABLE_NAME12);
        DBTests.deleteTables(TABLE_NAME13);
        DBTests.deleteTables(TABLE_NAME14);
        DBTests.deleteTables(TABLE_NAME15);
        DBTests.deleteTables(TABLE_NAME16);
        DBTests.deleteTables(TABLE_NAME17);
        DBTests.deleteTables(TABLE_NAME18);
        DBTests.deleteTables(TABLE_NAME19);
        DBTests.deleteTables(TABLE_NAME20);
    }

    @Test
    public void testExistingTableCfAddPBS() throws Exception {
        String tableCreateCommand = "maprcli table create -path " + tablePath5 + " -tabletype json";
        _logger.info("Running command " + tableCreateCommand);
        TestCluster.runCommand((String)tableCreateCommand);
        String tableCfAddCommand = "maprcli table cf securitypolicy add -path " + tablePath5 + " -cfname default -securitypolicy pci";
        _logger.info("Running command " + tableCfAddCommand);
        TestCluster.runCommand((String)tableCfAddCommand);
        this.checkCfTagExistence(tablePath5, "[pci]");
    }

    @Test
    public void testExistingTableCfRemovePBS() throws Exception {
        String tableCreateCommand = "maprcli table create -path " + tablePath6 + " -tabletype json";
        _logger.info("Running command " + tableCreateCommand);
        TestCluster.runCommand((String)tableCreateCommand);
        String tableCfRemoveCommand = "maprcli table cf securitypolicy add -path " + tablePath6 + " -cfname default -securitypolicy pci";
        _logger.info("Running command " + tableCfRemoveCommand);
        TestCluster.runCommand((String)tableCfRemoveCommand);
        String tableCfAddCommand = "maprcli table cf securitypolicy remove -path " + tablePath6 + " -cfname default -securitypolicy pci";
        _logger.info("Running command " + tableCfAddCommand);
        TestCluster.runCommand((String)tableCfAddCommand);
        this.checkCfTagExistence(tablePath6, "[]");
    }

    @Test
    public void testExistingTableCfSetPBS() throws Exception {
        String tableCreateCommand = "maprcli table create -path " + tablePath7 + " -tabletype json";
        _logger.info("Running command " + tableCreateCommand);
        TestCluster.runCommand((String)tableCreateCommand);
        String tableCfSetCommand = "maprcli table cf securitypolicy add -path " + tablePath7 + " -cfname default -securitypolicy pci";
        _logger.info("Running command " + tableCfSetCommand);
        TestCluster.runCommand((String)tableCfSetCommand);
        String tableCfAddCommand = "maprcli table cf securitypolicy set -path " + tablePath7 + " -cfname default -securitypolicy hipaa";
        _logger.info("Running command " + tableCfAddCommand);
        TestCluster.runCommand((String)tableCfAddCommand);
        this.checkCfTagExistence(tablePath7, "[hipaa]");
    }

    @Test
    public void testCreateTableWithSecurityPolicy() throws Exception {
        int exitCode = 0;
        String tableCreateCommand = "maprcli table create -path " + tablePath8 + " -tabletype json -securitypolicy pci";
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.checkTableTagExistence(tablePath8, "[pci]");
    }

    @Test
    public void testModifyTableSecurityPolicySet() throws Exception {
        int exitCode = 0;
        String tableCreateCommand = "maprcli table create -path " + tablePath9 + " -tabletype json -securitypolicy pci";
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String tableSecurityPolicySetCommand = "maprcli table securitypolicy set -path " + tablePath9 + " -securitypolicy hipaa";
        exitCode = TestCluster.runCommand((String)tableSecurityPolicySetCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.checkTableTagExistence(tablePath9, "[hipaa]");
    }

    @Test
    public void testModifyTableSecurityPolicyAdd() throws Exception {
        int exitCode = 0;
        String tableCreateCommand = "maprcli table create -path " + tablePath10 + " -tabletype json -securitypolicy pci";
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String tableSecurityPolicyAddCommand = "maprcli table securitypolicy add -path " + tablePath10 + " -securitypolicy hipaa";
        exitCode = TestCluster.runCommand((String)tableSecurityPolicyAddCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.checkTableTagExistence(tablePath10, "[pci, hipaa]");
    }

    @Test
    public void testModifyTableSecurityPolicyRemove() throws Exception {
        int exitCode = 0;
        String tableCreateCommand = "maprcli table create -path " + tablePath11 + " -tabletype json -securitypolicy pci,hipaa";
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String tableSecurityPolicyRemoveCommand = "maprcli table securitypolicy remove -path " + tablePath11 + " -securitypolicy hipaa";
        exitCode = TestCluster.runCommand((String)tableSecurityPolicyRemoveCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.checkTableTagExistence(tablePath11, "[pci]");
    }

    @Test
    public void testCreateTableWithDuplicateSecurityPolicy() throws Exception {
        int exitCode = 0;
        String tableCreateCommand = "maprcli table create -path " + tablePath12 + " -tabletype json -securitypolicy pci,pci,hipaa,pci,hipaa";
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.checkTableTagExistence(tablePath12, "[pci, hipaa]");
    }

    @Test
    public void testModifyColumnSecurityPolicySet() throws Exception {
        int exitCode = 0;
        String tableCreateCommand = "maprcli table create -path " + tablePath13 + " -tabletype json";
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String columnSecurityPolicySetCommand = "maprcli table cf column securitypolicy set -path " + tablePath13 + " -cfname default -name test13col -securitypolicy pci,hipaa";
        exitCode = TestCluster.runCommand((String)columnSecurityPolicySetCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.checkColumnTagExistence(tablePath13, "default", "test13col", "[pci, hipaa]");
    }

    @Test
    public void testModifyColumnSecurityPolicyAdd() throws Exception {
        int exitCode = 0;
        String tableCreateCommand = "maprcli table create -path " + tablePath14 + " -tabletype json";
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String columnSecurityPolicySetCommand = "maprcli table cf column securitypolicy set -path " + tablePath14 + " -cfname default -name test14col -securitypolicy pci";
        exitCode = TestCluster.runCommand((String)columnSecurityPolicySetCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.checkColumnTagExistence(tablePath14, "default", "test14col", "[pci]");
        String columnSecurityPolicyAddCommand = "maprcli table cf column securitypolicy add -path " + tablePath14 + " -cfname default -name test14col -securitypolicy hipaa";
        exitCode = TestCluster.runCommand((String)columnSecurityPolicyAddCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.checkColumnTagExistence(tablePath14, "default", "test14col", "[pci, hipaa]");
    }

    @Test
    public void testModifyColumnSecurityPolicyRemove() throws Exception {
        int exitCode = 0;
        String tableCreateCommand = "maprcli table create -path " + tablePath15 + " -tabletype json";
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String columnSecurityPolicySetCommand = "maprcli table cf column securitypolicy set -path " + tablePath15 + " -cfname default -name test15col -securitypolicy pci,hipaa,general";
        exitCode = TestCluster.runCommand((String)columnSecurityPolicySetCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.checkColumnTagExistence(tablePath15, "default", "test15col", "[pci, hipaa, general]");
        String columnSecurityPolicyRemoveCommand = "maprcli table cf column securitypolicy remove -path " + tablePath15 + " -cfname default -name test15col -securitypolicy hipaa";
        exitCode = TestCluster.runCommand((String)columnSecurityPolicyRemoveCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.checkColumnTagExistence(tablePath15, "default", "test15col", "[pci, general]");
    }

    @Test
    public void testCreateTableSecurityPolicyNotTaggable() throws Exception {
        int exitCode = 0;
        String tableCreateCommand = "maprcli table create -path " + tablePath16 + " -tabletype json -securitypolicy nottaggable";
        _logger.info("Running command " + tableCreateCommand);
        RunCommand rc = TestCluster.runCommand((String)tableCreateCommand);
        _logger.info("Verifying that status code is non-zero");
        exitCode = rc.getExitCode();
        Assert.assertEquals((long)1L, (long)exitCode);
        String actualErrMsg = rc.getStdOut();
        if (actualErrMsg == null) {
            actualErrMsg = "";
        }
        String expectedErrorMsg = "Failed to create table: " + tablePath16 + ". Tagging not allowed for security policy nottaggable";
        _logger.info("Comparing expected error message " + expectedErrorMsg + " with actual " + actualErrMsg);
        int indexOfString = actualErrMsg.indexOf(expectedErrorMsg);
        Assert.assertNotEquals((long)indexOfString, (long)-1L);
    }

    @Test
    public void testCreateTableCfSecurityPolicyNotTaggable() throws Exception {
        int exitCode = 0;
        String tableCreateCommand = "maprcli table create -path " + tablePath17 + " -tabletype json";
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String tableCfCreateCommand = "maprcli table cf create -path " + tablePath17 + " -cfname testcf -securitypolicy nottaggable -force true -jsonpath a.b.c";
        _logger.info("Running command " + tableCfCreateCommand);
        RunCommand rc = TestCluster.runCommand((String)tableCfCreateCommand);
        _logger.info("Verifying that status code is non-zero");
        exitCode = rc.getExitCode();
        Assert.assertEquals((long)1L, (long)exitCode);
        String actualErrMsg = rc.getStdOut();
        if (actualErrMsg == null) {
            actualErrMsg = "";
        }
        String expectedErrorMsg = "Failed to create column family on table: " + tablePath17 + " with name testcf. Tagging not allowed for security policy nottaggable";
        _logger.info("Comparing expected error message " + expectedErrorMsg + " with actual " + actualErrMsg);
        int indexOfString = actualErrMsg.indexOf(expectedErrorMsg);
        Assert.assertNotEquals((long)indexOfString, (long)-1L);
    }

    @Test
    public void testModifyTableCfSecurityPolicyNotTaggable() throws Exception {
        int exitCode = 0;
        String tableCreateCommand = "maprcli table create -path " + tablePath18 + " -tabletype json";
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String tableCfAddCommand = "maprcli table cf securitypolicy add -path " + tablePath18 + " -cfname default -securitypolicy nottaggable";
        _logger.info("Running command " + tableCfAddCommand);
        RunCommand rc = TestCluster.runCommand((String)tableCfAddCommand);
        _logger.info("Verifying that status code is non-zero");
        exitCode = rc.getExitCode();
        Assert.assertEquals((long)1L, (long)exitCode);
        String actualErrMsg = rc.getStdOut();
        if (actualErrMsg == null) {
            actualErrMsg = "";
        }
        String expectedErrorMsg = "Failed to modify column family on table: " + tablePath18 + " with name default. Tagging not allowed for security policy nottaggable";
        _logger.info("Comparing expected error message " + expectedErrorMsg + " with actual " + actualErrMsg);
        int indexOfString = actualErrMsg.indexOf(expectedErrorMsg);
        Assert.assertNotEquals((long)indexOfString, (long)-1L);
    }

    @Test
    public void testModifyColumnSecurityPolicyNotTaggable() throws Exception {
        int exitCode = 0;
        String tableCreateCommand = "maprcli table create -path " + tablePath19 + " -tabletype json";
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String columnSecurityPolicySetCommand = "maprcli table cf column securitypolicy set -path " + tablePath19 + " -cfname default -name test19col -securitypolicy pci,nottaggable";
        RunCommand rc = TestCluster.runCommand((String)columnSecurityPolicySetCommand);
        _logger.info("Verifying that status code is non-zero");
        exitCode = rc.getExitCode();
        Assert.assertEquals((long)1L, (long)exitCode);
        String actualErrMsg = rc.getStdOut();
        if (actualErrMsg == null) {
            actualErrMsg = "";
        }
        String expectedErrorMsg = "Failed to modify column family on table: " + tablePath19 + " with name default. Tagging not allowed for security policy nottaggable";
        _logger.info("Comparing expected error message " + expectedErrorMsg + " with actual " + actualErrMsg);
        int indexOfString = actualErrMsg.indexOf(expectedErrorMsg);
        Assert.assertNotEquals((long)indexOfString, (long)-1L);
    }

    @Test
    public void testReplicaSecurityPolicy() throws Exception {
        int exitCode = 0;
        String TABLE_NAME20_REPLICA = "testtable-TestJSONSecurityPolicySupport20-Replica";
        Path tablePath20Replica = DBTests.getTablePath("testtable-TestJSONSecurityPolicySupport20-Replica");
        String tableCreateCommand = "maprcli table create -path " + tablePath20 + " -tabletype json";
        _logger.info("Running command " + tableCreateCommand);
        exitCode = TestCluster.runCommand((String)tableCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        String tableSecurityPolicySetCommand = "maprcli table securitypolicy set -path " + tablePath20 + " -securitypolicy hipaa";
        exitCode = TestCluster.runCommand((String)tableSecurityPolicySetCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.checkTableTagExistence(tablePath20, "[hipaa]");
        String tableCfSetCommand = "maprcli table cf securitypolicy set -path " + tablePath20 + " -cfname default -securitypolicy hipaa";
        _logger.info("Running command " + tableCfSetCommand);
        TestCluster.runCommand((String)tableCfSetCommand);
        this.checkCfTagExistence(tablePath20, "[hipaa]");
        String columnSecurityPolicySetCommand = "maprcli table cf column securitypolicy set -path " + tablePath20 + " -cfname default -name test20col -securitypolicy hipaa";
        exitCode = TestCluster.runCommand((String)columnSecurityPolicySetCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.checkColumnTagExistence(tablePath20, "default", "test20col", "[hipaa]");
        String replicaCreateCommand = "maprcli table replica autosetup -path " + tablePath20 + " -replica " + tablePath20Replica;
        exitCode = TestCluster.runCommand((String)replicaCreateCommand).getExitCode();
        Assert.assertEquals((long)0L, (long)exitCode);
        this.checkTableTagExistence(tablePath20Replica, "[hipaa]");
        this.checkCfTagExistence(tablePath20Replica, "[hipaa]");
        this.checkColumnTagExistence(tablePath20Replica, "default", "test20col", "[hipaa]");
        DBTests.deleteTables("testtable-TestJSONSecurityPolicySupport20-Replica");
    }

    private void checkCfTagExistence(Path tablePath, String expectedTag) throws Exception {
        String cfListCommand = "maprcli table cf list -path " + tablePath + " -json";
        _logger.info("Running command " + cfListCommand);
        String cfListOutput = TestCluster.runCommand((String)cfListCommand).getStdOut();
        String cfListOutputJSONString = this.convertToJSONReadableString(cfListOutput);
        JSONObject cfListOutputJSONObject = new JSONObject(cfListOutputJSONString);
        JSONArray cfList = cfListOutputJSONObject.getJSONArray("data");
        for (int i = 0; i < cfList.length(); ++i) {
            JSONObject columnFamily = cfList.getJSONObject(i);
            String cfName = columnFamily.getString("cfname");
            if (!cfName.equals("default")) continue;
            String policyTag = columnFamily.getString("securitypolicy");
            Assert.assertEquals((Object)expectedTag, (Object)policyTag);
        }
    }

    private void checkTableTagExistence(Path tablePath, String expectedTag) throws Exception {
        String tableListCommand = "maprcli table info -path " + tablePath + " -json";
        _logger.info("Running command " + tableListCommand);
        String tableListOutput = TestCluster.runCommand((String)tableListCommand).getStdOut();
        String tableListOutputJSONString = this.convertToJSONReadableString(tableListOutput);
        JSONObject tableListOutputJSONObject = new JSONObject(tableListOutputJSONString);
        JSONArray tableList = tableListOutputJSONObject.getJSONArray("data");
        for (int i = 0; i < tableList.length(); ++i) {
            JSONObject tableProperty = tableList.getJSONObject(i);
            String policyTag = tableProperty.getString("securitypolicy");
            _logger.info("Comparing expected tag " + expectedTag + " with actual " + policyTag);
            Assert.assertEquals((Object)expectedTag, (Object)policyTag);
        }
    }

    private void checkColumnTagExistence(Path tablePath, String cfName, String columnName, String expectedTag) throws Exception {
        _logger.info("Verifying column-level tag for table " + tablePath.toString() + ", CF " + cfName + ", column " + columnName);
        String columnListCommand = "maprcli table cf column securitypolicy list -path " + tablePath + " -cfname " + cfName + " -name " + columnName + " -json";
        _logger.info("Running command " + columnListCommand);
        String columnListOutput = TestCluster.runCommand((String)columnListCommand).getStdOut();
        String columnListOutputJSONString = this.convertToJSONReadableString(columnListOutput);
        JSONObject columnListOutputJSONObject = new JSONObject(columnListOutputJSONString);
        JSONArray columnList = columnListOutputJSONObject.getJSONArray("data");
        for (int i = 0; i < columnList.length(); ++i) {
            JSONObject column = columnList.getJSONObject(i);
            String colName = column.getString("name");
            if (!colName.equals(columnName)) continue;
            String policyTag = column.getString("securitypolicy");
            Assert.assertEquals((Object)expectedTag, (Object)policyTag);
        }
    }

    private String convertToJSONReadableString(String input) {
        return input.replace("\"", "'");
    }
}

