/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.util;

import java.nio.ByteBuffer;

public class ByteBufferHashKey {
    static final int HASH_OF_EMPTY_BYTES = 1126253345;
    static final int HASH_PRIME = 37;
    private byte[] bArray_;
    private ByteBuffer bBuffer_;
    private int bPosition_;
    private int bLength_;
    private int hascode_;

    ByteBufferHashKey() {
        this.reset();
    }

    void reset() {
        this.bArray_ = null;
        this.bBuffer_ = null;
        this.bPosition_ = 0;
        this.bLength_ = 0;
        this.hascode_ = 1126253345;
    }

    boolean isEmpty() {
        if (this.bArray_ == null && this.bBuffer_ == null) {
            return true;
        }
        if (this.bArray_ != null) {
            return this.bArray_.length == 0;
        }
        return this.bLength_ == 0;
    }

    void wrap(byte[] inArray) {
        this.bArray_ = inArray;
        this.bBuffer_ = null;
        this.bPosition_ = 0;
        this.bLength_ = 0;
        this.hascode_ = ByteBufferHashKey.computeHash(this.bArray_);
    }

    void wrap(ByteBuffer inBuffer, int position, int length) {
        this.bArray_ = null;
        this.bBuffer_ = inBuffer;
        this.bPosition_ = position;
        this.bLength_ = length;
        this.hascode_ = ByteBufferHashKey.computeHash(inBuffer, position, length);
    }

    byte[] getByteArray() {
        return this.bArray_;
    }

    static int computeHash(byte[] inArray) {
        int result = 1126253345;
        for (byte b : inArray) {
            result = 37 * result + b;
        }
        return result;
    }

    static int computeHash(ByteBuffer inBuffer, int position, int length) {
        int result = 1126253345;
        int end = position + length;
        for (int i = position; i < end; ++i) {
            byte bvalue = inBuffer.get(i);
            result = 37 * result + bvalue;
        }
        return result;
    }

    void set(byte[] inArray) {
        this.bArray_ = new byte[inArray.length];
        System.arraycopy(inArray, 0, this.bArray_, 0, inArray.length);
        this.hascode_ = ByteBufferHashKey.computeHash(this.bArray_);
        this.bBuffer_ = null;
        this.bPosition_ = 0;
        this.bLength_ = 0;
    }

    void set(ByteBuffer inBuffer, int position, int length) {
        this.bArray_ = new byte[length];
        inBuffer.position(position);
        inBuffer.get(this.bArray_);
        this.hascode_ = ByteBufferHashKey.computeHash(this.bArray_);
        this.bBuffer_ = null;
        this.bPosition_ = 0;
        this.bLength_ = 0;
    }

    void set(ByteBufferHashKey inHashKey) {
        if (inHashKey.bArray_ != null) {
            this.set(inHashKey.bArray_);
        } else if (inHashKey.bBuffer_ != null) {
            this.set(inHashKey.bBuffer_, inHashKey.bPosition_, inHashKey.bLength_);
        } else {
            this.reset();
        }
    }

    public int hashCode() {
        return this.hascode_;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ByteBufferHashKey)) {
            return false;
        }
        ByteBufferHashKey bHaskKey2 = (ByteBufferHashKey)obj;
        if (this.isEmpty()) {
            return bHaskKey2.isEmpty();
        }
        if (this.bArray_ != null && bHaskKey2.bArray_ != null) {
            return ByteBufferHashKey.compareHashKey(this.bArray_, bHaskKey2.bArray_);
        }
        if (this.bArray_ != null && bHaskKey2.bBuffer_ != null) {
            return ByteBufferHashKey.compareHashKey(this.bArray_, bHaskKey2.bBuffer_, bHaskKey2.bPosition_, bHaskKey2.bLength_);
        }
        if (this.bArray_ != null) {
            return false;
        }
        if (this.bBuffer_ != null && bHaskKey2.bArray_ != null) {
            return ByteBufferHashKey.compareHashKey(bHaskKey2.bArray_, this.bBuffer_, this.bPosition_, this.bLength_);
        }
        if (this.bBuffer_ != null && bHaskKey2.bBuffer_ != null) {
            return ByteBufferHashKey.compareHashKey(this.bBuffer_, this.bPosition_, this.bLength_, bHaskKey2.bBuffer_, bHaskKey2.bPosition_, bHaskKey2.bLength_);
        }
        if (this.bBuffer_ != null) {
            return false;
        }
        assert (false);
        return false;
    }

    static boolean compareHashKey(byte[] bArray1, byte[] bArray2) {
        if (bArray1.length != bArray2.length) {
            return false;
        }
        for (int i = 0; i < bArray1.length; ++i) {
            if (bArray1[i] == bArray2[i]) continue;
            return false;
        }
        return true;
    }

    static boolean compareHashKey(byte[] bArray1, ByteBuffer bBuffer2, int position2, int length2) {
        if (bArray1.length != length2) {
            return false;
        }
        for (int i = 0; i < bArray1.length; ++i) {
            if (bArray1[i] == bBuffer2.get(position2 + i)) continue;
            return false;
        }
        return true;
    }

    static boolean compareHashKey(ByteBuffer bBuffer1, int position1, int length1, ByteBuffer bBuffer2, int position2, int length2) {
        if (length1 != length2) {
            return false;
        }
        for (int i = 0; i < length1; ++i) {
            if (bBuffer1.get(position1 + i) == bBuffer2.get(position2 + i)) continue;
            return false;
        }
        return true;
    }
}

