/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.tableops;

import com.mapr.db.JsonTable;
import com.mapr.db.MetaTable;
import com.mapr.db.impl.ConditionImpl;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.index.IndexDesc;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.RowcolCodec;
import com.mapr.db.scan.ScanRange;
import com.mapr.db.tests.utils.DBTests;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.FlakyTest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.DocumentConstants;
import org.ojai.DocumentStream;
import org.ojai.FieldPath;
import org.ojai.json.Json;
import org.ojai.store.QueryCondition;
import org.ojai.store.SortOrder;

@Category(value={FlakyTest.class})
public class TestTabletSegmentScanner
extends BaseTest {
    private static final FieldPath ABC_FIELD = FieldPath.parseFrom((String)"abc");
    private static final FieldPath DOCUMENT_ID = FieldPath.parseFrom((String)"documentId");
    private static final String TABLE_NAME = "test_TestTabletSegmentScanner";
    private static JsonTable table;
    private static JsonTable regularIndexTable;
    private static JsonTable hashedIndexTable;
    private static MetaTable metaTable;
    private static MetaTable regularIndexMetaTable;
    private static MetaTable hashedIndexMetaTable;

    @BeforeClass
    public static void setup_TestTabletSegmentScanner() throws Exception {
        System.setProperty("com.mapr.db.tabletsegmentscanner.core-pool-size", "2");
        System.setProperty("com.mapr.db.tabletsegmentscanner.max-pool-size", "2");
        try (InputStream testJson = TestTabletSegmentScanner.class.getResourceAsStream("/com/mapr/db/tests/json/large_document.json");
             DocumentStream stream = Json.newDocumentStream((InputStream)testJson);){
            table = DBTests.createOrReplaceTable(TABLE_NAME, new String[]{"B", "E", "G", "J", "L", "M", "P", "R"});
            DBTests.createIndex(table, "regularIndex", false, 0, new String[]{DOCUMENT_ID.asPathString()}, new SortOrder[]{SortOrder.ASC}, new String[]{"a.b", ABC_FIELD.asPathString()});
            DBTests.createIndex(table, "hashedIndex", true, 16, new String[]{DOCUMENT_ID.asPathString()}, new SortOrder[]{SortOrder.ASC}, new String[]{"a.b", ABC_FIELD.asPathString()});
            DBDocumentImpl largeDocument = RowcolCodec.getDBDocument((Document)((Document)stream.iterator().next()));
            for (char ch = 'A'; ch <= 'T'; ch = (char)((char)(ch + 1))) {
                for (int rowIndex = 0; rowIndex < 500; ++rowIndex) {
                    String id = ch + String.format("%010d", rowIndex);
                    largeDocument.set(DOCUMENT_ID, rowIndex);
                    largeDocument.set(ABC_FIELD, id);
                    table.insertOrReplace(id, (Document)largeDocument);
                }
            }
            table.flush();
            metaTable = table.getMetaTable();
            DBTests.waitForRowCount(table.getPath(), 10000L);
            DBTests.waitForIndexFlush(table.getPath());
            Iterator allIndexes = DBTests.admin().getTableIndexes(table.getPath()).iterator();
            regularIndexTable = MapRDBImpl.getIndexTable((IndexDesc)((IndexDesc)allIndexes.next()));
            regularIndexMetaTable = regularIndexTable.getMetaTable();
            hashedIndexTable = MapRDBImpl.getIndexTable((IndexDesc)((IndexDesc)allIndexes.next()));
            hashedIndexMetaTable = hashedIndexTable.getMetaTable();
        }
    }

    @AfterClass
    public static void cleanup_TestTabletSegmentScanner() throws IOException, Exception {
        if (table != null) {
            table.close();
            regularIndexTable.close();
            hashedIndexTable.close();
            DBTests.deleteTables(TABLE_NAME);
        }
    }

    @Test
    public void test_TestTabletSegmentScanner_multi_tablets_primary_table() throws Exception {
        List scanRanges = metaTable.getScanRanges(32);
        this.assertScanRangesSize(40, scanRanges);
        ConditionImpl conditionOnAdjecentTabletBoundries = MapRDBImpl.newCondition().and().is(DocumentConstants.ID_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "L").is(DocumentConstants.ID_FIELD, QueryCondition.Op.LESS_OR_EQUAL, "M").is(DOCUMENT_ID, QueryCondition.Op.GREATER_OR_EQUAL, 250).close().build();
        scanRanges = metaTable.getScanRanges((QueryCondition)conditionOnAdjecentTabletBoundries, 32);
        this.assertScanRangesSize(3, scanRanges);
        int docCount = 0;
        for (ScanRange scanRange : scanRanges) {
            ConditionImpl findCondition = MapRDBImpl.newCondition().and().condition(scanRange.getCondition()).condition((QueryCondition)conditionOnAdjecentTabletBoundries).close().build();
            DocumentStream stream = table.find((QueryCondition)findCondition, new FieldPath[]{DocumentConstants.ID_FIELD, DOCUMENT_ID});
            for (Document document : stream) {
                ++docCount;
                Assert.assertTrue((document.getInt(DOCUMENT_ID) >= 250 ? 1 : 0) != 0);
            }
        }
        Assert.assertEquals((long)250L, (long)docCount);
        ConditionImpl conditionOnNonRowKeyField = MapRDBImpl.newCondition().and().is(ABC_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "L").is(ABC_FIELD, QueryCondition.Op.LESS_OR_EQUAL, "M").close().build();
        scanRanges = metaTable.getScanRanges((QueryCondition)conditionOnNonRowKeyField, 32);
        this.assertScanRangesSize(40, scanRanges);
        docCount = 0;
        for (ScanRange scanRange : scanRanges) {
            ConditionImpl findCondition = MapRDBImpl.newCondition().and().condition(scanRange.getCondition()).condition((QueryCondition)conditionOnNonRowKeyField).close().build();
            DocumentStream stream = table.find((QueryCondition)findCondition, new FieldPath[]{DocumentConstants.ID_FIELD, ABC_FIELD});
            for (Document document : stream) {
                ++docCount;
                Assert.assertTrue((document.getString(ABC_FIELD).compareTo("L") >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((document.getString(ABC_FIELD).compareTo("M") <= 0 ? 1 : 0) != 0);
            }
        }
        Assert.assertEquals((long)500L, (long)docCount);
    }

    @Test
    public void test_TestTabletSegmentScanner_multi_tablets_index_table() throws Exception {
        List scanRanges = regularIndexMetaTable.getScanRanges(32);
        this.assertScanRangesSize(8, scanRanges);
        ConditionImpl conditionOnAdjecentTabletBoundries = MapRDBImpl.newCondition().and().is(DOCUMENT_ID, QueryCondition.Op.GREATER_OR_EQUAL, 200).is(DOCUMENT_ID, QueryCondition.Op.LESS_OR_EQUAL, 400).close().build();
        scanRanges = regularIndexMetaTable.getScanRanges((QueryCondition)conditionOnAdjecentTabletBoundries, 32);
        this.assertScanRangesSize(4, scanRanges);
        int docCount = 0;
        for (ScanRange scanRange : scanRanges) {
            ConditionImpl findCondition = MapRDBImpl.newCondition().and().condition(scanRange.getCondition()).condition((QueryCondition)conditionOnAdjecentTabletBoundries).close().build();
            DocumentStream stream = regularIndexTable.find((QueryCondition)findCondition, new FieldPath[]{DocumentConstants.ID_FIELD, DOCUMENT_ID});
            for (Document document : stream) {
                ++docCount;
                Assert.assertTrue((document.getInt(DOCUMENT_ID) >= 200 ? 1 : 0) != 0);
                Assert.assertTrue((document.getInt(DOCUMENT_ID) <= 400 ? 1 : 0) != 0);
            }
        }
        Assert.assertEquals((long)4020L, (long)docCount);
        ConditionImpl conditionOnNonIndexedField = MapRDBImpl.newCondition().and().is(ABC_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "L").is(ABC_FIELD, QueryCondition.Op.LESS_OR_EQUAL, "M").close().build();
        scanRanges = regularIndexMetaTable.getScanRanges((QueryCondition)conditionOnNonIndexedField, 32);
        this.assertScanRangesSize(8, scanRanges);
        docCount = 0;
        for (ScanRange scanRange : scanRanges) {
            ConditionImpl findCondition = MapRDBImpl.newCondition().and().condition(scanRange.getCondition()).condition((QueryCondition)conditionOnNonIndexedField).close().build();
            DocumentStream stream = regularIndexTable.find((QueryCondition)findCondition, new FieldPath[]{DocumentConstants.ID_FIELD, ABC_FIELD});
            for (Document document : stream) {
                ++docCount;
                Assert.assertTrue((document.getString(ABC_FIELD).compareTo("L") >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((document.getString(ABC_FIELD).compareTo("M") <= 0 ? 1 : 0) != 0);
            }
        }
        Assert.assertEquals((long)500L, (long)docCount);
    }

    private void assertScanRangesSize(int minExpectedScanSize, List<ScanRange> scanRanges) {
        System.out.println("Scan Ranges:");
        for (ScanRange scanRange : scanRanges) {
            System.out.println(scanRange);
        }
        Assert.assertTrue((String)String.format("Number of scan ranges (%s) are less than expected (%s).", scanRanges.size(), minExpectedScanSize), (scanRanges.size() >= minExpectedScanSize ? 1 : 0) != 0);
    }

    @Test
    public void test_TestTabletSegmentScanner_multi_tablets_hashed_index_table() throws Exception {
        List scanRanges = hashedIndexMetaTable.getScanRanges(32);
        this.assertScanRangesSize(8, scanRanges);
        ConditionImpl conditionOnAdjecentTabletBoundries = MapRDBImpl.newCondition().and().is(DOCUMENT_ID, QueryCondition.Op.GREATER_OR_EQUAL, 200).is(DOCUMENT_ID, QueryCondition.Op.LESS_OR_EQUAL, 400).close().build();
        scanRanges = hashedIndexMetaTable.getScanRanges((QueryCondition)conditionOnAdjecentTabletBoundries, 32);
        this.assertScanRangesSize(16, scanRanges);
        int docCount = 0;
        for (ScanRange scanRange : scanRanges) {
            ConditionImpl findCondition = MapRDBImpl.newCondition().and().condition(scanRange.getCondition()).condition((QueryCondition)conditionOnAdjecentTabletBoundries).close().build();
            DocumentStream stream = hashedIndexTable.find((QueryCondition)findCondition, new FieldPath[]{DocumentConstants.ID_FIELD, DOCUMENT_ID});
            for (Document document : stream) {
                ++docCount;
                Assert.assertTrue((document.getInt(DOCUMENT_ID) >= 200 ? 1 : 0) != 0);
                Assert.assertTrue((document.getInt(DOCUMENT_ID) <= 400 ? 1 : 0) != 0);
            }
        }
        Assert.assertEquals((long)4020L, (long)docCount);
        ConditionImpl conditionOnNonIndexedField = MapRDBImpl.newCondition().and().is(ABC_FIELD, QueryCondition.Op.GREATER_OR_EQUAL, "L").is(ABC_FIELD, QueryCondition.Op.LESS_OR_EQUAL, "M").close().build();
        scanRanges = hashedIndexMetaTable.getScanRanges((QueryCondition)conditionOnNonIndexedField, 32);
        this.assertScanRangesSize(8, scanRanges);
        docCount = 0;
        for (ScanRange scanRange : scanRanges) {
            ConditionImpl findCondition = MapRDBImpl.newCondition().and().condition(scanRange.getCondition()).condition((QueryCondition)conditionOnNonIndexedField).close().build();
            DocumentStream stream = regularIndexTable.find((QueryCondition)findCondition, new FieldPath[]{DocumentConstants.ID_FIELD, ABC_FIELD});
            for (Document document : stream) {
                ++docCount;
                Assert.assertTrue((document.getString(ABC_FIELD).compareTo("L") >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((document.getString(ABC_FIELD).compareTo("M") <= 0 ? 1 : 0) != 0);
            }
        }
        Assert.assertEquals((long)500L, (long)docCount);
    }
}

