/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.ojai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.Validators;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.io.IOException;
import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.ojai.Document;
import org.ojai.FieldPath;
import org.ojai.Value;
import org.ojai.json.Json;
import org.ojai.types.ODate;
import org.ojai.types.OInterval;
import org.ojai.types.OTime;
import org.ojai.types.OTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SimpleTest.class})
public class TestDBDocument
extends BaseTest {
    private static final Logger _logger = LoggerFactory.getLogger(TestDBDocument.class);
    private static final FieldPath FIELD_MAP_ARRAY = FieldPath.parseFrom((String)"map.array");
    private static final FieldPath FIELD_MAP_BINARY = FieldPath.parseFrom((String)"map.binary");
    private static final FieldPath FIELD_MAP_TIMESTAMP = FieldPath.parseFrom((String)"map.timestamp");
    private static final FieldPath FIELD_MAP_TIME = FieldPath.parseFrom((String)"map.time");
    private static final FieldPath FIELD_MAP_DATE = FieldPath.parseFrom((String)"map.date");
    private static final FieldPath FIELD_MAP_DOUBLE = FieldPath.parseFrom((String)"map.double");
    private static final FieldPath FIELD_MAP_FLOAT = FieldPath.parseFrom((String)"map.float");
    private static final FieldPath FIELD_MAP_LONG = FieldPath.parseFrom((String)"map.long");
    private static final FieldPath FIELD_MAP_INT = FieldPath.parseFrom((String)"map.int");
    private static final FieldPath FIELD_MAP_SHORT = FieldPath.parseFrom((String)"map.short");
    private static final FieldPath FIELD_MAP_BYTE = FieldPath.parseFrom((String)"map.byte");
    private static final FieldPath FIELD_MAP_STRING = FieldPath.parseFrom((String)"map.string");
    private static final FieldPath FIELD_MAP_BOOLEAN = FieldPath.parseFrom((String)"map.boolean");
    public static final Document docWithAllTypes1 = MapRDBImpl.newDocument().setNull("map.null").set(FIELD_MAP_BOOLEAN, false).set(FIELD_MAP_STRING, "eureka").set(FIELD_MAP_BYTE, (byte)127).set(FIELD_MAP_SHORT, (short)Short.MAX_VALUE).set(FIELD_MAP_INT, Integer.MAX_VALUE).set(FIELD_MAP_LONG, Long.MAX_VALUE).set(FIELD_MAP_FLOAT, Float.MAX_VALUE).set(FIELD_MAP_DOUBLE, Double.MAX_VALUE).set(FIELD_MAP_DATE, ODate.parse((String)"2012-10-20")).set(FIELD_MAP_TIME, OTime.parse((String)"07:42:46.123")).set(FIELD_MAP_TIMESTAMP, OTimestamp.parse((String)"2012-10-20T14:42:46.123Z")).set(FIELD_MAP_BINARY, ByteBuffer.wrap(new byte[]{104, 101, 108, 108, 111})).setArray(FIELD_MAP_ARRAY, new Object[]{42, "open sesame", 3.14, (short)108, ODate.parse((String)"2012-10-20")});
    public static final Document docWithAllTypes2 = MapRDBImpl.newDocument().setNull("map.null").set(FIELD_MAP_BOOLEAN, false).set(FIELD_MAP_STRING, "eureka").set(FIELD_MAP_BYTE, (byte)121).set(FIELD_MAP_SHORT, (short)121).set(FIELD_MAP_INT, 121).set(FIELD_MAP_LONG, 121L).set(FIELD_MAP_FLOAT, 121.625f).set(FIELD_MAP_DOUBLE, 121.625).set(FIELD_MAP_DATE, ODate.parse((String)"2012-10-20")).set(FIELD_MAP_TIME, OTime.parse((String)"07:42:46.123")).set(FIELD_MAP_TIMESTAMP, OTimestamp.parse((String)"2012-10-20T14:42:46.123Z")).set(FIELD_MAP_BINARY, ByteBuffer.wrap(new byte[]{104, 101, 108, 108, 111})).setArray(FIELD_MAP_ARRAY, new Object[]{42, "open sesame", 3.14, (short)108, ODate.parse((String)"2012-10-20")});
    @Rule
    public final ExpectedException exception = ExpectedException.none();
    private static final float DELTA = 0.0f;

    @Test
    public void testAllTypes() {
        int i;
        DBDocumentImpl rec = new DBDocumentImpl();
        rec.set("map.field1", (byte)100);
        rec.set("map.field2", (short)10000);
        rec.set("map.longfield2verylongverylong", 12.345678);
        rec.set("FIELD2", "VERY LONG STRING IS THIS YOU KNOW");
        rec.set("map2.field1", (byte)100);
        rec.set("map2.field2", (short)10000);
        rec.set("map2.longfield2verylongverylong", 12.345678);
        rec.set("FIELD3", "VERY LONG STRING IS THIS YOU KNOW");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", "Anurag");
        map.put("Age", 20);
        rec.set("newmap.map", map);
        StringBuilder buf = new StringBuilder();
        rec.toString(buf);
        _logger.info("Record is {}", (Object)buf);
        rec.set("map.boolean", false);
        rec.set("map.string", "string");
        rec.set("map.byte", (byte)100);
        rec.set("map.short", (short)10000);
        rec.set("map.int", 50000);
        rec.set("map.long", 12345678999L);
        rec.set("map.float", 10.1234f);
        rec.set("map.double", 10.1234567891);
        byte[] bytes = new byte[5];
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            bytes[i2] = (byte)i2;
        }
        rec.set("map.binary1", bytes);
        rec.set("map.binary2", bytes, 1, 3);
        ByteBuffer bbuf = ByteBuffer.allocate(100);
        for (int i3 = 0; i3 < bbuf.capacity(); ++i3) {
            bbuf.put((byte)i3);
        }
        rec.set("map.binary3", bbuf);
        map = new HashMap();
        map.put("Name", "Anurag");
        map.put("Age", 20);
        ArrayList<Integer> scores = new ArrayList<Integer>();
        scores.add(100);
        scores.add(200);
        scores.add(300);
        scores.add(400);
        rec.set("map.map", map);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add("Field1");
        values.add(new Integer(500));
        values.add(new Double(5555.5555));
        rec.set("map.list", values);
        Assert.assertEquals((Object)rec.getValue("map").getType(), (Object)Value.Type.MAP);
        Assert.assertEquals((Object)rec.getBoolean("map.boolean"), (Object)false);
        Assert.assertEquals((Object)rec.getString("map.string"), (Object)"string");
        Assert.assertEquals((long)rec.getByte("map.byte"), (long)100L);
        Assert.assertEquals((long)rec.getShort("map.short"), (long)10000L);
        Assert.assertEquals((long)rec.getInt("map.int"), (long)50000L);
        Assert.assertEquals((long)rec.getLong("map.long"), (long)12345678999L);
        Assert.assertEquals((double)rec.getFloat("map.float"), (double)10.1234f, (double)0.0);
        Assert.assertEquals((double)rec.getDouble("map.double"), (double)10.1234567891, (double)0.0);
        ByteBuffer readBuf = rec.getBinary("map.binary1");
        for (i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)readBuf.get(i), (long)bytes[i]);
        }
        readBuf = rec.getBinary("map.binary2");
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((long)readBuf.get(), (long)bytes[1 + i]);
        }
        readBuf = rec.getBinary("map.binary3");
        for (i = 0; i < bbuf.capacity(); ++i) {
            Assert.assertEquals((long)readBuf.get(i), (long)bbuf.get(i));
        }
        Map m = rec.getValue("map.map").getMap();
        Assert.assertEquals(map, (Object)m);
        List l = rec.getValue("map.list").getList();
        Assert.assertEquals(values, (Object)l);
    }

    @Test
    public void testBug18764() {
        Document r1 = MapRDBImpl.newDocument().set("age", 50).set("name", "joeseph").set("address.zip", 94086).set("address.street", "Washington Ave");
        Assert.assertEquals((Object)true, (Object)r1.equals(r1));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDocumentOpGetArrayNotation() {
        Document doc = MapRDBImpl.newDocument();
        doc.getBoolean("a[]");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDocumentOpSetArrayNotation() {
        Document doc = MapRDBImpl.newDocument();
        doc.set("a[].b", "Arr");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDocumentOpDeleteArrayNotation() {
        Document doc = MapRDBImpl.newDocument();
        doc.delete("a[]");
    }

    @Test
    public void testBooleanArray() {
        Document r1 = MapRDBImpl.newDocument();
        r1.set("map.int", 111);
        boolean[] boolArray = new boolean[]{true, false, true};
        r1.setArray("map.boolarray", boolArray);
        Assert.assertEquals((Object)false, (Object)r1.getBoolean("map.boolarray[1]"));
        Assert.assertEquals((Object)true, (Object)r1.getBoolean("map.boolarray[2]"));
    }

    @Test
    public void arrayTest() throws Exception {
        Document r = MapRDBImpl.newDocument();
        r.setArray("Double_array", new double[]{10.1, 20.2, 30.3});
        Assert.assertEquals((double)10.1, (double)r.getDouble("Double_array[0]"), (double)0.0);
    }

    @Test
    public void testEquals() {
        Document rec = MapRDBImpl.newDocument();
        rec.set("map.field1", (byte)100);
        rec.set("map.field2", (short)10000);
        rec.set("map.string", "eureka");
        rec.set("map.boolean", false);
        rec.set("map.date", ODate.parse((String)"2013-02-12"));
        OTime time = OTime.parse((String)"07:42:46");
        rec.set("map.time", time);
        OTimestamp timeStamp = OTimestamp.parse((String)"2012-10-20T07:42:46");
        rec.set("map.timestamp", timeStamp);
        rec.set("map.int", 12345678);
        byte[] byteArray = "abracadabra".getBytes();
        rec.set("map.bytearray", byteArray);
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("a", 500);
        m.put("b", "abcd");
        ArrayList<Object> newlist = new ArrayList<Object>();
        newlist.add("aaaaa");
        newlist.add(1234567.89);
        m.put("c", newlist);
        rec.set("map2", m);
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(12345.678901);
        l.add("abracadabra");
        HashMap<String, Constable> m2 = new HashMap<String, Constable>();
        m2.put("a1", Integer.valueOf(111));
        m2.put("b1", Boolean.valueOf(false));
        l.add(m2);
        rec.set("list1", l);
        Document rec2 = rec;
        Assert.assertEquals((Object)true, (Object)rec2.equals(rec));
        Value stringValue = rec.getValue("map.string");
        Assert.assertEquals((Object)true, (Object)stringValue.equals("eureka"));
        byte b = rec.getByte("map.field1");
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.field1").equals(b));
        Byte bite = new Byte(b);
        Assert.assertEquals((Object)true, (Object)bite.equals(rec.getByte("map.field1")));
        short s = rec.getShort("map.field2");
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.field2").equals(s));
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.field2").equals(DBValueBuilderImpl.KeyValueBuilder.initFrom(s)));
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.boolean").equals(false));
        Assert.assertEquals((Object)ODate.parse((String)"2013-02-12"), (Object)rec.getDate("map.date"));
        Assert.assertEquals((Object)true, (Object)rec.getValue("map2").equals(m));
        int x = rec.getInt("map.int");
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.int").equals(x));
        Assert.assertEquals((Object)true, (Object)rec.getList("list1").equals(l));
        Assert.assertEquals((Object)time, (Object)rec.getTime("map.time"));
        Assert.assertEquals((Object)timeStamp, (Object)rec.getTimestamp("map.timestamp"));
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.bytearray").equals(ByteBuffer.wrap(byteArray)));
        Value myValue = rec.getValue("map.date");
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.date").equals(myValue));
        myValue = rec.getValue("map.time");
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.time").equals(myValue));
        myValue = rec.getValue("map.timestamp");
        Assert.assertEquals((Object)true, (Object)rec.getValue("map.timestamp").equals(myValue));
        myValue = rec.getValue("list1");
        Assert.assertEquals((Object)true, (Object)rec.getValue("list1").equals(myValue));
        myValue = rec.getValue("map2");
        Assert.assertEquals((Object)true, (Object)rec.getValue("map2").equals(myValue));
    }

    @Test
    public void testSelfEquals() {
        Document doc = MapRDBImpl.newDocument().set("emptymap", new HashMap());
        _logger.info(doc.toString());
        Assert.assertTrue((boolean)doc.equals(doc));
    }

    @Test
    public void testDocumentEqualsWithJson() throws IOException {
        String fieldPath = "`a|b`.`c,''-\\\"d`.` a!\\`#$%&'()*+,-/:;<=>?@`.`[]^_{|}~`";
        FieldPath fp = FieldPath.parseFrom((String)fieldPath);
        Document d1 = MapRDBImpl.newDocument();
        d1.set(fp, 10);
        d1.set("list", (List)ImmutableList.of((Object)1, (Object)"abc", (Object)99.0));
        d1.set("map", (Map)ImmutableMap.of((Object)"k1", (Object)"abc", (Object)"k2", (Object)99.0));
        Document d2 = Json.newDocument();
        d2.set(fp, 10);
        d2.set("list", (List)ImmutableList.of((Object)1, (Object)"abc", (Object)99.0));
        d2.set("map", (Map)ImmutableMap.of((Object)"k1", (Object)"abc", (Object)"k2", (Object)99.0));
        Assert.assertEquals((Object)d1, (Object)d2);
    }

    @Test
    public void testBug18884() {
        Document r1 = MapRDBImpl.newDocument().set("string", "asdasd").set("ts", new OTimestamp(100000L));
        Document r2 = MapRDBImpl.newDocument().set("string", "asdasd").set("ts", new OTimestamp(100000L));
        Assert.assertEquals((Object)true, (Object)r1.getValue("ts").equals(r2.getValue("ts")));
        Document doc1 = Json.newDocument();
        doc1.set("abcd", "efg");
        Document doc2 = MapRDBImpl.newDocument();
        doc2.set("abcd", "efg");
        Assert.assertEquals((Object)doc1, (Object)doc2);
        Assert.assertEquals((Object)doc2, (Object)doc1);
        doc1.set("arr[0]", "a");
        doc1.set("arr[1]", "b");
        doc2.set("arr[0]", "a");
        doc2.set("arr[1]", "b");
        Assert.assertEquals((Object)true, (Object)doc1.equals(doc2));
        Assert.assertEquals((Object)true, (Object)doc2.equals(doc1));
    }

    @Test
    public void testStaticEqualsMethod() {
        DBDocumentImpl d1 = (DBDocumentImpl)MapRDBImpl.newDocument();
        DBDocumentImpl d2 = (DBDocumentImpl)MapRDBImpl.newDocument();
        d2.set("a", "eureka").set("b", 123);
        Assert.assertFalse((boolean)DBDocumentImpl.equals((KeyValue)d1, (KeyValue)d2, (boolean)false, (boolean)false, null, null));
    }

    @Test
    public void testNull() {
        Document r1 = MapRDBImpl.newDocument().setNull("a");
        Document r2 = MapRDBImpl.newDocument().setNull("a");
        Assert.assertEquals((Object)true, (Object)r1.equals(r2));
    }

    @Test
    public void testBigDecimalIntervalDisabled() {
        Document doc = MapRDBImpl.newDocument();
        doc.set("val1", "xyz");
        this.exception.expect(UnsupportedOperationException.class);
        doc.set("val2", new BigDecimal(1.223344));
        doc.set("val3", false);
        doc.set("val4", new OInterval(10000L));
    }

    @Test
    public void testNumericInterchange() {
        Assert.assertEquals((long)127L, (long)docWithAllTypes1.getByte(FIELD_MAP_BYTE));
        Assert.assertEquals((long)-1L, (long)docWithAllTypes1.getByte(FIELD_MAP_SHORT));
        Assert.assertEquals((long)-1L, (long)docWithAllTypes1.getByte(FIELD_MAP_INT));
        Assert.assertEquals((long)-1L, (long)docWithAllTypes1.getByte(FIELD_MAP_LONG));
        Assert.assertEquals((long)-1L, (long)docWithAllTypes1.getByte(FIELD_MAP_FLOAT));
        Assert.assertEquals((long)-1L, (long)docWithAllTypes1.getByte(FIELD_MAP_DOUBLE));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getByte(FIELD_MAP_BYTE));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getByte(FIELD_MAP_SHORT));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getByte(FIELD_MAP_INT));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getByte(FIELD_MAP_LONG));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getByte(FIELD_MAP_FLOAT));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getByte(FIELD_MAP_DOUBLE));
        Assert.assertEquals((long)127L, (long)docWithAllTypes1.getShort(FIELD_MAP_BYTE));
        Assert.assertEquals((long)32767L, (long)docWithAllTypes1.getShort(FIELD_MAP_SHORT));
        Assert.assertEquals((long)-1L, (long)docWithAllTypes1.getShort(FIELD_MAP_INT));
        Assert.assertEquals((long)-1L, (long)docWithAllTypes1.getShort(FIELD_MAP_LONG));
        Assert.assertEquals((long)-1L, (long)docWithAllTypes1.getShort(FIELD_MAP_FLOAT));
        Assert.assertEquals((long)-1L, (long)docWithAllTypes1.getShort(FIELD_MAP_DOUBLE));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getShort(FIELD_MAP_BYTE));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getShort(FIELD_MAP_SHORT));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getShort(FIELD_MAP_INT));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getShort(FIELD_MAP_LONG));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getShort(FIELD_MAP_FLOAT));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getShort(FIELD_MAP_DOUBLE));
        Assert.assertEquals((long)127L, (long)docWithAllTypes1.getInt(FIELD_MAP_BYTE));
        Assert.assertEquals((long)32767L, (long)docWithAllTypes1.getInt(FIELD_MAP_SHORT));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)docWithAllTypes1.getInt(FIELD_MAP_INT));
        Assert.assertEquals((long)-1L, (long)docWithAllTypes1.getInt(FIELD_MAP_LONG));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)docWithAllTypes1.getInt(FIELD_MAP_FLOAT));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)docWithAllTypes1.getInt(FIELD_MAP_DOUBLE));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getInt(FIELD_MAP_BYTE));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getInt(FIELD_MAP_SHORT));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getInt(FIELD_MAP_INT));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getInt(FIELD_MAP_LONG));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getInt(FIELD_MAP_FLOAT));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getInt(FIELD_MAP_DOUBLE));
        Assert.assertEquals((long)127L, (long)docWithAllTypes1.getLong(FIELD_MAP_BYTE));
        Assert.assertEquals((long)32767L, (long)docWithAllTypes1.getLong(FIELD_MAP_SHORT));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)docWithAllTypes1.getLong(FIELD_MAP_INT));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)docWithAllTypes1.getLong(FIELD_MAP_LONG));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)docWithAllTypes1.getLong(FIELD_MAP_FLOAT));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)docWithAllTypes1.getLong(FIELD_MAP_DOUBLE));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getLong(FIELD_MAP_BYTE));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getLong(FIELD_MAP_SHORT));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getLong(FIELD_MAP_INT));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getLong(FIELD_MAP_LONG));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getLong(FIELD_MAP_FLOAT));
        Assert.assertEquals((long)121L, (long)docWithAllTypes2.getLong(FIELD_MAP_DOUBLE));
        Assert.assertEquals((float)127.0f, (float)docWithAllTypes1.getFloat(FIELD_MAP_BYTE), (float)0.0f);
        Assert.assertEquals((float)32767.0f, (float)docWithAllTypes1.getFloat(FIELD_MAP_SHORT), (float)0.0f);
        Assert.assertEquals((float)2.1474836E9f, (float)docWithAllTypes1.getFloat(FIELD_MAP_INT), (float)0.0f);
        Assert.assertEquals((float)9.223372E18f, (float)docWithAllTypes1.getFloat(FIELD_MAP_LONG), (float)0.0f);
        Assert.assertEquals((float)Float.MAX_VALUE, (float)docWithAllTypes1.getFloat(FIELD_MAP_FLOAT), (float)0.0f);
        Assert.assertEquals((float)Float.POSITIVE_INFINITY, (float)docWithAllTypes1.getFloat(FIELD_MAP_DOUBLE), (float)0.0f);
        Assert.assertEquals((float)121.0f, (float)docWithAllTypes2.getFloat(FIELD_MAP_BYTE), (float)0.0f);
        Assert.assertEquals((float)121.0f, (float)docWithAllTypes2.getFloat(FIELD_MAP_SHORT), (float)0.0f);
        Assert.assertEquals((float)121.0f, (float)docWithAllTypes2.getFloat(FIELD_MAP_INT), (float)0.0f);
        Assert.assertEquals((float)121.0f, (float)docWithAllTypes2.getFloat(FIELD_MAP_LONG), (float)0.0f);
        Assert.assertEquals((double)121.625, (double)docWithAllTypes2.getFloat(FIELD_MAP_FLOAT), (double)0.0);
        Assert.assertEquals((double)121.625, (double)docWithAllTypes2.getFloat(FIELD_MAP_DOUBLE), (double)0.0);
        Assert.assertEquals((double)127.0, (double)docWithAllTypes1.getDouble(FIELD_MAP_BYTE), (double)0.0);
        Assert.assertEquals((double)32767.0, (double)docWithAllTypes1.getDouble(FIELD_MAP_SHORT), (double)0.0);
        Assert.assertEquals((double)2.147483647E9, (double)docWithAllTypes1.getDouble(FIELD_MAP_INT), (double)0.0);
        Assert.assertEquals((double)9.223372036854776E18, (double)docWithAllTypes1.getDouble(FIELD_MAP_LONG), (double)0.0);
        Assert.assertEquals((double)3.4028234663852886E38, (double)docWithAllTypes1.getDouble(FIELD_MAP_FLOAT), (double)0.0);
        Assert.assertEquals((double)Double.MAX_VALUE, (double)docWithAllTypes1.getDouble(FIELD_MAP_DOUBLE), (double)0.0);
        Assert.assertEquals((double)121.0, (double)docWithAllTypes2.getDouble(FIELD_MAP_BYTE), (double)0.0);
        Assert.assertEquals((double)121.0, (double)docWithAllTypes2.getDouble(FIELD_MAP_SHORT), (double)0.0);
        Assert.assertEquals((double)121.0, (double)docWithAllTypes2.getDouble(FIELD_MAP_INT), (double)0.0);
        Assert.assertEquals((double)121.0, (double)docWithAllTypes2.getDouble(FIELD_MAP_LONG), (double)0.0);
        Assert.assertEquals((double)121.625, (double)docWithAllTypes2.getDouble(FIELD_MAP_FLOAT), (double)0.0);
        Assert.assertEquals((double)121.625, (double)docWithAllTypes2.getDouble(FIELD_MAP_DOUBLE), (double)0.0);
        Assert.assertEquals((Object)new BigDecimal(127), (Object)docWithAllTypes1.getDecimal(FIELD_MAP_BYTE));
        Assert.assertEquals((Object)new BigDecimal(Short.MAX_VALUE), (Object)docWithAllTypes1.getDecimal(FIELD_MAP_SHORT));
        Assert.assertEquals((Object)new BigDecimal(Integer.MAX_VALUE), (Object)docWithAllTypes1.getDecimal(FIELD_MAP_INT));
        Assert.assertEquals((Object)new BigDecimal(Long.MAX_VALUE), (Object)docWithAllTypes1.getDecimal(FIELD_MAP_LONG));
        Assert.assertEquals((Object)new BigDecimal(3.4028234663852886E38), (Object)docWithAllTypes1.getDecimal(FIELD_MAP_FLOAT));
        Assert.assertEquals((Object)new BigDecimal(Double.MAX_VALUE), (Object)docWithAllTypes1.getDecimal(FIELD_MAP_DOUBLE));
        Assert.assertEquals((Object)new BigDecimal(121), (Object)docWithAllTypes2.getDecimal(FIELD_MAP_BYTE));
        Assert.assertEquals((Object)new BigDecimal(121), (Object)docWithAllTypes2.getDecimal(FIELD_MAP_SHORT));
        Assert.assertEquals((Object)new BigDecimal(121), (Object)docWithAllTypes2.getDecimal(FIELD_MAP_INT));
        Assert.assertEquals((Object)new BigDecimal(121), (Object)docWithAllTypes2.getDecimal(FIELD_MAP_LONG));
        Assert.assertEquals((Object)new BigDecimal(121.625), (Object)docWithAllTypes2.getDecimal(FIELD_MAP_FLOAT));
        Assert.assertEquals((Object)new BigDecimal(121.625), (Object)docWithAllTypes2.getDecimal(FIELD_MAP_DOUBLE));
    }

    @Test
    public void testGetValuesAtAPIForOpenArrays() throws Exception {
        DBDocumentImpl d1 = (DBDocumentImpl)MapRDBImpl.newDocument().set("a.b", "ab1").set("b.c.d", "bcd").setArray("x", new Object[]{MapRDBImpl.newDocument().set("y", "xy0").set("w", "xw0"), MapRDBImpl.newDocument().set("y", "xy1").set("z", "xz1")});
        FieldPath fp1 = FieldPath.parseFrom((String)"a");
        FieldPath fp2 = FieldPath.parseFrom((String)"a.b");
        FieldPath fp3 = FieldPath.parseFrom((String)"b.c");
        FieldPath fp4 = FieldPath.parseFrom((String)"x[1].y");
        FieldPath fp5 = FieldPath.parseFrom((String)"x[0].z");
        FieldPath fp6 = FieldPath.parseFrom((String)"x[1].w");
        FieldPath fp7 = FieldPath.parseFrom((String)"a[].b");
        FieldPath fp8 = FieldPath.parseFrom((String)"x[].y");
        FieldPath fp9 = FieldPath.parseFrom((String)"x[].y[]");
        FieldPath fp10 = FieldPath.parseFrom((String)"x[][].z[]");
        Set values = d1.getUniqueValues(fp1);
        Assert.assertEquals((Object)d1.getValue(fp1.toString()), (Object)values.toArray(new KeyValue[values.size()])[0]);
        Assert.assertEquals((long)1L, (long)values.size());
        values = d1.getUniqueValues(fp2);
        Assert.assertEquals((Object)d1.getValue(fp2.toString()), (Object)values.toArray(new KeyValue[values.size()])[0]);
        Assert.assertEquals((long)1L, (long)values.size());
        values = d1.getUniqueValues(fp3);
        Assert.assertEquals((Object)d1.getValue(fp3.toString()), (Object)values.toArray(new KeyValue[values.size()])[0]);
        Assert.assertEquals((long)1L, (long)values.size());
        values = d1.getUniqueValues(fp4);
        Assert.assertEquals((Object)d1.getValue(fp4.toString()), (Object)values.toArray(new KeyValue[values.size()])[0]);
        Assert.assertEquals((long)1L, (long)values.size());
        Assert.assertNull((Object)d1.getUniqueValues(fp5));
        Assert.assertNull((Object)d1.getUniqueValues(fp6));
        values = d1.getUniqueValues(fp7);
        Assert.assertEquals((Object)d1.getValue("a.b"), (Object)values.toArray(new KeyValue[values.size()])[0]);
        Assert.assertEquals((long)1L, (long)values.size());
        values = d1.getUniqueValues(fp8);
        assert (values.contains(d1.getValue("x[0].y")));
        assert (values.contains(d1.getValue("x[1].y")));
        Assert.assertEquals((long)2L, (long)values.size());
        values = d1.getUniqueValues(fp9);
        assert (values.contains(d1.getValue("x[0].y")));
        assert (values.contains(d1.getValue("x[1].y")));
        Assert.assertEquals((long)2L, (long)values.size());
        values = d1.getUniqueValues(fp10);
        Assert.assertEquals((Object)d1.getValue("x[1].z"), (Object)"xz1");
        Assert.assertEquals((long)1L, (long)values.size());
    }

    @Test
    public void testGetValuesAtAPIForOpenArrays_MAPRDB_1555() throws Exception {
        DBDocumentImpl doc = (DBDocumentImpl)MapRDBImpl.newDocument();
        doc.setArray("abc", new Object[]{new Object[]{1, 2, 3}, new Object[]{4, 5, 6}});
        Set values = doc.getUniqueValues(FieldPath.parseFrom((String)"abc[][]"));
        Assert.assertEquals((long)6L, (long)values.size());
    }

    @Test
    public void testDBDocumentImpl_checkForArrayNotation_MAPRDB_1555() throws Exception {
        try {
            Validators.checkForArrayNotation((FieldPath)FieldPath.parseFrom((String)"a[].b"));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            _logger.trace("Received " + e.getMessage() + " as expected");
        }
        try {
            Validators.checkForArrayNotation((FieldPath)FieldPath.parseFrom((String)"`a[]`.b"));
        }
        catch (IllegalArgumentException e) {
            Assert.fail();
        }
    }
}

