/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.tests.ojai;

import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBValueBuilderImpl;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.ojai.Document;
import org.ojai.DocumentBuilder;
import org.ojai.json.Json;
import org.ojai.store.DocumentMutation;

@Category(value={SimpleTest.class})
public class TestMapRDBNoClusterEmptyKeys
extends BaseTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testEmptyKeyWithDelete() throws Exception {
        DocumentMutation m = MapRDBImpl.newMutation();
        m.increment("a.b.c", 1);
        this.thrown.expect(IllegalArgumentException.class);
        m.delete("");
    }

    @Test
    public void testJSONToDBDocumentWithEmptyKeys() {
        Document d = Json.newDocument();
        d.set("a.b.c", "mapr");
        d.set("k", Json.newDocument().set("", false).set("x", 123));
        Assert.assertEquals((Object)"mapr", (Object)d.getString("a.b.c"));
        this.thrown.expect(IllegalArgumentException.class);
        DBDocumentImpl dbDoc = (DBDocumentImpl)DBValueBuilderImpl.KeyValueBuilder.initFrom(d);
    }

    @Test
    public void testJSONMapToDBDocumentWithEmptyKeys() {
        Document d = Json.newDocument();
        d.set("a.b.c", "mapr");
        d.set("k", Json.newDocument().set("", false).set("x", 123));
        Assert.assertEquals((Object)"mapr", (Object)d.getString("a.b.c"));
        this.thrown.expect(IllegalArgumentException.class);
        DBDocumentImpl dbDoc = (DBDocumentImpl)DBValueBuilderImpl.KeyValueBuilder.initFrom(d.asMap());
    }

    @Test
    public void testFieldPathWithEmptyStringAtEnd() {
        Document doc = MapRDBImpl.newDocument();
        this.thrown.expect(IllegalArgumentException.class);
        doc.set("a.b.``", "eureka");
    }

    @Test
    public void testFieldPathWithEmptyStringInMiddle() {
        Document doc = MapRDBImpl.newDocument();
        this.thrown.expect(IllegalArgumentException.class);
        doc.set("a.``.b", "eureka");
    }

    @Test
    public void testDBDocumentBuilderWithEmptyKeys() {
        DocumentBuilder builder = MapRDBImpl.newDocumentBuilder();
        builder.addNewMap();
        this.thrown.expect(IllegalArgumentException.class);
        builder.put("", 123);
        builder.endMap();
    }

    @Test
    public void testDBDocumentBuilderWithMapAndEmptyKeys() {
        DocumentBuilder builder = MapRDBImpl.newDocumentBuilder();
        builder.addNewMap();
        this.thrown.expect(IllegalArgumentException.class);
        Document d = Json.newDocument().set("x", true).set("a.``", 127);
        builder.put("map", d.asMap());
    }

    @Test
    public void testDocBuilderWithDocEmptyKeys() {
        DocumentBuilder builder = MapRDBImpl.newDocumentBuilder();
        builder.addNewMap();
        Document d = Json.newDocument().set("x", true).set("a.``", 127);
        this.thrown.expect(IllegalArgumentException.class);
        builder.put("map", d);
    }
}

