/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.rowcol;

import com.mapr.db.rowcol.ArrayIndexDescriptor;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.db.rowcol.DBList;
import com.mapr.db.rowcol.KeyValue;
import com.mapr.db.rowcol.TimeAndUniq;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.Checksum;
import org.ojai.Value;
import org.ojai.annotation.API;
import org.ojai.util.Values;

public class KeyValueWithTS
extends KeyValue {
    TimeAndUniq[] times;
    TimeAndUniq arrayIndex;
    byte[] arrayIndexUniq;

    public KeyValueWithTS() {
    }

    public KeyValueWithTS(Value.Type type) {
        super(type);
    }

    @Override
    public String toStringWithTimestamp() {
        return Values.asJsonString((Value)this);
    }

    public static boolean equals(KeyValue kv1, KeyValue kv2, boolean matchTime, boolean keepOnlyMismatch, TimeAndUniq parentDelTime1, TimeAndUniq parentDelTime2) {
        KeyValue child2;
        KeyValue child1;
        TimeAndUniq delTime1 = null;
        TimeAndUniq delTime2 = null;
        boolean matched = true;
        if (kv1 == null && kv2 == null) {
            return true;
        }
        if (kv1 == null || kv2 == null) {
            return false;
        }
        if (kv1.type_ != kv2.type_) {
            return false;
        }
        if (kv1 instanceof DBDocumentImpl) {
            DBDocumentImpl doc1 = (DBDocumentImpl)kv1;
            DBDocumentImpl doc2 = (DBDocumentImpl)kv2;
            doc1.setMapOnDemand();
            doc2.setMapOnDemand();
        }
        assert (kv1.isRoot() == kv2.isRoot());
        if (matchTime) {
            KeyValueWithTS kvTS1 = (KeyValueWithTS)kv1;
            KeyValueWithTS kvTS2 = (KeyValueWithTS)kv2;
            for (int i = 0; i < 2; ++i) {
                TimeAndUniq t1 = kvTS1.times[i];
                TimeAndUniq t2 = kvTS2.times[i];
                if (TimeAndUniq.equals(t1, t2)) continue;
                matched = false;
            }
            delTime1 = kvTS1.times[2];
            delTime2 = kvTS2.times[2];
            if (parentDelTime1 != null && TimeAndUniq.cmp(parentDelTime1, delTime1) >= 0) {
                delTime1 = parentDelTime1;
            }
            if (parentDelTime2 != null && TimeAndUniq.cmp(parentDelTime2, delTime2) >= 0) {
                delTime2 = parentDelTime2;
            }
            if (!TimeAndUniq.equals(delTime1, delTime2)) {
                matched = false;
            }
        }
        assert (kv1.isArrayElement() == kv2.isArrayElement());
        Value.Type type = kv1.getType();
        if (type == Value.Type.MAP) {
            LinkedHashMap<String, KeyValue> map1 = ((DBDocumentImpl)kv1).map;
            LinkedHashMap<String, KeyValue> map2 = ((DBDocumentImpl)kv2).map;
            child1 = null;
            child2 = null;
            String key1 = null;
            String key2 = null;
            Iterator iter1 = map1.entrySet().iterator();
            Iterator iter2 = map2.entrySet().iterator();
            while (iter1.hasNext() || iter2.hasNext()) {
                if (child1 == null && iter1.hasNext()) {
                    Map.Entry e1 = iter1.next();
                    child1 = (KeyValue)e1.getValue();
                    key1 = (String)e1.getKey();
                }
                if (child2 == null && iter2.hasNext()) {
                    Map.Entry e2 = iter2.next();
                    child2 = (KeyValue)e2.getValue();
                    key2 = (String)e2.getKey();
                }
                if (!Objects.equals(key1, key2)) {
                    return false;
                }
                assert (child1 != null || child2 != null);
                if (child1 == null || child2 == null) {
                    return false;
                }
                boolean childMatched = KeyValueWithTS.equals(child1, child2, matchTime, keepOnlyMismatch, delTime1, delTime2);
                if (childMatched && keepOnlyMismatch) {
                    iter1.remove();
                    iter2.remove();
                }
                if (!childMatched) {
                    matched = false;
                }
                child2 = null;
                child1 = null;
                key2 = null;
                key1 = null;
            }
            return matched;
        }
        if (type == Value.Type.ARRAY) {
            List<KeyValue> list1 = ((DBList)kv1).list;
            List<KeyValue> list2 = ((DBList)kv2).list;
            child1 = null;
            child2 = null;
            Iterator<KeyValue> iter1 = list1.iterator();
            Iterator<KeyValue> iter2 = list2.iterator();
            while (iter1.hasNext() || iter2.hasNext()) {
                if (child1 == null && iter1.hasNext()) {
                    child1 = iter1.next();
                }
                if (child2 == null && iter2.hasNext()) {
                    child2 = iter2.next();
                }
                assert (child1 != null || child2 != null);
                if (child1 == null || child2 == null) {
                    return false;
                }
                TimeAndUniq index1 = ((KeyValueWithTS)child1).arrayIndex;
                byte[] index1Uniq = ((KeyValueWithTS)child1).arrayIndexUniq;
                TimeAndUniq index2 = ((KeyValueWithTS)child2).arrayIndex;
                byte[] index2Uniq = ((KeyValueWithTS)child2).arrayIndexUniq;
                int cmp = ArrayIndexDescriptor.compareIndexTimeAndUniq(index1, index1Uniq, index2, index2Uniq);
                if (cmp == 0) {
                    boolean childMatched = KeyValueWithTS.equals(child1, child2, matchTime, keepOnlyMismatch, delTime1, delTime2);
                    if (childMatched && keepOnlyMismatch) {
                        iter1.remove();
                        iter2.remove();
                    }
                    if (!childMatched) {
                        matched = false;
                    }
                    child2 = null;
                    child1 = null;
                    continue;
                }
                if (cmp < 0) {
                    matched = false;
                    child1 = null;
                    continue;
                }
                matched = false;
                child2 = null;
            }
            return matched;
        }
        return kv1.equals(kv2);
    }

    /*
     * WARNING - void declaration
     */
    @API.Internal
    public static void updateChecksumKeyValue(Checksum checksum, KeyValue kv, boolean includeTime, TimeAndUniq parentDelTime) {
        if (kv == null) {
            return;
        }
        if (kv instanceof DBDocumentImpl) {
            DBDocumentImpl doc = (DBDocumentImpl)kv;
            doc.setMapOnDemand();
        }
        if (kv.isRoot()) {
            checksum.update(1);
        } else {
            checksum.update(2);
        }
        TimeAndUniq delTime = null;
        if (includeTime) {
            void var7_8;
            KeyValueWithTS kvTS = (KeyValueWithTS)kv;
            TimeAndUniq[] tau = kvTS.times;
            boolean bl = false;
            while (var7_8 < 2) {
                TimeAndUniq t = tau[var7_8];
                byte[] byArray = ByteBuffer.allocate(64).putLong(t.time()).array();
                checksum.update(byArray, 0, 64);
                checksum.update(t.uniq());
                ++var7_8;
            }
            delTime = tau[2];
            if (parentDelTime != null && TimeAndUniq.cmp(parentDelTime, delTime) >= 0) {
                delTime = parentDelTime;
            }
            byte[] byArray = ByteBuffer.allocate(64).putLong(delTime.time()).array();
            checksum.update(byArray, 0, 64);
            checksum.update(delTime.uniq());
        }
        Value.Type type = kv.getType();
        checksum.update(type.ordinal());
        if (type == Value.Type.MAP) {
            checksum.update(5);
            LinkedHashMap<String, KeyValue> map = ((DBDocumentImpl)kv).map;
            Object var7_10 = null;
            for (Map.Entry entry : map.entrySet()) {
                KeyValueWithTS keyValueWithTS = (KeyValueWithTS)entry.getValue();
                assert (keyValueWithTS != null);
                String sk = (String)entry.getKey();
                checksum.update(sk.length());
                checksum.update(sk.getBytes(), 0, sk.length());
                KeyValueWithTS.updateChecksumKeyValue(checksum, keyValueWithTS, includeTime, delTime);
            }
            checksum.update(6);
        }
        if (type == Value.Type.ARRAY) {
            checksum.update(7);
            List<KeyValue> list = ((DBList)kv).list;
            Object var7_14 = null;
            for (KeyValueWithTS keyValueWithTS : list) {
                assert (keyValueWithTS != null);
                TimeAndUniq timeAndUniq = keyValueWithTS.arrayIndex;
                byte[] indexUniq = keyValueWithTS.arrayIndexUniq;
                KeyValueWithTS.updateChecksumIndexTimeAndUniq(checksum, timeAndUniq, indexUniq);
                KeyValueWithTS.updateChecksumKeyValue(checksum, keyValueWithTS, includeTime, delTime);
            }
            checksum.update(8);
        }
        KeyValueWithTS.updateChecksumPrimaryType(checksum, kv);
    }

    private static void updateChecksumIndexTimeAndUniq(Checksum checksum, TimeAndUniq tau, byte[] uniq) {
        byte[] tsbytes = ByteBuffer.allocate(64).putLong(tau.time()).array();
        checksum.update(tsbytes, 0, 64);
        checksum.update(tau.uniq());
        if (uniq != null) {
            checksum.update(uniq, 0, uniq.length);
        }
    }

    public static void updateChecksumPrimaryType(Checksum checksum, KeyValue kv) {
        if (kv == null) {
            return;
        }
        Value.Type type = kv.getType();
        checksum.update(type.ordinal());
        switch (type) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: 
            case TIMESTAMP: 
            case TIME: 
            case INTERVAL: {
                byte[] pvbytes = ByteBuffer.allocate(64).putLong(kv.primValue).array();
                checksum.update(64);
                checksum.update(pvbytes, 0, 64);
                return;
            }
            case NULL: {
                checksum.update(32);
                checksum.update(9);
                return;
            }
            case BINARY: {
                ByteBuffer bf = ((ByteBuffer)kv.objValue).duplicate();
                checksum.update(bf.limit());
                checksum.update(bf.array(), 0, bf.limit());
                return;
            }
            case DECIMAL: {
                BigDecimal bd = kv.getDecimal();
                byte[] usvbytes = bd.unscaledValue().toByteArray();
                checksum.update(usvbytes.length);
                checksum.update(usvbytes, 0, usvbytes.length);
                checksum.update(bd.scale());
                return;
            }
            case STRING: {
                String str = kv.getString();
                checksum.update(str.length());
                checksum.update(str.getBytes(), 0, str.length());
                return;
            }
        }
        assert (false);
    }

    @Override
    public KeyValue shallowCopy() {
        return this.clone();
    }

    @Override
    public KeyValueWithTS clone() {
        return (KeyValueWithTS)super.clone();
    }
}

