/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.indexrowkeyfmt;

import com.mapr.db.indexrowkeyfmt.IndexRowKeyComponent;
import com.mapr.utils.ByteReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.lang.mutable.MutableInt;

public class IntegerComponent
extends IndexRowKeyComponent {
    private byte marker_;
    private byte integerSizeBytes_;

    IntegerComponent(byte type, boolean descendingOrd) {
        super(type, descendingOrd);
        switch (type) {
            case 14: {
                this.marker_ = (byte)(descendingOrd ? -11 : 10);
                this.integerSizeBytes_ = (byte)4;
                break;
            }
            case 12: {
                this.marker_ = (byte)(descendingOrd ? -12 : 11);
                this.integerSizeBytes_ = (byte)4;
                break;
            }
            case 13: {
                this.marker_ = (byte)(descendingOrd ? -13 : 12);
                this.integerSizeBytes_ = (byte)8;
            }
        }
    }

    @Override
    public int getEncodingSizeEstimate() {
        return 1 + this.integerSizeBytes_;
    }

    @Override
    public int calculateEncodingSize(ByteReader buf, int offset) {
        return 1 + this.integerSizeBytes_;
    }

    @Override
    public int getEncodingSize() {
        return 1 + this.integerSizeBytes_;
    }

    @Override
    public byte getMarker(boolean biggest) {
        return this.marker_;
    }

    @Override
    public int encode(ByteBuffer buf) {
        buf.put(this.marker_);
        if (this.integerSizeBytes_ == 4) {
            int value = this.getInt();
            buf.putInt(this.descendingOrder_ ? ~value : (value -= Integer.MIN_VALUE));
        } else {
            long value = this.getLong();
            buf.putLong(this.descendingOrder_ ? value ^ 0xFFFFFFFFFFFFFFFFL : (value -= Long.MIN_VALUE));
        }
        return 1 + this.integerSizeBytes_;
    }

    @Override
    public int decode(ByteReader buf, int offset, int bufSize, MutableInt origTypeIndex) {
        if (buf.getByte(offset) != this.marker_) {
            return -1;
        }
        buf.setOrder(ByteOrder.BIG_ENDIAN);
        if (this.integerSizeBytes_ == 4) {
            int value = buf.getInt(1 + offset);
            if (this.descendingOrder_) {
                value ^= 0xFFFFFFFF;
            }
            this.setInt(value -= Integer.MIN_VALUE);
        } else {
            long value = buf.getLong(1 + offset);
            if (this.descendingOrder_) {
                value ^= 0xFFFFFFFFFFFFFFFFL;
            }
            this.setLong(value += Long.MIN_VALUE);
        }
        this.setOrigType(buf.getByte(origTypeIndex.intValue()));
        origTypeIndex.increment();
        this.setIsDecoded();
        return 1;
    }
}

