/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.orc.InMemoryKeystore;
import org.apache.orc.OrcConf;
import org.apache.orc.OrcProto;
import org.apache.orc.impl.HadoopShimsFactory;
import org.apache.orc.impl.KeyProvider;
import org.apache.orc.impl.StreamName;

public class CryptoUtils {
    private static final int COLUMN_ID_LENGTH = 3;
    private static final int KIND_LENGTH = 2;
    private static final int STRIPE_ID_LENGTH = 3;
    private static final int MIN_COUNT_BYTES = 8;
    static final int MAX_COLUMN = 0xFFFFFF;
    static final int MAX_KIND = 65535;
    static final int MAX_STRIPE = 0xFFFFFF;
    private static final Map<String, KeyProvider> keyProviderCache = new HashMap<String, KeyProvider>();

    public static Consumer<byte[]> modifyIvForStream(StreamName name, long stripeId) {
        return CryptoUtils.modifyIvForStream(name.getColumn(), name.getKind(), stripeId);
    }

    public static Consumer<byte[]> modifyIvForStream(int columnId, OrcProto.Stream.Kind kind, long stripeId) {
        if (columnId < 0 || columnId > 0xFFFFFF) {
            throw new IllegalArgumentException("ORC encryption is limited to 16777215 columns. Value = " + columnId);
        }
        int k = kind.getNumber();
        if (k < 0 || k > 65535) {
            throw new IllegalArgumentException("ORC encryption is limited to 65535 stream kinds. Value = " + k);
        }
        return iv -> {
            if (((byte[])iv).length - 8 < 8) {
                throw new IllegalArgumentException("Not enough space in the iv for the count");
            }
            iv[0] = (byte)(columnId >> 16);
            iv[1] = (byte)(columnId >> 8);
            iv[2] = (byte)columnId;
            iv[3] = (byte)(k >> 8);
            iv[4] = (byte)k;
            CryptoUtils.modifyIvForStripe(stripeId).accept((byte[])iv);
        };
    }

    public static Consumer<byte[]> modifyIvForStripe(long stripeId) {
        if (stripeId < 1L || stripeId > 0xFFFFFFL) {
            throw new IllegalArgumentException("ORC encryption is limited to 16777215 stripes. Value = " + stripeId);
        }
        return iv -> {
            iv[5] = (byte)(stripeId >> 16);
            iv[6] = (byte)(stripeId >> 8);
            iv[7] = (byte)stripeId;
            CryptoUtils.clearCounter(iv);
        };
    }

    public static void clearCounter(byte[] iv) {
        for (int i = 8; i < iv.length; ++i) {
            iv[i] = 0;
        }
    }

    public static KeyProvider getKeyProvider(Configuration conf, Random random) throws IOException {
        String kind = OrcConf.KEY_PROVIDER.getString(conf);
        String cacheKey = kind + "." + random.getClass().getName();
        KeyProvider result = keyProviderCache.get(cacheKey);
        if (result == null) {
            ServiceLoader<KeyProvider.Factory> loader = ServiceLoader.load(KeyProvider.Factory.class);
            for (KeyProvider.Factory factory : loader) {
                result = factory.create(kind, conf, random);
                if (result == null) continue;
                keyProviderCache.put(cacheKey, result);
                break;
            }
        }
        return result;
    }

    public static class HadoopKeyProviderFactory
    implements KeyProvider.Factory {
        @Override
        public KeyProvider create(String kind, Configuration conf, Random random) throws IOException {
            if ("hadoop".equals(kind)) {
                return HadoopShimsFactory.get().getHadoopKeyProvider(conf, random);
            }
            if ("memory".equals(kind)) {
                return new InMemoryKeystore(random);
            }
            return null;
        }
    }
}

