/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.MaskDescriptionImpl;
import org.apache.orc.impl.SchemaEvolution;

public class ParserUtils {
    private static final Pattern INTEGER_PATTERN = Pattern.compile("^[0-9]+$");

    static TypeDescription.Category parseCategory(StringPosition source) {
        StringBuilder word = new StringBuilder();
        boolean hadSpace = true;
        while (source.position < source.length) {
            char ch = source.value.charAt(source.position);
            if (Character.isLetter(ch)) {
                word.append(Character.toLowerCase(ch));
                hadSpace = false;
            } else {
                if (ch != ' ') break;
                if (!hadSpace) {
                    hadSpace = true;
                    word.append(ch);
                }
            }
            ++source.position;
        }
        String catString = word.toString();
        if (hadSpace) {
            catString = catString.trim();
        }
        if (!catString.isEmpty()) {
            for (TypeDescription.Category cat : TypeDescription.Category.values()) {
                if (!cat.getName().equals(catString)) continue;
                return cat;
            }
        }
        throw new IllegalArgumentException("Can't parse category at " + source);
    }

    static int parseInt(StringPosition source) {
        char ch;
        int start = source.position;
        int result = 0;
        while (source.position < source.length && Character.isDigit(ch = source.value.charAt(source.position))) {
            result = result * 10 + (ch - 48);
            ++source.position;
        }
        if (source.position == start) {
            throw new IllegalArgumentException("Missing integer at " + source);
        }
        return result;
    }

    static String parseName(StringPosition source) {
        char ch;
        if (source.position == source.length) {
            throw new IllegalArgumentException("Missing name at " + source);
        }
        int start = source.position;
        if (source.value.charAt(source.position) == '`') {
            ++source.position;
            StringBuilder buffer = new StringBuilder();
            boolean closed = false;
            while (source.position < source.length) {
                char ch2 = source.value.charAt(source.position);
                ++source.position;
                if (ch2 == '`') {
                    if (source.position < source.length && source.value.charAt(source.position) == '`') {
                        ++source.position;
                        buffer.append('`');
                        continue;
                    }
                    closed = true;
                    break;
                }
                buffer.append(ch2);
            }
            if (!closed) {
                source.position = start;
                throw new IllegalArgumentException("Unmatched quote at " + source);
            }
            if (buffer.length() == 0) {
                throw new IllegalArgumentException("Empty quoted field name at " + source);
            }
            return buffer.toString();
        }
        while (source.position < source.length && (Character.isLetterOrDigit(ch = source.value.charAt(source.position)) || ch == '_')) {
            ++source.position;
        }
        if (source.position == start) {
            throw new IllegalArgumentException("Missing name at " + source);
        }
        return source.value.substring(start, source.position);
    }

    static void requireChar(StringPosition source, char required) {
        if (source.position >= source.length || source.value.charAt(source.position) != required) {
            throw new IllegalArgumentException("Missing required char '" + required + "' at " + source);
        }
        ++source.position;
    }

    private static boolean consumeChar(StringPosition source, char ch) {
        boolean result;
        boolean bl = result = source.position < source.length && source.value.charAt(source.position) == ch;
        if (result) {
            ++source.position;
        }
        return result;
    }

    private static void parseUnion(TypeDescription type, StringPosition source) {
        ParserUtils.requireChar(source, '<');
        do {
            type.addUnionChild(ParserUtils.parseType(source));
        } while (ParserUtils.consumeChar(source, ','));
        ParserUtils.requireChar(source, '>');
    }

    private static void parseStruct(TypeDescription type, StringPosition source) {
        ParserUtils.requireChar(source, '<');
        boolean needComma = false;
        while (!ParserUtils.consumeChar(source, '>')) {
            if (needComma) {
                ParserUtils.requireChar(source, ',');
            } else {
                needComma = true;
            }
            String fieldName = ParserUtils.parseName(source);
            ParserUtils.requireChar(source, ':');
            type.addField(fieldName, ParserUtils.parseType(source));
        }
    }

    public static TypeDescription parseType(StringPosition source) {
        TypeDescription result = new TypeDescription(ParserUtils.parseCategory(source));
        switch (result.getCategory()) {
            case BINARY: 
            case BOOLEAN: 
            case BYTE: 
            case DATE: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: 
            case STRING: 
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                break;
            }
            case CHAR: 
            case VARCHAR: {
                ParserUtils.requireChar(source, '(');
                result.withMaxLength(ParserUtils.parseInt(source));
                ParserUtils.requireChar(source, ')');
                break;
            }
            case DECIMAL: {
                ParserUtils.requireChar(source, '(');
                int precision = ParserUtils.parseInt(source);
                ParserUtils.requireChar(source, ',');
                result.withScale(ParserUtils.parseInt(source));
                result.withPrecision(precision);
                ParserUtils.requireChar(source, ')');
                break;
            }
            case LIST: {
                ParserUtils.requireChar(source, '<');
                TypeDescription child = ParserUtils.parseType(source);
                result.addChild(child);
                ParserUtils.requireChar(source, '>');
                break;
            }
            case MAP: {
                ParserUtils.requireChar(source, '<');
                TypeDescription keyType = ParserUtils.parseType(source);
                result.addChild(keyType);
                ParserUtils.requireChar(source, ',');
                TypeDescription valueType = ParserUtils.parseType(source);
                result.addChild(valueType);
                ParserUtils.requireChar(source, '>');
                break;
            }
            case UNION: {
                ParserUtils.parseUnion(result, source);
                break;
            }
            case STRUCT: {
                ParserUtils.parseStruct(result, source);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)result.getCategory()) + " at " + source);
            }
        }
        return result;
    }

    private static List<String> splitName(StringPosition source) {
        ArrayList<String> result = new ArrayList<String>();
        do {
            result.add(ParserUtils.parseName(source));
        } while (ParserUtils.consumeChar(source, '.'));
        return result;
    }

    public static TypeDescription findSubtype(TypeDescription schema, StringPosition source) {
        return ParserUtils.findSubtype(schema, source, true);
    }

    public static TypeDescription findSubtype(TypeDescription schema, StringPosition source, boolean isSchemaEvolutionCaseAware) {
        TypeDescription current;
        List<String> names = ParserUtils.splitName(source);
        if (names.size() == 1 && INTEGER_PATTERN.matcher(names.get(0)).matches()) {
            return schema.findSubtype(Integer.parseInt(names.get(0)));
        }
        TypeDescription typeDescription = current = SchemaEvolution.checkAcidSchema(schema) ? SchemaEvolution.getBaseRow(schema) : schema;
        block8: while (names.size() > 0) {
            String first = names.remove(0);
            switch (current.getCategory()) {
                case STRUCT: {
                    int posn = -1;
                    if (isSchemaEvolutionCaseAware) {
                        posn = current.getFieldNames().indexOf(first);
                    } else {
                        for (int i = 0; i < current.getFieldNames().size(); ++i) {
                            if (!current.getFieldNames().get(i).equalsIgnoreCase(first)) continue;
                            posn = i;
                            break;
                        }
                    }
                    if (posn == -1) {
                        throw new IllegalArgumentException("Field " + first + " not found in " + current.toString());
                    }
                    current = current.getChildren().get(posn);
                    continue block8;
                }
                case LIST: {
                    if (first.equals("_elem")) {
                        current = current.getChildren().get(0);
                        continue block8;
                    }
                    throw new IllegalArgumentException("Field " + first + "not found in " + current.toString());
                }
                case MAP: {
                    if (first.equals("_key")) {
                        current = current.getChildren().get(0);
                        continue block8;
                    }
                    if (first.equals("_value")) {
                        current = current.getChildren().get(1);
                        continue block8;
                    }
                    throw new IllegalArgumentException("Field " + first + "not found in " + current.toString());
                }
                case UNION: {
                    int posn;
                    try {
                        posn = Integer.parseInt(first);
                        if (posn < 0 || posn >= current.getChildren().size()) {
                            throw new NumberFormatException("off end of union");
                        }
                        current = current.getChildren().get(posn);
                        continue block8;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Field " + first + "not found in " + current.toString(), e);
                    }
                }
            }
            throw new IllegalArgumentException("Field " + first + "not found in " + current.toString());
        }
        return current;
    }

    public static List<TypeDescription> findSubtypeList(TypeDescription schema, StringPosition source) {
        ArrayList<TypeDescription> result = new ArrayList<TypeDescription>();
        if (source.hasCharactersLeft()) {
            do {
                result.add(ParserUtils.findSubtype(schema, source));
            } while (ParserUtils.consumeChar(source, ','));
        }
        return result;
    }

    public static void parseKeys(StringPosition source, TypeDescription schema) {
        if (source.hasCharactersLeft()) {
            do {
                String keyName = ParserUtils.parseName(source);
                ParserUtils.requireChar(source, ':');
                for (TypeDescription field2 : ParserUtils.findSubtypeList(schema, source)) {
                    String prev = field2.getAttributeValue("encrypt");
                    if (prev != null && !prev.equals(keyName)) {
                        throw new IllegalArgumentException("Conflicting encryption keys " + keyName + " and " + prev);
                    }
                    field2.setAttribute("encrypt", keyName);
                }
            } while (ParserUtils.consumeChar(source, ';'));
        }
    }

    public static void parseMasks(StringPosition source, TypeDescription schema) {
        if (source.hasCharactersLeft()) {
            do {
                int start = source.position;
                ParserUtils.parseName(source);
                while (ParserUtils.consumeChar(source, ',')) {
                    ParserUtils.parseName(source);
                }
                String maskString = source.fromPosition(start);
                ParserUtils.requireChar(source, ':');
                for (TypeDescription field2 : ParserUtils.findSubtypeList(schema, source)) {
                    String prev = field2.getAttributeValue("mask");
                    if (prev != null && !prev.equals(maskString)) {
                        throw new IllegalArgumentException("Conflicting encryption masks " + maskString + " and " + prev);
                    }
                    field2.setAttribute("mask", maskString);
                }
            } while (ParserUtils.consumeChar(source, ';'));
        }
    }

    public static MaskDescriptionImpl buildMaskDescription(String value) {
        StringPosition source = new StringPosition(value);
        String maskName = ParserUtils.parseName(source);
        ArrayList<String> params = new ArrayList<String>();
        while (ParserUtils.consumeChar(source, ',')) {
            params.add(ParserUtils.parseName(source));
        }
        return new MaskDescriptionImpl(maskName, params.toArray(new String[params.size()]));
    }

    public static class StringPosition {
        final String value;
        int position;
        final int length;

        public StringPosition(String value) {
            this.value = value == null ? "" : value;
            this.position = 0;
            this.length = this.value.length();
        }

        public String toString() {
            return '\'' + this.value.substring(0, this.position) + '^' + this.value.substring(this.position) + '\'';
        }

        public String fromPosition(int start) {
            return this.value.substring(start, this.position);
        }

        public boolean hasCharactersLeft() {
            return this.position != this.length;
        }
    }
}

