/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.shell.commands;

import com.mapr.db.shell.commands.ShellCommands;
import com.mapr.utils.Classpath;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.stereotype.Component;

@Component
public class SessionCommnds
extends ShellCommands {
    protected SessionCommnds() throws IOException {
    }

    @CliAvailabilityIndicator(value={"debug"})
    public boolean available() {
        return true;
    }

    @CliAvailabilityIndicator(value={"mode"})
    public boolean modeAvailable() {
        return false;
    }

    @CliCommand(value={"debug"}, help="Sets/shows the debug mode.")
    public void debug(@CliOption(key={""}, help="Set the debug mode to on/off") String mode, @CliOption(key={"rawstream"}, unspecifiedDefaultValue="true", hidden=true) Boolean rawStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (mode != null) {
            this.session_.setDebug("on".equalsIgnoreCase(mode));
        }
        sb.append("Debug Mode: ").append(this.session_.isDebug() ? "On" : "Off");
        if (rawStream != null) {
            this.session_.setRawStreamScan(rawStream);
            sb.append("\nStream Scan Mode: ").append(this.session_.isRawStreamScan() ? "Raw" : "Messages");
        }
        this.session_.println(sb.toString());
    }

    public void mode(@CliOption(key={""}, help="Sets/shows the active mode (global|files|tables|stream) of the session.") String mode) throws IOException {
        if (mode != null) {
            this.session_.setMode(mode);
        }
        this.session_.printf("Session mode is set to %s.", new Object[]{this.session_.getMode()});
    }

    @CliCommand(value={"jsonoptions"}, help="Sets/shows the Json output options.")
    public void jsonoption(@CliOption(key={"pretty"}, help="Sets/clears the pretty printing mode.", unspecifiedDefaultValue="true") Boolean pretty, @CliOption(key={"withtags", "withTags"}, help="Enables/disables printing with extended Type Tags.", unspecifiedDefaultValue="true") Boolean withTags) throws IOException {
        if (pretty != null) {
            this.session_.getJsonOptions().setPretty(pretty.booleanValue());
        }
        if (withTags != null) {
            this.session_.getJsonOptions().setWithTags(withTags.booleanValue());
        }
        this.session_.println(this.session_.getJsonOptions());
    }

    @CliCommand(value={"tableoptions"}, help="Sets/shows the MapR-DB Table access options.")
    public void tableoption(@CliOption(key={"bufferwrite", "bufferWrite"}, help="Sets/clears the buffered write mode when inserting documents.", unspecifiedDefaultValue="false") Boolean bufferwrite, @CliOption(key={"excludeid", "excludeId"}, help="Enables/disables exclusion of '_id' field when printing documents(deprecated as of v6.0)") Boolean excludeId, @CliOption(key={"insertionorder", "insertionOrder"}, help="Enables/disables insertion order when printing documents(deprecated as of v6.0)") Boolean insertionOrder) throws IOException {
        if (bufferwrite != null) {
            this.session_.getTableOptions().setBufferWrite(bufferwrite);
        }
        if (excludeId != null) {
            this.session_.err_println("Setting excludeid has been disabled as of v6.0");
        }
        if (insertionOrder != null) {
            this.session_.err_println("Setting insertionorder has been disabled as of v6.0");
        }
        this.session_.println(this.session_.getTableOptions());
    }

    @CliCommand(value={"classpath"}, help="Prints MapR-DB Shell classpath.", hidden=true)
    public void classpath(@CliOption(key={"l", "list"}, help="List classpath URLs instead of printing in classpath format.", unspecifiedDefaultValue="false", specifiedDefaultValue="true") Boolean list) throws IOException {
        StringBuilder result = new StringBuilder(2048);
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        URL[] urls = Classpath.getURLs((ClassLoader)cl);
        if (urls != null) {
            for (URL url : urls) {
                result.append(list != false ? (char)'\n' : (char)File.pathSeparatorChar).append(url.getFile());
            }
            this.session_.println(result.substring(1));
        } else {
            this.session_.err_println("The current classloader is not an instance of URLClassLoader.");
        }
    }

    @CliCommand(value={"whoami"}, help="Prints the current MapR-DB Shell user.")
    public void whoami() throws IOException {
        this.session_.println(this.session_.getCurrentUser());
    }
}

