/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.impl;

import com.mapr.db.JsonTable;
import com.mapr.db.Table;
import com.mapr.db.TabletInfo;
import com.mapr.db.impl.ConditionNode;
import com.mapr.db.impl.IdCodec;
import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.impl.MapRDBTableImpl;
import com.mapr.db.impl.TabletInfoImpl;
import com.mapr.db.mapreduce.impl.ByteBufWritableComparable;
import com.mapr.db.mapreduce.impl.ClusterTablePath;
import com.mapr.db.rowcol.DBDocumentImpl;
import com.mapr.fs.MapRFileSystem;
import com.mapr.fs.proto.Common;
import com.mapr.org.apache.hadoop.hbase.util.Bytes;
import com.mapr.util.zookeeper.ZKDataRetrieval;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.ojai.Document;
import org.ojai.DocumentStream;
import org.ojai.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffTableUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DiffTableUtils.class);
    public static final String KEYPREFIX = "k_";
    public static final String FIRSTKEYNAME = "neginf";
    public static final String LASTKEYNAME = "inf";
    public static final String SucceedFileName = "_SUCCESS";
    public static final String outDirConf = "outdirconf";

    public static Path[] validateAndCreateDirs(FileSystem fs, Path outDir) throws IOException {
        try {
            if (fs.exists(outDir)) {
                System.err.println("Output dir " + outDir + " already exists");
                return null;
            }
        }
        catch (IOException e) {
            System.err.println("Failed to check the status of dir " + outDir);
            throw e;
        }
        try {
            if (!fs.mkdirs(outDir)) {
                System.err.println("Failed to create dir " + outDir);
                return null;
            }
        }
        catch (IOException e) {
            System.err.println("Failed to create dir " + outDir);
            throw e;
        }
        Path[] srcDestPaths = new Path[2];
        Path opsForTable1Dir = new Path(outDir, "OpsForSrcTable");
        try {
            if (!fs.mkdirs(opsForTable1Dir)) {
                System.err.println("Failed to create dir " + opsForTable1Dir);
                return null;
            }
        }
        catch (IOException e) {
            System.err.println("Failed to create dir " + opsForTable1Dir);
            throw e;
        }
        srcDestPaths[0] = opsForTable1Dir;
        Path opsForTable2Dir = new Path(outDir, "OpsForDstTable");
        try {
            if (!fs.mkdirs(opsForTable2Dir)) {
                System.err.println("Failed to create dir " + opsForTable2Dir);
                return null;
            }
        }
        catch (IOException e) {
            System.err.println("Failed to create dir " + opsForTable2Dir);
            throw e;
        }
        srcDestPaths[1] = opsForTable2Dir;
        return srcDestPaths;
    }

    public static Path[] createOutputDirs(FileSystem fs, Path outDir) throws IOException {
        try {
            if (!fs.exists(outDir)) {
                System.err.println("Output dir " + outDir + " does not exists");
                return null;
            }
        }
        catch (IOException e) {
            System.err.println("Failed to check the status of dir " + outDir);
            throw e;
        }
        Path[] srcDestPaths = new Path[2];
        Path opsForTable1Dir = new Path(outDir, "OpsForSrcTable");
        try {
            if (!fs.mkdirs(opsForTable1Dir)) {
                System.err.println("Failed to create dir " + opsForTable1Dir);
                return null;
            }
        }
        catch (IOException e) {
            System.err.println("Failed to create dir " + opsForTable1Dir);
            throw e;
        }
        srcDestPaths[0] = opsForTable1Dir;
        Path opsForTable2Dir = new Path(outDir, "OpsForDstTable");
        try {
            if (!fs.mkdirs(opsForTable2Dir)) {
                System.err.println("Failed to create dir " + opsForTable2Dir);
                return null;
            }
        }
        catch (IOException e) {
            System.err.println("Failed to create dir " + opsForTable2Dir);
            throw e;
        }
        srcDestPaths[1] = opsForTable2Dir;
        return srcDestPaths;
    }

    public static boolean copyFileWithPrefix(FileSystem fs, Path srcDir, Path dstDir, Configuration conf, String prefix, Logger LOG) throws IOException {
        if (!fs.exists(srcDir)) {
            LOG.error("Source " + srcDir + " doesn't exist.");
            return false;
        }
        if (!fs.getFileStatus(srcDir).isDirectory()) {
            LOG.error("Source " + srcDir + " is not a directory.");
            return false;
        }
        if (fs.exists(dstDir)) {
            LOG.warn("Files in destination directory " + dstDir + " will be overwritten.");
            if (!fs.delete(dstDir, true)) {
                LOG.error("Fail to replace " + dstDir);
                return false;
            }
        }
        if (!fs.mkdirs(dstDir)) {
            LOG.error("Fail to create " + dstDir);
            return false;
        }
        boolean moved = false;
        Object[] contents = fs.listStatus(srcDir);
        System.out.println("util1  " + srcDir.toString() + " contents " + contents.length + " " + prefix);
        Arrays.sort(contents);
        for (int i = 0; i < contents.length; ++i) {
            Path srcPath = contents[i].getPath();
            System.out.println("util 2 " + srcPath.toString() + " " + srcPath.getName() + " prefix " + prefix);
            if (!contents[i].isFile() || !srcPath.getName().startsWith(prefix)) continue;
            Path dstPath = new Path(dstDir + "/" + srcPath.getName());
            System.out.println("src and dst " + srcPath.toString() + " " + dstPath.toString());
            if (!fs.rename(srcPath, dstPath)) {
                LOG.error("Fail to move " + srcPath.toString() + " to " + dstPath.toString());
                return false;
            }
            moved = true;
            LOG.debug("Moved " + srcPath.toString() + " to " + dstPath.toString());
        }
        if (!moved && !fs.delete(dstDir, true)) {
            LOG.error("Fail to cleanup empty " + dstDir);
            return false;
        }
        return true;
    }

    public static String getTmpDirName(Configuration conf) {
        return conf.get("hadoop.tmp.dir");
    }

    public static String getTabletKeyFileName(String tblName) {
        return tblName.replace("/", "").replace(":", "") + ".regionkeys";
    }

    public static String getReSplitedTabletKeyFileName(String tblName) {
        return tblName.replace("/", "").replace(":", "") + ".resplitedregionkeys";
    }

    public static String getSegKeyFileName(String tblName) {
        return tblName.replace("/", "").replace(":", "") + ".segmentkeys";
    }

    public static String getSegKeyDirName(String tblName) {
        return tblName.replace("/", "").replace(":", "") + ".startkeys";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServiceAddress(Configuration conf, String clusterUri, String serviceName) throws IOException, URISyntaxException {
        String zkAddress = null;
        try (MapRFileSystem mfs = null;){
            mfs = new MapRFileSystem();
            mfs.initialize(new URI(clusterUri), conf);
            zkAddress = mfs.getZkConnectString();
            LOG.info("zkAddress(" + zkAddress + ")");
        }
        if (zkAddress == null) {
            LOG.error("Zookeeper address is null from MapRFilesystem from cluster " + clusterUri);
            return null;
        }
        ZKDataRetrieval zkConnection = new ZKDataRetrieval(zkAddress);
        Common.ServiceData hostInfo = zkConnection.getServiceMasterData(serviceName);
        if (hostInfo == null) {
            LOG.error("Unable to determine service " + serviceName + " address from Zookeeper at " + zkAddress + " from cluster " + clusterUri);
            return null;
        }
        String hostName = hostInfo.getHost();
        int servicePort = hostInfo.getPort();
        LOG.info(serviceName + " address: host name(" + hostName + "), port(" + servicePort + ")");
        if (servicePort > 0) {
            return hostName + ":" + servicePort;
        }
        return hostName;
    }

    public static boolean checkPathExists(Configuration conf, ClusterTablePath cPath) throws IOException {
        Path path = cPath.getFullPath();
        FileSystem fs = path.getFileSystem(conf);
        return fs.exists(path);
    }

    static List<ByteBufWritableComparable> getRegionStartKeys(Table table) throws IOException {
        TabletInfo[] tabletInfos = table.getTabletInfos();
        ArrayList<ByteBufWritableComparable> ret = new ArrayList<ByteBufWritableComparable>(tabletInfos.length);
        for (TabletInfo tInfo : tabletInfos) {
            byte[] sKey = ((TabletInfoImpl)tInfo).getStartRow();
            ret.add(new ByteBufWritableComparable(ByteBuffer.wrap(sKey)));
        }
        return ret;
    }

    public static void printKeyRange(List<ByteBufWritableComparable> startKeys) {
        System.out.println("printKeyRange:");
        if (startKeys == null || startKeys.isEmpty()) {
            System.err.println("Input key list is empty\n");
        } else {
            int i = 0;
            for (ByteBufWritableComparable key : startKeys) {
                System.out.println("StartKey of Range " + i + " : (" + key + ")");
                ++i;
            }
        }
    }

    public static void printKeyRanges(List<ConditionNode.RowkeyRange> keys) {
        LOG.info("StartEndKeys");
        int i = 0;
        for (ConditionNode.RowkeyRange rkey : keys) {
            LOG.info("Range " + i + " : " + Bytes.toStringBinary((byte[])rkey.getStartRow()) + ",  " + Bytes.toStringBinary((byte[])rkey.getStopRow()));
            ++i;
        }
    }

    public static void logKeyRanges(List<ConditionNode.RowkeyRange> sekeys) {
        LOG.debug("StartEndKeys");
        int i = 0;
        for (ConditionNode.RowkeyRange rkey : sekeys) {
            LOG.debug("Range " + i + " : " + rkey.toString());
            ++i;
        }
    }

    public static List<ConditionNode.RowkeyRange> GenStartEndKeys(List<ByteBufWritableComparable> startKeys) throws IOException {
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        ArrayList<ByteBufWritableComparable> sklist = new ArrayList<ByteBufWritableComparable>(startKeys.size());
        ArrayList<ByteBufWritableComparable> eklist = new ArrayList<ByteBufWritableComparable>(startKeys.size());
        for (ByteBufWritableComparable k : startKeys) {
            sklist.add(k);
        }
        if (startKeys.size() > 0) {
            ListIterator<ByteBufWritableComparable> iter = startKeys.listIterator(1);
            while (iter.hasNext()) {
                ByteBufWritableComparable k;
                k = iter.next();
                eklist.add(k);
            }
            byte[] lastEndKey = new byte[]{};
            eklist.add(new ByteBufWritableComparable(ByteBuffer.wrap(lastEndKey)));
        }
        ArrayList<ConditionNode.RowkeyRange> rangeList = new ArrayList<ConditionNode.RowkeyRange>(startKeys.size());
        ListIterator skIter = sklist.listIterator(0);
        ListIterator ekIter = eklist.listIterator(0);
        while (skIter.hasNext() && ekIter.hasNext()) {
            ConditionNode.RowkeyRange keyRange = new ConditionNode.RowkeyRange(((ByteBufWritableComparable)skIter.next()).getBytes(), ((ByteBufWritableComparable)ekIter.next()).getBytes());
            rangeList.add(keyRange);
        }
        if (skIter.hasNext() || ekIter.hasNext()) {
            throw new IllegalArgumentException("startKeys has size " + sklist.size() + ", but endKeys has size " + eklist.size());
        }
        return rangeList;
    }

    public static List<ByteBufWritableComparable> readKeyRange(Configuration conf, String partitionsPathName) throws IOException {
        return DiffTableUtils.readKeyRange(conf, new Path(partitionsPathName));
    }

    public static List<ByteBufWritableComparable> readKeyRange(Configuration conf, Path partitionsPath) throws IOException {
        ArrayList<ByteBufWritableComparable> ret = new ArrayList<ByteBufWritableComparable>();
        FileSystem fs = partitionsPath.getFileSystem(conf);
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, partitionsPath, conf);
        ByteBuffer key1 = null;
        ByteBuffer key2 = null;
        ByteBufWritableComparable iKey = new ByteBufWritableComparable();
        NullWritable value = NullWritable.get();
        LOG.debug("readSegKeyRange: " + partitionsPath.toString());
        int i = 0;
        while (reader.next((Writable)iKey, (Writable)value)) {
            key1 = key2;
            key2 = iKey.getByteBuf();
            if (i > 0 && key1.compareTo(key2) >= 0) {
                reader.close();
                throw new IOException("Current keyrange " + i + " startky(" + Bytes.toStringBinary((ByteBuffer)key2) + ") should be larger than the previous keyrange startkey(" + Bytes.toStringBinary((ByteBuffer)key1) + ")");
            }
            LOG.debug("\t (" + Bytes.toStringBinary((ByteBuffer)key2) + ")");
            ret.add(new ByteBufWritableComparable(key2));
            ++i;
        }
        LOG.debug("Done readSegKeyRange: " + partitionsPath.toString() + ", list length=" + Integer.toString(i));
        reader.close();
        return ret;
    }

    public static void writeKeyRange(Configuration conf, String partitionsPathName, List<ByteBufWritableComparable> startKeys) throws IOException {
        DiffTableUtils.writeKeyRange(conf, new Path(partitionsPathName), startKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeKeyRange(Configuration conf, Path partitionsPath, List<ByteBufWritableComparable> startKeys) throws IOException {
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        Path parentPath = partitionsPath.getParent();
        FileSystem fs = partitionsPath.getFileSystem(conf);
        if (!fs.exists(parentPath)) {
            LOG.debug("create directory " + parentPath.toString());
            fs.mkdirs(parentPath);
        }
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, ByteBufWritableComparable.class, NullWritable.class);
        LOG.debug("writeSegKeyRange to file " + partitionsPath.toString());
        ByteBufWritableComparable prevKey = null;
        try {
            for (ByteBufWritableComparable startKey : startKeys) {
                if (prevKey != null && prevKey.compareTo(startKey) >= 0) {
                    throw new IOException("Current startky(" + startKey.toString() + ") should be larger than the previous startkey(" + prevKey.toString() + ")");
                }
                LOG.debug("\t (" + startKey.toString() + ")");
                ByteBuffer startKeyBuf = startKey.getByteBuf();
                writer.append((Writable)new ByteBufWritableComparable(startKeyBuf), (Writable)NullWritable.get());
                prevKey = startKey;
            }
        }
        finally {
            writer.close();
        }
    }

    public static void copyKeyRangeFile(Configuration srcConf, String srcPathName, Configuration dstConf, String dstPathName) throws IOException {
        List<ByteBufWritableComparable> startKeys = DiffTableUtils.readKeyRange(srcConf, srcPathName);
        DiffTableUtils.writeKeyRange(dstConf, dstPathName, startKeys);
    }

    public static void copyKeyRangeFile(Configuration srcConf, Path srcPath, Configuration dstConf, Path dstPath) throws IOException {
        List<ByteBufWritableComparable> startKeys = DiffTableUtils.readKeyRange(srcConf, srcPath);
        DiffTableUtils.writeKeyRange(dstConf, dstPath, startKeys);
    }

    public static void writeTabletKeyRange(String tblKeyPathName, String tblName) throws IOException {
        Configuration conf = new Configuration();
        JsonTable table = MapRDBImpl.getTable((String)tblName);
        List<ByteBufWritableComparable> tblKeys = DiffTableUtils.getRegionStartKeys((Table)table);
        TreeSet<ByteBufWritableComparable> sortedTblKeys = new TreeSet<ByteBufWritableComparable>(tblKeys);
        ByteBufWritableComparable first = sortedTblKeys.first();
        if (!first.equals(ByteBufWritableComparable.EMPTY_BYTEBUFFER)) {
            throw new IllegalArgumentException("First region of table should have empty start key. Instead has(" + first.toString() + ") with size " + first.getLength());
        }
        ByteBufWritableComparable[] sortedList = sortedTblKeys.toArray(new ByteBufWritableComparable[sortedTblKeys.size()]);
        LOG.info("write region start keys to " + tblKeyPathName + " for table " + tblName);
        DiffTableUtils.writeKeyRange(conf, tblKeyPathName, Arrays.asList(sortedList));
    }

    public static int writeSegKeyRange(String segKeyPathName, String tblName) throws IOException {
        byte[] rKey1;
        Configuration conf = new Configuration();
        LOG.debug("writeSegKeyRange to file " + segKeyPathName + " for table " + tblName);
        Path partitionsPath = new Path(segKeyPathName);
        FileSystem fs = partitionsPath.getFileSystem(conf);
        SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, ByteBufWritableComparable.class, NullWritable.class);
        JsonTable table = MapRDBImpl.getTable((String)tblName);
        DocumentStream rs = ((MapRDBTableImpl)table).segmentKeyScan();
        Iterator itrs = rs.iterator();
        int segnum = 0;
        boolean isEmpty = false;
        Document res = null;
        if (!itrs.hasNext()) {
            isEmpty = true;
        } else {
            res = (Document)itrs.next();
            ++segnum;
            if (res == null) {
                isEmpty = true;
            }
        }
        if (isEmpty) {
            table.close();
            if (LOG.isInfoEnabled()) {
                LOG.info("No segment key range returned from server. Write only -INF(EMPTY_BYTE_ARRAY) segment start key to " + partitionsPath.toString() + " for empty table " + tblName);
            }
            LOG.debug("\t (" + ByteBufWritableComparable.EMPTY_BYTEBUFFER + ")");
            writer.append((Writable)ByteBufWritableComparable.EMPTY_BYTEBUFFER, (Writable)NullWritable.get());
            writer.close();
            return segnum;
        }
        Value firstId = ((DBDocumentImpl)res).getId();
        Value.Type idType = firstId.getType();
        boolean firstIsEmpty = true;
        if (idType == Value.Type.STRING) {
            if (firstId.getString() != "") {
                LOG.info("First region of table does not have any data. We will add the empty start key  to cover these beginning empty regions. The first region with data has start key (" + firstId.getString() + ")");
                firstIsEmpty = false;
            }
        } else if (idType == Value.Type.BINARY) {
            if (!firstId.getBinary().equals(ByteBuffer.wrap(new byte[0]))) {
                LOG.info("First region of table does not have any data. We will add the empty start key  to cover these beginning empty regions. The first region with data has start key (" + Bytes.toStringBinary((ByteBuffer)firstId.getBinary()) + ")");
                firstIsEmpty = false;
            }
        } else {
            table.close();
            throw new IOException("Only String and Binary Document IDs are supported, and this ID has type " + idType + ")");
        }
        LOG.debug("write segment start keys to " + partitionsPath.toString() + " for table " + tblName);
        LOG.debug("\t (" + ByteBufWritableComparable.EMPTY_BYTEBUFFER.toString() + ")");
        writer.append((Writable)ByteBufWritableComparable.EMPTY_BYTEBUFFER, (Writable)NullWritable.get());
        byte[] rKey2 = rKey1 = Bytes.getBytes((ByteBuffer)IdCodec.encode((Value)((DBDocumentImpl)res).getId()));
        ByteBufWritableComparable iKey = null;
        if (!firstIsEmpty) {
            iKey = new ByteBufWritableComparable(ByteBuffer.wrap(rKey2));
            LOG.debug("\t (" + Bytes.toStringBinary((byte[])rKey2) + ")");
            writer.append((Writable)iKey, (Writable)NullWritable.get());
        }
        while (itrs.hasNext()) {
            res = (Document)itrs.next();
            ++segnum;
            rKey1 = rKey2;
            if (Bytes.compareTo((byte[])rKey1, (byte[])(rKey2 = Bytes.getBytes((ByteBuffer)IdCodec.encode((Value)((DBDocumentImpl)res).getId())))) >= 0) {
                table.close();
                writer.close();
                throw new IOException("Current keyrange startky(" + Bytes.toStringBinary((byte[])rKey2) + ") should be larger than the previous keyrange startkey(" + Bytes.toStringBinary((byte[])rKey1) + ")");
            }
            iKey = new ByteBufWritableComparable(ByteBuffer.wrap(rKey2));
            LOG.debug("\t (" + Bytes.toStringBinary((byte[])rKey2) + ")");
            writer.append((Writable)iKey, (Writable)NullWritable.get());
        }
        table.close();
        writer.close();
        LOG.debug("Total " + segnum + " segement startKey written.");
        return segnum;
    }

    public static void splitSubRegionKeysbyRegionKeys(String inputRegionKeyFileName, String inputSubRegionKeyFileName, String outputSplitKeyFileName, String outputSubRegionKeyDir) throws IOException {
        Configuration conf = new Configuration();
        List<ByteBufWritableComparable> tblKeys = DiffTableUtils.readKeyRange(conf, inputRegionKeyFileName);
        DiffTableUtils.splitSubRegionKeysbyRegionKeys(tblKeys, inputSubRegionKeyFileName, outputSplitKeyFileName, outputSubRegionKeyDir);
    }

    static void splitSubRegionKeysbyRegionKeys(List<ByteBufWritableComparable> tblKeys, String inputSubRegionKeyFileName, String outputSplitKeyFileName, String outputSubRegionKeyDir) throws IOException {
        Object tblSegKeysFileName;
        ByteBuffer rKey1;
        Configuration conf = new Configuration();
        Iterator<ByteBufWritableComparable> itTblKeys = tblKeys.iterator();
        ByteBufWritableComparable curTblStartKey = itTblKeys.next();
        ByteBufWritableComparable curTblEndKey = null;
        if (itTblKeys.hasNext()) {
            curTblEndKey = itTblKeys.next();
        }
        ArrayList<ByteBufWritableComparable> curTblSegKeys = new ArrayList<ByteBufWritableComparable>();
        ArrayList<ByteBufWritableComparable> tblSplitKeys = new ArrayList<ByteBufWritableComparable>();
        Path partitionsPath = new Path(inputSubRegionKeyFileName);
        FileSystem fs = partitionsPath.getFileSystem(conf);
        SequenceFile.Reader reader = new SequenceFile.Reader(fs, partitionsPath, conf);
        ByteBufWritableComparable iKey = new ByteBufWritableComparable();
        NullWritable value = NullWritable.get();
        LOG.debug("readSegKeyRange: " + partitionsPath.toString());
        if (!reader.next((Writable)iKey, (Writable)value)) {
            reader.close();
            throw new IOException("No  key in sub-region file " + inputSubRegionKeyFileName);
        }
        ByteBuffer rKey2 = rKey1 = iKey.getByteBuf();
        if (iKey == null || !iKey.equals(ByteBufWritableComparable.EMPTY_BYTEBUFFER)) {
            reader.close();
            throw new IOException("First segment of the table should have empty start key. Instead has: " + iKey);
        }
        curTblSegKeys.add(new ByteBufWritableComparable(rKey2));
        LOG.debug("\t0 (" + Bytes.toStringBinary((ByteBuffer)rKey2) + ")");
        int cnt = 1;
        while (reader.next((Writable)iKey, (Writable)value)) {
            rKey1 = rKey2;
            if (rKey1.compareTo(rKey2 = iKey.getByteBuf()) >= 0) {
                reader.close();
                throw new IOException("Current keyrange startky(" + Bytes.toStringBinary((ByteBuffer)rKey2) + ") should be larger than the previous keyrange startkey(" + Bytes.toStringBinary((ByteBuffer)rKey1) + ")");
            }
            if (curTblEndKey == null || rKey2.compareTo(curTblEndKey.getByteBuf()) < 0) {
                curTblSegKeys.add(new ByteBufWritableComparable(rKey2));
                LOG.debug("\t" + Integer.toString(cnt) + " (" + Bytes.toStringBinary((ByteBuffer)rKey2) + ")");
            } else {
                tblSegKeysFileName = KEYPREFIX + curTblSegKeys.get(0);
                if (curTblSegKeys.get(0).equals(ByteBufWritableComparable.EMPTY_BYTEBUFFER)) {
                    tblSegKeysFileName = FIRSTKEYNAME;
                }
                LOG.debug(Integer.toString(curTblSegKeys.size()) + " segments to write.");
                DiffTableUtils.writeKeyRange(conf, outputSubRegionKeyDir + "/" + (String)tblSegKeysFileName, curTblSegKeys);
                tblSplitKeys.add(curTblSegKeys.get(0));
                curTblSegKeys.clear();
                curTblStartKey = curTblEndKey;
                curTblEndKey = itTblKeys.hasNext() ? itTblKeys.next() : null;
                curTblSegKeys.add(new ByteBufWritableComparable(rKey2));
                LOG.debug("\t" + Integer.toString(cnt) + " (" + Bytes.toStringBinary((ByteBuffer)rKey2) + ")");
            }
            ++cnt;
        }
        if (curTblSegKeys.size() > 0) {
            tblSegKeysFileName = KEYPREFIX + curTblSegKeys.get(0);
            if (((ByteBufWritableComparable)curTblSegKeys.get(0)).equals(ByteBufWritableComparable.EMPTY_BYTEBUFFER)) {
                tblSegKeysFileName = FIRSTKEYNAME;
            }
            DiffTableUtils.writeKeyRange(conf, outputSubRegionKeyDir + "/" + (String)tblSegKeysFileName, curTblSegKeys);
            tblSplitKeys.add(curTblSegKeys.get(0));
        }
        reader.close();
        DiffTableUtils.writeKeyRange(conf, outputSplitKeyFileName, tblSplitKeys);
        LOG.debug("Total " + cnt + " segement startKey written into " + tblSplitKeys.size() + " tablet key range files.");
    }

    public static void writeStringToFile(Configuration conf, String msg, String filePathName) throws IOException {
        Path filePath = new Path(filePathName);
        FileSystem fs = filePath.getFileSystem(conf);
        BufferedWriter br = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(filePath, true)));
        LOG.debug("Write " + msg + " to file " + filePathName);
        br.write(msg);
        br.close();
    }

    public static String[] diffTablesWithCrcArgToDiffTablesArg(String diffTableOutdir, String splitKRFile, String includeKRFile, String[] diffArgs) {
        if (diffArgs.length == 0 && splitKRFile == null && includeKRFile == null) {
            return new String[0];
        }
        if (includeKRFile != null && splitKRFile == null) {
            throw new IllegalArgumentException("Input key range file is missing.");
        }
        ArrayList<String> rangeArgs = new ArrayList<String>();
        for (int i = 0; i < diffArgs.length; ++i) {
            if (diffArgs[i].equalsIgnoreCase("-outdir")) {
                diffArgs[i + 1] = diffTableOutdir;
                LOG.debug("diffTables -outdir =(" + diffArgs[i + 1] + ")");
            }
            rangeArgs.add(diffArgs[i]);
        }
        if (splitKRFile != null) {
            rangeArgs.add("-split_keyrange");
            rangeArgs.add(splitKRFile);
        }
        if (includeKRFile != null) {
            rangeArgs.add("-keyrange_included");
            rangeArgs.add(includeKRFile);
        }
        rangeArgs.add("-mapreduce");
        rangeArgs.add("true");
        String[] retArr = new String[rangeArgs.size()];
        retArr = rangeArgs.toArray(retArr);
        LOG.info(rangeArgs.toString());
        return retArr;
    }

    public class ServiceName {
        public static final String HISTORYSERVERNAME = "historyserver";
        public static final String RESOURCEMANAGERNAME = "resourcemanager";
    }
}

