/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.db.mapreduce.test;

import com.mapr.db.impl.MapRDBImpl;
import com.mapr.db.mapreduce.DocumentSerialization;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serializer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.ojai.Document;
import org.ojai.json.Json;

@Category(value={SimpleTest.class})
public class TestDocumentSerialization
extends BaseTest {
    @Test
    public void testRec() throws Exception {
        DocumentSerialization recSer = new DocumentSerialization();
        Document rec = Json.newDocument();
        rec.set("a.b", "pqr");
        rec.set("a.v", "verbose");
        rec.set("a.x.c", 111);
        rec.set("_id", "k1");
        Serializer ser = recSer.getSerializer(Document.class);
        DataOutputStream out = new DataOutputStream(new FileOutputStream("test.txt"));
        ser.open((OutputStream)out);
        ser.serialize((Object)rec);
        out.close();
        DataInputStream in = new DataInputStream(new FileInputStream("test.txt"));
        Deserializer de = recSer.getDeserializer(Document.class);
        de.open((InputStream)in);
        Document newrec = null;
        newrec = (Document)de.deserialize(newrec);
        de.close();
        Assert.assertEquals((Object)"pqr", (Object)newrec.getString("a.b"));
        Assert.assertEquals((long)111L, (long)newrec.getInt("a.x.c"));
    }

    @Test
    public void testMultipleRec() throws Exception {
        DocumentSerialization recSer = new DocumentSerialization();
        Document rec = Json.newDocument();
        rec.set("a.b", "pqr");
        rec.set("a.v", "verbose");
        rec.set("a.x.c", 111);
        rec.set("_id", "k1");
        Serializer ser = recSer.getSerializer(Document.class);
        Document rec2 = MapRDBImpl.newDocument();
        rec2.set("a.x", 256);
        rec2.set("a.y", "abc");
        rec2.setId("k2");
        DataOutputStream out = new DataOutputStream(new FileOutputStream("test.txt"));
        ser.open((OutputStream)out);
        ser.serialize((Object)rec);
        ser.serialize((Object)rec2);
        out.close();
        DataInputStream in = new DataInputStream(new FileInputStream("test.txt"));
        Deserializer de = recSer.getDeserializer(Document.class);
        de.open((InputStream)in);
        Document newrec = null;
        newrec = (Document)de.deserialize(newrec);
        Assert.assertEquals((Object)"pqr", (Object)newrec.getString("a.b"));
        Assert.assertEquals((long)111L, (long)newrec.getInt("a.x.c"));
        newrec = (Document)de.deserialize((Object)newrec);
        Assert.assertEquals((Object)"abc", (Object)newrec.getString("a.y"));
        de.close();
    }
}

