/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.clients;

import com.mapr.client.impl.Fid;
import com.mapr.client.impl.MapRClient;
import com.mapr.client.impl.msgs.ColumnFamilyCreateMsg;
import com.mapr.client.impl.msgs.ColumnFamilyScanMsg;
import com.mapr.client.impl.msgs.GetTableSchemaMsg;
import com.mapr.client.impl.msgs.GetattrMsg;
import com.mapr.client.impl.msgs.LookupMsg;
import com.mapr.client.impl.msgs.PathWalkPlusMsg;
import com.mapr.client.impl.msgs.PutMsg;
import com.mapr.client.impl.msgs.TableCreateMsg;
import com.mapr.client.impl.msgs.TabletLookupMsg;
import com.mapr.client.impl.msgs.UnlinkMsg;
import com.mapr.client.impl.rpc.RpcClient;
import com.mapr.client.impl.rpc.ServiceHosts;
import com.mapr.fs.proto.Common;
import com.mapr.fs.proto.Dbserver;
import com.mapr.fs.proto.Fileserver;
import com.stumbleupon.async.Deferred;
import io.netty.buffer.ByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MfsClient
extends RpcClient {
    private static final Logger logger = LoggerFactory.getLogger(MfsClient.class);
    private Common.Server mfsServer;

    public MfsClient(MapRClient maprClient, Common.Server mfsServer, boolean isSecure) {
        super(maprClient, ServiceHosts.createServiceHostsFromServerMsg(mfsServer), isSecure);
        this.mfsServer = mfsServer;
    }

    @Override
    public Deferred<Object> startClient() {
        return null;
    }

    @Override
    public Deferred<Object> stopClient() {
        logger.debug("{} stopped", (Object)this.getClass().getSimpleName());
        return null;
    }

    public Common.Server getMfsServer() {
        return this.mfsServer;
    }

    public Deferred<Fileserver.LookupResponse> lookup(String fileName, Fid parentFid) throws InterruptedException, Exception {
        return this.sendRequest(new LookupMsg(fileName, parentFid.getFidMsg(), this.mapRClient.getCredentials()));
    }

    public Deferred<Fileserver.UnlinkResponse> unlink(String filePath, Fid parentFid) throws InterruptedException, Exception {
        return this.sendRequest(new UnlinkMsg(filePath, parentFid.getFidMsg(), this.mapRClient.getCredentials()));
    }

    public Deferred<Fileserver.PathWalkPlusResponse> pathWalkPlus(String filePath, Fid startFid) throws InterruptedException, Exception {
        return this.sendRequest(new PathWalkPlusMsg(filePath, startFid.getFidMsg(), this.mapRClient.getCredentials()));
    }

    public Deferred<Fileserver.GetattrResponse> getattr(Fid fileFid) throws InterruptedException, Exception {
        return this.sendRequest(new GetattrMsg(fileFid.getFidMsg(), this.mapRClient.getCredentials()));
    }

    public Deferred<Dbserver.TableCreateResponse> tableCreate(String tableName, Fid parent, boolean isJson) throws InterruptedException, Exception {
        return this.sendRequest(new TableCreateMsg(tableName, parent.getFidMsg(), isJson, this.mapRClient.getCredentials(), this.mapRClient.getAttributes()));
    }

    public Deferred<Dbserver.ColumnFamilyScanResponse> columnFamilyScan(Fid tableFid) throws InterruptedException, Exception {
        return this.sendRequest(new ColumnFamilyScanMsg(tableFid.getFidMsg(), this.mapRClient.getCredentials()));
    }

    public Deferred<Dbserver.ColumnFamilyCreateResponse> columnFamilyCreate(String cfName, Fid tableFid) throws InterruptedException, Exception {
        return this.sendRequest(new ColumnFamilyCreateMsg(cfName, tableFid.getFidMsg(), this.mapRClient.getCredentials()));
    }

    public Deferred<Dbserver.GetTableSchemaResponse> getTableSchema(Fid tableFid) throws InterruptedException, Exception {
        return this.sendRequest(new GetTableSchemaMsg(tableFid.getFidMsg(), this.mapRClient.getCredentials()));
    }

    public Deferred<Dbserver.TabletLookupResponse> tabletLookup(Fid tableFid, ByteBuf key, int numTablets) throws InterruptedException, Exception {
        return this.sendRequest(new TabletLookupMsg(tableFid.getFidMsg(), key, numTablets, this.mapRClient.getCredentials()));
    }

    public Deferred<Dbserver.PutResponse> put(Fid tabletFid, long schemaVersion, Iterable<Dbserver.CompressedRow> compRowList, ByteBuf payload) throws InterruptedException, Exception {
        return this.sendRequest(new PutMsg(tabletFid.getFidMsg(), schemaVersion, compRowList, payload, this.mapRClient.getCredentials()));
    }
}

