/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.tests.rpc;

import com.mapr.client.impl.rpc.HostAndPort;
import com.mapr.client.impl.rpc.ServiceHosts;
import com.mapr.tests.BaseTest;
import com.mapr.tests.annotations.SimpleTest;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SimpleTest.class})
public class ServiceHostsTest
extends BaseTest {
    private static final Logger logger = LoggerFactory.getLogger(ServiceHostsTest.class);

    @Test
    public void testServiceHostsParseFrom() {
        ServiceHosts serviceHosts = ServiceHosts.parseFrom((String)"abc:214; xyz:1024");
        List hostList = serviceHosts.getHostList();
        logger.info(hostList.toString());
        Assert.assertEquals((long)2L, (long)hostList.size());
        HostAndPort host = (HostAndPort)hostList.get(0);
        Assert.assertEquals((Object)"abc", (Object)host.getHost());
        Assert.assertEquals((long)214L, (long)host.getPort());
        host = (HostAndPort)hostList.get(1);
        Assert.assertEquals((Object)"xyz", (Object)host.getHost());
        Assert.assertEquals((long)1024L, (long)host.getPort());
        serviceHosts = ServiceHosts.parseFrom((String)"abc.pq.rst:0; xyz.qa:65535; ");
        hostList = serviceHosts.getHostList();
        logger.debug(hostList.toString());
        Assert.assertEquals((long)2L, (long)hostList.size());
        host = (HostAndPort)hostList.get(0);
        Assert.assertEquals((Object)"abc.pq.rst", (Object)host.getHost());
        Assert.assertEquals((long)0L, (long)host.getPort());
        host = (HostAndPort)hostList.get(1);
        Assert.assertEquals((Object)"xyz.qa", (Object)host.getHost());
        Assert.assertEquals((long)65535L, (long)host.getPort());
    }
}

