/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.rpc;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostAndPort {
    private static final Logger logger = LoggerFactory.getLogger(HostAndPort.class);
    private boolean resolved = false;
    private String host;
    private int port;

    public HostAndPort() {
        this.host = "";
        this.port = 0;
    }

    public HostAndPort(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String toString() {
        return "{\"host\": \"" + this.getHost() + "\", \"port\": " + this.getPort() + "}";
    }

    public String getHost() {
        return this.host;
    }

    public String resolvedHost() {
        if (!this.resolved) {
            String newhost = HostAndPort.getIP(this.host);
            if (newhost != null) {
                this.host = newhost;
            }
            this.resolved = true;
        }
        return this.host;
    }

    void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    void setPort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException(port + " is not a valid port.");
        }
        this.port = port;
    }

    private static String getIP(String host) {
        long start = System.nanoTime();
        try {
            String ip = InetAddress.getByName(host).getHostAddress();
            long latency = System.nanoTime() - start;
            if (latency >= 10000000L) {
                logger.warn("Slow DNS lookup! Resolved IP of '{}' to {} in {}\u00b5s", new Object[]{host, ip, latency / 1000L});
            }
            return ip;
        }
        catch (UnknownHostException e) {
            logger.error("Failed to resolve the IP of '{}' in {}\u00b5s", (Object)host, (Object)((System.nanoTime() - start) / 100L));
            return null;
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof HostAndPort)) {
            return false;
        }
        HostAndPort h = (HostAndPort)o;
        if (h.getPort() != this.getPort()) {
            return false;
        }
        try {
            if (InetAddress.getByName(this.host).equals(InetAddress.getByName(h.host))) {
                return true;
            }
        }
        catch (UnknownHostException e) {
            return false;
        }
        return false;
    }

    public int hashcode() {
        try {
            return InetAddress.getByName(this.host).hashCode() * this.port;
        }
        catch (UnknownHostException e) {
            return -1;
        }
    }
}

