/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.impl.rpc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.net.InetAddresses;
import com.mapr.client.impl.rpc.HostAndPort;
import com.mapr.fs.proto.Common;
import java.util.Iterator;
import java.util.List;

public final class ServiceHosts
implements Iterable<HostAndPort> {
    private final List<HostAndPort> hostList;

    private ServiceHosts(List<HostAndPort> hostList) {
        this.hostList = hostList;
    }

    private static IllegalArgumentException invalidAddress(int strIdx, String serviceAddresses) {
        return new IllegalArgumentException("Invalid token at position " + strIdx + " for addresses " + serviceAddresses);
    }

    public static ServiceHosts createServiceHostsFromServerMsg(Common.Server serverMsg) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int ipCount = serverMsg.getIpsCount();
        for (int i = 0; i < ipCount; ++i) {
            String ipAddress = InetAddresses.fromInteger((int)serverMsg.getIps(i).getHost()).toString();
            int port = serverMsg.getIps(i).getPort();
            HostAndPort curHostAndPort = new HostAndPort(ipAddress.substring(1), port);
            builder.add((Object)curHostAndPort);
        }
        return new ServiceHosts((List<HostAndPort>)builder.build());
    }

    public static ServiceHosts createServiceHosts(List<HostAndPort> hostList) {
        return new ServiceHosts(hostList);
    }

    public static ServiceHosts parseFrom(String serviceAddresses) {
        Preconditions.checkNotNull((Object)serviceAddresses);
        boolean inHost = true;
        int inPort = 2;
        int strSize = serviceAddresses.length();
        int parseState = 1;
        StringBuffer fragment = new StringBuffer();
        ImmutableList.Builder builder = ImmutableList.builder();
        HostAndPort currHostAndPort = null;
        block4: for (int strIdx = 0; strIdx < strSize; ++strIdx) {
            char nextChar = serviceAddresses.charAt(strIdx);
            switch (nextChar) {
                case ',': 
                case ';': {
                    if (parseState != 2) {
                        throw ServiceHosts.invalidAddress(strIdx, serviceAddresses);
                    }
                    currHostAndPort.setPort(Integer.valueOf(fragment.toString().trim()));
                    currHostAndPort = null;
                    fragment.setLength(0);
                    parseState = 1;
                    continue block4;
                }
                case ':': {
                    if (parseState != 1) {
                        throw ServiceHosts.invalidAddress(strIdx, serviceAddresses);
                    }
                    currHostAndPort.setHost(fragment.toString().trim());
                    fragment.setLength(0);
                    parseState = 2;
                    continue block4;
                }
                default: {
                    if (Character.isWhitespace(nextChar)) continue block4;
                    String otherValidChars = " -.";
                    if (!Character.isLetterOrDigit(nextChar) && " -.".indexOf(nextChar) == -1) {
                        throw ServiceHosts.invalidAddress(strIdx, serviceAddresses);
                    }
                    if (currHostAndPort == null) {
                        currHostAndPort = new HostAndPort();
                        builder.add((Object)currHostAndPort);
                    }
                    fragment.append(nextChar);
                }
            }
        }
        if (parseState == 2 && currHostAndPort != null) {
            currHostAndPort.setPort(Integer.valueOf(fragment.toString().trim()));
        }
        return new ServiceHosts((List<HostAndPort>)builder.build());
    }

    public String toString() {
        return String.valueOf(this.getHostList());
    }

    public List<HostAndPort> getHostList() {
        return this.hostList;
    }

    @Override
    public Iterator<HostAndPort> iterator() {
        return this.hostList.iterator();
    }

    public int size() {
        return this.hostList.size();
    }
}

