/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.client.tests.rpc;

import com.mapr.client.impl.Cluster;
import com.mapr.client.impl.ClusterConf;
import com.mapr.client.impl.rpc.HostAndPort;
import com.mapr.client.tests.rpc.CldbConnectionTest;
import com.mapr.tests.BaseTest;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetClusterConfTest
extends BaseTest {
    private static final Logger logger = LoggerFactory.getLogger(CldbConnectionTest.class);

    @Test
    public void testGetClusterConf() throws IOException {
        Object str = "my.cluster.com   secure=false   192.168.1.1   191.23.65.2:4444\n\n";
        str = (String)str + "#cluster2 secure=true\t\t10.10.10.4:2555\n";
        str = (String)str + "my.cluster1.com   secure=true       clusters.mapr.com:0 cluster1.mapr.com:5555";
        BufferedReader br = new BufferedReader(new StringReader((String)str));
        ClusterConf cc = null;
        cc = ClusterConf.parseClusterConfEntries((BufferedReader)br);
        logger.debug("ClusterConf: \n{}", (Object)cc.asClusterConfFileString());
        Assert.assertEquals((Object)((Cluster)cc.getClusters().get(0)).getClusterName(), (Object)"my.cluster.com");
        Assert.assertFalse((boolean)((Cluster)cc.getClusters().get(0)).isSecure());
        Assert.assertEquals((Object)((HostAndPort)((Cluster)cc.getClusters().get(0)).getCldbHosts().getHostList().get(0)).getHost(), (Object)"192.168.1.1");
        Assert.assertEquals((long)((HostAndPort)((Cluster)cc.getClusters().get(0)).getCldbHosts().getHostList().get(0)).getPort(), (long)7222L);
        Assert.assertEquals((Object)((HostAndPort)((Cluster)cc.getClusters().get(0)).getCldbHosts().getHostList().get(1)).getHost(), (Object)"191.23.65.2");
        Assert.assertEquals((long)((HostAndPort)((Cluster)cc.getClusters().get(0)).getCldbHosts().getHostList().get(1)).getPort(), (long)4444L);
        Assert.assertEquals((Object)((Cluster)cc.getClusters().get(1)).getClusterName(), (Object)"my.cluster1.com");
        Assert.assertTrue((boolean)((Cluster)cc.getClusters().get(1)).isSecure());
        Assert.assertEquals((Object)((HostAndPort)((Cluster)cc.getClusters().get(1)).getCldbHosts().getHostList().get(0)).getHost(), (Object)"clusters.mapr.com");
        Assert.assertEquals((long)((HostAndPort)((Cluster)cc.getClusters().get(1)).getCldbHosts().getHostList().get(0)).getPort(), (long)0L);
        Assert.assertEquals((Object)((HostAndPort)((Cluster)cc.getClusters().get(1)).getCldbHosts().getHostList().get(1)).getHost(), (Object)"cluster1.mapr.com");
        Assert.assertEquals((long)((HostAndPort)((Cluster)cc.getClusters().get(1)).getCldbHosts().getHostList().get(1)).getPort(), (long)5555L);
        cc = ClusterConf.getClusterConf((String)"localhost:7222");
        logger.debug("ClusterConf: \n{}", (Object)cc.asClusterConfFileString());
        Assert.assertEquals((Object)((Cluster)cc.getClusters().get(0)).getClusterName(), (Object)"default");
        Assert.assertFalse((boolean)((Cluster)cc.getClusters().get(0)).isSecure());
        Assert.assertEquals((Object)((HostAndPort)((Cluster)cc.getClusters().get(0)).getCldbHosts().getHostList().get(0)).getHost(), (Object)"localhost");
        Assert.assertEquals((long)((HostAndPort)((Cluster)cc.getClusters().get(0)).getCldbHosts().getHostList().get(0)).getPort(), (long)7222L);
    }
}

